/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.AsyncConnectionConfiguration;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, SmallTests.class})
public class TestAsyncConnectionConfiguration {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncConnectionConfiguration.class);

    @Test
    public void itHandlesDeprecatedPauseForCQTBE() {
        Configuration conf = new Configuration();
        long timeoutMs = 1000L;
        conf.setLong("hbase.client.pause.cqtbe", timeoutMs);
        AsyncConnectionConfiguration config = new AsyncConnectionConfiguration(conf);
        Assert.assertTrue((boolean)Configuration.isDeprecated((String)"hbase.client.pause.cqtbe"));
        long expected = TimeUnit.MILLISECONDS.toNanos(timeoutMs);
        Assert.assertEquals((long)expected, (long)config.getPauseNsForServerOverloaded());
        conf = new Configuration();
        conf.setLong("hbase.client.pause.server.overloaded", timeoutMs);
        config = new AsyncConnectionConfiguration(conf);
        Assert.assertEquals((long)expected, (long)config.getPauseNsForServerOverloaded());
    }

    @Test
    public void testDefaultReadWriteRpcTimeout() {
        Configuration conf = HBaseConfiguration.create();
        long timeoutMs = 1000L;
        conf.setLong("hbase.rpc.timeout", timeoutMs);
        AsyncConnectionConfiguration config = new AsyncConnectionConfiguration(conf);
        long expected = TimeUnit.MILLISECONDS.toNanos(timeoutMs);
        Assert.assertEquals((long)expected, (long)config.getRpcTimeoutNs());
        Assert.assertEquals((long)expected, (long)config.getReadRpcTimeoutNs());
        Assert.assertEquals((long)expected, (long)config.getWriteRpcTimeoutNs());
    }
}

