/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.testing.junit4.OpenTelemetryRule;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.DoNothingConnectionRegistry;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.trace.HBaseSemanticAttributes;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, MediumTests.class})
public class TestAsyncConnectionTracing {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncConnectionTracing.class);
    private static Configuration CONF = HBaseConfiguration.create();
    private ServerName masterServer = ServerName.valueOf((String)"localhost", (int)12345, (long)System.currentTimeMillis());
    private AsyncConnection conn;
    @Rule
    public OpenTelemetryRule traceRule = OpenTelemetryRule.create();

    @Before
    public void setUp() throws IOException {
        DoNothingConnectionRegistry registry = new DoNothingConnectionRegistry(CONF){

            @Override
            public CompletableFuture<ServerName> getActiveMaster() {
                return CompletableFuture.completedFuture(TestAsyncConnectionTracing.this.masterServer);
            }
        };
        this.conn = new AsyncConnectionImpl(CONF, (ConnectionRegistry)registry, "test", UserProvider.instantiate((Configuration)CONF).getCurrent());
    }

    @After
    public void tearDown() throws IOException {
        Closeables.close((Closeable)this.conn, (boolean)true);
    }

    private void assertTrace(String methodName, ServerName serverName) {
        Waiter.waitFor((Configuration)CONF, (long)1000L, () -> this.traceRule.getSpans().stream().anyMatch(span -> span.getName().equals("AsyncConnection." + methodName) && span.getKind() == SpanKind.INTERNAL && span.hasEnded()));
        SpanData data = this.traceRule.getSpans().stream().filter(s -> s.getName().equals("AsyncConnection." + methodName)).findFirst().get();
        Assert.assertEquals((Object)StatusCode.OK, (Object)data.getStatus().getStatusCode());
        if (serverName != null) {
            Assert.assertEquals((Object)serverName.getServerName(), (Object)data.getAttributes().get(HBaseSemanticAttributes.SERVER_NAME_KEY));
        }
    }

    @Test
    public void testHbck() {
        this.conn.getHbck().join();
        this.assertTrace("getHbck", this.masterServer);
    }

    @Test
    public void testHbckWithServerName() throws IOException {
        ServerName serverName = ServerName.valueOf((String)"localhost", (int)23456, (long)System.currentTimeMillis());
        this.conn.getHbck(serverName);
        this.assertTrace("getHbck", serverName);
    }

    @Test
    public void testClose() throws IOException {
        this.conn.close();
        this.assertTrace("close", null);
    }
}

