/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.testing.junit4.OpenTelemetryRule;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MatcherPredicate;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.DoNothingConnectionRegistry;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.trace.hamcrest.AttributesMatchers;
import org.apache.hadoop.hbase.client.trace.hamcrest.SpanDataMatchers;
import org.apache.hadoop.hbase.client.trace.hamcrest.TraceTestUtil;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClientTests.class, MediumTests.class})
public class TestAsyncRegionLocatorTracing {
    private static final Logger LOG = LoggerFactory.getLogger(TestAsyncRegionLocatorTracing.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncRegionLocatorTracing.class);
    private static final Configuration CONF = HBaseConfiguration.create();
    private AsyncConnectionImpl conn;
    private RegionLocations locs;
    @Rule
    public OpenTelemetryRule traceRule = OpenTelemetryRule.create();

    @Before
    public void setUp() throws IOException {
        RegionInfo metaRegionInfo = RegionInfoBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).build();
        this.locs = new RegionLocations(new HRegionLocation[]{new HRegionLocation(metaRegionInfo, ServerName.valueOf((String)"127.0.0.1", (int)12345, (long)System.currentTimeMillis())), new HRegionLocation(RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)metaRegionInfo, (int)1), ServerName.valueOf((String)"127.0.0.2", (int)12345, (long)System.currentTimeMillis())), new HRegionLocation(RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)metaRegionInfo, (int)2), ServerName.valueOf((String)"127.0.0.3", (int)12345, (long)System.currentTimeMillis()))});
        this.conn = new AsyncConnectionImpl(CONF, (ConnectionRegistry)new DoNothingConnectionRegistry(CONF){

            @Override
            public CompletableFuture<RegionLocations> getMetaRegionLocations() {
                return CompletableFuture.completedFuture(TestAsyncRegionLocatorTracing.this.locs);
            }
        }, "test", UserProvider.instantiate((Configuration)CONF).getCurrent());
    }

    @After
    public void tearDown() throws IOException {
        Closeables.close((Closeable)this.conn, (boolean)true);
    }

    private SpanData waitSpan(String name) {
        return this.waitSpan(SpanDataMatchers.hasName(name));
    }

    private SpanData waitSpan(Matcher<SpanData> matcher) {
        Matcher spanLocator = Matchers.allOf(matcher, SpanDataMatchers.hasEnded());
        try {
            Waiter.waitFor((Configuration)CONF, (long)1000L, (Waiter.Predicate)new MatcherPredicate("waiting for span", () -> this.traceRule.getSpans(), Matchers.hasItem((Matcher)spanLocator)));
        }
        catch (AssertionError e) {
            LOG.error("AssertionError while waiting for matching span. Span reservoir contains: {}", (Object)this.traceRule.getSpans());
            throw e;
        }
        return this.traceRule.getSpans().stream().filter(arg_0 -> ((Matcher)spanLocator).matches(arg_0)).findFirst().orElseThrow(AssertionError::new);
    }

    @Test
    public void testClearCache() {
        this.conn.getLocator().clearCache();
        SpanData span = this.waitSpan("AsyncRegionLocator.clearCache");
        MatcherAssert.assertThat((Object)span, (Matcher)Matchers.allOf(SpanDataMatchers.hasStatusWithCode(StatusCode.OK), SpanDataMatchers.hasKind(SpanKind.INTERNAL), TraceTestUtil.buildConnectionAttributesMatcher(this.conn)));
    }

    @Test
    public void testClearCacheServerName() {
        ServerName sn = ServerName.valueOf((String)"127.0.0.1", (int)12345, (long)System.currentTimeMillis());
        this.conn.getLocator().clearCache(sn);
        SpanData span = this.waitSpan("AsyncRegionLocator.clearCache");
        MatcherAssert.assertThat((Object)span, (Matcher)Matchers.allOf(SpanDataMatchers.hasStatusWithCode(StatusCode.OK), SpanDataMatchers.hasKind(SpanKind.INTERNAL), TraceTestUtil.buildConnectionAttributesMatcher(this.conn), SpanDataMatchers.hasAttributes(AttributesMatchers.containsEntry("db.hbase.server.name", sn.getServerName()))));
    }

    @Test
    public void testClearCacheTableName() {
        this.conn.getLocator().clearCache(TableName.META_TABLE_NAME);
        SpanData span = this.waitSpan("AsyncRegionLocator.clearCache");
        MatcherAssert.assertThat((Object)span, (Matcher)Matchers.allOf(SpanDataMatchers.hasStatusWithCode(StatusCode.OK), SpanDataMatchers.hasKind(SpanKind.INTERNAL), TraceTestUtil.buildConnectionAttributesMatcher(this.conn), TraceTestUtil.buildTableAttributesMatcher(TableName.META_TABLE_NAME)));
    }

    @Test
    public void testGetRegionLocation() {
        this.conn.getLocator().getRegionLocation(TableName.META_TABLE_NAME, HConstants.EMPTY_START_ROW, RegionLocateType.CURRENT, TimeUnit.SECONDS.toNanos(1L)).join();
        SpanData span = this.waitSpan("AsyncRegionLocator.getRegionLocation");
        MatcherAssert.assertThat((Object)span, (Matcher)Matchers.allOf(SpanDataMatchers.hasStatusWithCode(StatusCode.OK), SpanDataMatchers.hasKind(SpanKind.INTERNAL), TraceTestUtil.buildConnectionAttributesMatcher(this.conn), TraceTestUtil.buildTableAttributesMatcher(TableName.META_TABLE_NAME), SpanDataMatchers.hasAttributes(AttributesMatchers.containsEntryWithStringValuesOf("db.hbase.regions", this.locs.getDefaultRegionLocation().getRegion().getRegionNameAsString()))));
    }

    @Test
    public void testGetRegionLocations() {
        this.conn.getLocator().getRegionLocations(TableName.META_TABLE_NAME, HConstants.EMPTY_START_ROW, RegionLocateType.CURRENT, false, TimeUnit.SECONDS.toNanos(1L)).join();
        SpanData span = this.waitSpan("AsyncRegionLocator.getRegionLocations");
        Object[] expectedRegions = (String[])Arrays.stream(this.locs.getRegionLocations()).map(HRegionLocation::getRegion).map(RegionInfo::getRegionNameAsString).toArray(String[]::new);
        MatcherAssert.assertThat((Object)span, (Matcher)Matchers.allOf(SpanDataMatchers.hasStatusWithCode(StatusCode.OK), SpanDataMatchers.hasKind(SpanKind.INTERNAL), TraceTestUtil.buildConnectionAttributesMatcher(this.conn), TraceTestUtil.buildTableAttributesMatcher(TableName.META_TABLE_NAME), SpanDataMatchers.hasAttributes(AttributesMatchers.containsEntryWithStringValuesOf("db.hbase.regions", (Matcher<Iterable<? extends String>>)Matchers.containsInAnyOrder((Object[])expectedRegions)))));
    }
}

