/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.testing.junit4.OpenTelemetryRule;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MatcherPredicate;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncRegionLocator;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.CheckAndMutate;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.DoNothingConnectionRegistry;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScanResultConsumer;
import org.apache.hadoop.hbase.client.ScanResultConsumerBase;
import org.apache.hadoop.hbase.client.trace.hamcrest.AttributesMatchers;
import org.apache.hadoop.hbase.client.trace.hamcrest.SpanDataMatchers;
import org.apache.hadoop.hbase.client.trace.hamcrest.TraceTestUtil;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsAnything;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={ClientTests.class, MediumTests.class})
public class TestAsyncTableTracing {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTableTracing.class);
    private static Configuration CONF = HBaseConfiguration.create();
    private ClientProtos.ClientService.Interface stub;
    private AsyncConnectionImpl conn;
    private AsyncTable<ScanResultConsumer> table;
    @Rule
    public OpenTelemetryRule traceRule = OpenTelemetryRule.create();

    @Before
    public void setUp() throws IOException {
        this.stub = (ClientProtos.ClientService.Interface)Mockito.mock(ClientProtos.ClientService.Interface.class);
        final AtomicInteger scanNextCalled = new AtomicInteger(0);
        ((ClientProtos.ClientService.Interface)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ClientProtos.ScanRequest req = (ClientProtos.ScanRequest)invocation.getArgument(1);
                RpcCallback done = (RpcCallback)invocation.getArgument(2);
                if (!req.hasScannerId()) {
                    done.run((Object)ClientProtos.ScanResponse.newBuilder().setScannerId(1L).setTtl(800).setMoreResultsInRegion(true).setMoreResults(true).build());
                } else if (req.hasCloseScanner() && req.getCloseScanner()) {
                    done.run((Object)ClientProtos.ScanResponse.getDefaultInstance());
                } else {
                    Cell cell = CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setType(Cell.Type.Put).setRow(Bytes.toBytes((int)scanNextCalled.incrementAndGet())).setFamily(Bytes.toBytes((String)"cf")).setQualifier(Bytes.toBytes((String)"cq")).setValue(Bytes.toBytes((String)"v")).build();
                    Result result = Result.create(Arrays.asList(cell));
                    ClientProtos.ScanResponse.Builder builder = ClientProtos.ScanResponse.newBuilder().setScannerId(1L).setTtl(800).addResults(ProtobufUtil.toResult((Result)result));
                    if (req.getLimitOfRows() == 1) {
                        builder.setMoreResultsInRegion(false).setMoreResults(false);
                    } else {
                        builder.setMoreResultsInRegion(true).setMoreResults(true);
                    }
                    ForkJoinPool.commonPool().execute(() -> done.run((Object)builder.build()));
                }
                return null;
            }
        }).when((Object)this.stub)).scan((RpcController)ArgumentMatchers.any(HBaseRpcController.class), (ClientProtos.ScanRequest)ArgumentMatchers.any(ClientProtos.ScanRequest.class), (RpcCallback)ArgumentMatchers.any());
        ((ClientProtos.ClientService.Interface)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ClientProtos.MultiRequest req = (ClientProtos.MultiRequest)invocation.getArgument(1);
                ClientProtos.MultiResponse.Builder builder = ClientProtos.MultiResponse.newBuilder();
                for (ClientProtos.RegionAction regionAction : req.getRegionActionList()) {
                    ClientProtos.RegionActionResult.Builder raBuilder = ClientProtos.RegionActionResult.newBuilder();
                    for (ClientProtos.Action ignored : regionAction.getActionList()) {
                        raBuilder.addResultOrException(ClientProtos.ResultOrException.newBuilder().setResult(ProtobufUtil.toResult((Result)new Result())));
                    }
                    builder.addRegionActionResult(raBuilder);
                }
                ClientProtos.MultiResponse resp = builder.build();
                RpcCallback done = (RpcCallback)invocation.getArgument(2);
                ForkJoinPool.commonPool().execute(() -> done.run((Object)resp));
                return null;
            }
        }).when((Object)this.stub)).multi((RpcController)ArgumentMatchers.any(HBaseRpcController.class), (ClientProtos.MultiRequest)ArgumentMatchers.any(ClientProtos.MultiRequest.class), (RpcCallback)ArgumentMatchers.any());
        ((ClientProtos.ClientService.Interface)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ClientProtos.MutateResponse resp;
                ClientProtos.MutationProto req = ((ClientProtos.MutateRequest)invocation.getArgument(1)).getMutation();
                switch (req.getMutateType()) {
                    case INCREMENT: {
                        ClientProtos.MutationProto.ColumnValue value = req.getColumnValue(0);
                        ClientProtos.MutationProto.ColumnValue.QualifierValue qvalue = value.getQualifierValue(0);
                        Cell cell = CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setType(Cell.Type.Put).setRow(req.getRow().toByteArray()).setFamily(value.getFamily().toByteArray()).setQualifier(qvalue.getQualifier().toByteArray()).setValue(qvalue.getValue().toByteArray()).build();
                        resp = ClientProtos.MutateResponse.newBuilder().setResult(ProtobufUtil.toResult((Result)Result.create(Arrays.asList(cell)))).build();
                        break;
                    }
                    default: {
                        resp = ClientProtos.MutateResponse.getDefaultInstance();
                    }
                }
                RpcCallback done = (RpcCallback)invocation.getArgument(2);
                ForkJoinPool.commonPool().execute(() -> done.run((Object)resp));
                return null;
            }
        }).when((Object)this.stub)).mutate((RpcController)ArgumentMatchers.any(HBaseRpcController.class), (ClientProtos.MutateRequest)ArgumentMatchers.any(ClientProtos.MutateRequest.class), (RpcCallback)ArgumentMatchers.any());
        ((ClientProtos.ClientService.Interface)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                RpcCallback done = (RpcCallback)invocation.getArgument(2);
                ForkJoinPool.commonPool().execute(() -> done.run((Object)ClientProtos.GetResponse.getDefaultInstance()));
                return null;
            }
        }).when((Object)this.stub)).get((RpcController)ArgumentMatchers.any(HBaseRpcController.class), (ClientProtos.GetRequest)ArgumentMatchers.any(ClientProtos.GetRequest.class), (RpcCallback)ArgumentMatchers.any());
        User user = UserProvider.instantiate((Configuration)CONF).getCurrent();
        this.conn = new AsyncConnectionImpl(CONF, new DoNothingConnectionRegistry(CONF), "test", user){

            AsyncRegionLocator getLocator() {
                AsyncRegionLocator locator = (AsyncRegionLocator)Mockito.mock(AsyncRegionLocator.class);
                Answer<CompletableFuture<HRegionLocation>> answer = new Answer<CompletableFuture<HRegionLocation>>(){

                    public CompletableFuture<HRegionLocation> answer(InvocationOnMock invocation) throws Throwable {
                        TableName tableName = (TableName)invocation.getArgument(0);
                        RegionInfo info = RegionInfoBuilder.newBuilder((TableName)tableName).build();
                        ServerName serverName = ServerName.valueOf((String)"rs", (int)16010, (long)12345L);
                        HRegionLocation loc = new HRegionLocation(info, serverName);
                        return CompletableFuture.completedFuture(loc);
                    }
                };
                ((AsyncRegionLocator)Mockito.doAnswer((Answer)answer).when((Object)locator)).getRegionLocation((TableName)ArgumentMatchers.any(TableName.class), (byte[])ArgumentMatchers.any(byte[].class), (RegionLocateType)ArgumentMatchers.any(RegionLocateType.class), ArgumentMatchers.anyLong());
                ((AsyncRegionLocator)Mockito.doAnswer((Answer)answer).when((Object)locator)).getRegionLocation((TableName)ArgumentMatchers.any(TableName.class), (byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyInt(), (RegionLocateType)ArgumentMatchers.any(RegionLocateType.class), ArgumentMatchers.anyLong());
                return locator;
            }

            ClientProtos.ClientService.Interface getRegionServerStub(ServerName serverName) throws IOException {
                return TestAsyncTableTracing.this.stub;
            }
        };
        this.table = this.conn.getTable(TableName.valueOf((String)"table"), (ExecutorService)ForkJoinPool.commonPool());
    }

    @After
    public void tearDown() throws IOException {
        Closeables.close((Closeable)this.conn, (boolean)true);
    }

    private void assertTrace(String tableOperation) {
        this.assertTrace(tableOperation, (Matcher<SpanData>)new IsAnything());
    }

    private void assertTrace(String tableOperation, Matcher<SpanData> matcher) {
        TableName tableName = this.table.getName();
        Matcher spanLocator = Matchers.allOf(SpanDataMatchers.hasName((Matcher<String>)Matchers.containsString((String)tableOperation)), SpanDataMatchers.hasEnded());
        String expectedName = tableOperation + " " + tableName.getNameWithNamespaceInclAsString();
        Waiter.waitFor((Configuration)CONF, (long)1000L, (Waiter.Predicate)new MatcherPredicate("waiting for span to emit", () -> this.traceRule.getSpans(), Matchers.hasItem((Matcher)spanLocator)));
        List candidateSpans = this.traceRule.getSpans().stream().filter(arg_0 -> ((Matcher)spanLocator).matches(arg_0)).collect(Collectors.toList());
        MatcherAssert.assertThat(candidateSpans, (Matcher)Matchers.hasSize((int)1));
        SpanData data = (SpanData)candidateSpans.iterator().next();
        MatcherAssert.assertThat((Object)data, (Matcher)Matchers.allOf(SpanDataMatchers.hasName(expectedName), SpanDataMatchers.hasKind(SpanKind.CLIENT), SpanDataMatchers.hasStatusWithCode(StatusCode.OK), TraceTestUtil.buildConnectionAttributesMatcher(this.conn), TraceTestUtil.buildTableAttributesMatcher(tableName), matcher));
    }

    @Test
    public void testExists() {
        this.table.exists(new Get(Bytes.toBytes((int)0))).join();
        this.assertTrace("GET");
    }

    @Test
    public void testGet() {
        this.table.get(new Get(Bytes.toBytes((int)0))).join();
        this.assertTrace("GET");
    }

    @Test
    public void testPut() {
        this.table.put(new Put(Bytes.toBytes((int)0)).addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v"))).join();
        this.assertTrace("PUT");
    }

    @Test
    public void testDelete() {
        this.table.delete(new Delete(Bytes.toBytes((int)0))).join();
        this.assertTrace("DELETE");
    }

    @Test
    public void testAppend() {
        this.table.append(new Append(Bytes.toBytes((int)0)).addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v"))).join();
        this.assertTrace("APPEND");
    }

    @Test
    public void testIncrement() {
        this.table.increment(new Increment(Bytes.toBytes((int)0)).addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), 1L)).join();
        this.assertTrace("INCREMENT");
    }

    @Test
    public void testIncrementColumnValue1() {
        this.table.incrementColumnValue(Bytes.toBytes((int)0), Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), 1L).join();
        this.assertTrace("INCREMENT");
    }

    @Test
    public void testIncrementColumnValue2() {
        this.table.incrementColumnValue(Bytes.toBytes((int)0), Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), 1L, Durability.ASYNC_WAL).join();
        this.assertTrace("INCREMENT");
    }

    @Test
    public void testCheckAndMutate() {
        this.table.checkAndMutate(CheckAndMutate.newBuilder((byte[])Bytes.toBytes((int)0)).ifEquals(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v")).build(new Delete(Bytes.toBytes((int)0)))).join();
        this.assertTrace("CHECK_AND_MUTATE");
    }

    @Test
    public void testCheckAndMutateList() {
        CompletableFuture.allOf(this.table.checkAndMutate(Arrays.asList(CheckAndMutate.newBuilder((byte[])Bytes.toBytes((int)0)).ifEquals(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v")).build(new Delete(Bytes.toBytes((int)0))))).toArray(new CompletableFuture[0])).join();
        this.assertTrace("BATCH", SpanDataMatchers.hasAttributes(AttributesMatchers.containsEntryWithStringValuesOf("db.hbase.container_operations", "CHECK_AND_MUTATE", "DELETE")));
    }

    @Test
    public void testCheckAndMutateAll() {
        this.table.checkAndMutateAll(Arrays.asList(CheckAndMutate.newBuilder((byte[])Bytes.toBytes((int)0)).ifEquals(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v")).build(new Delete(Bytes.toBytes((int)0))))).join();
        this.assertTrace("BATCH", SpanDataMatchers.hasAttributes(AttributesMatchers.containsEntryWithStringValuesOf("db.hbase.container_operations", "CHECK_AND_MUTATE", "DELETE")));
    }

    private void testCheckAndMutateBuilder(Row op) {
        AsyncTable.CheckAndMutateBuilder builder = this.table.checkAndMutate(Bytes.toBytes((int)0), Bytes.toBytes((String)"cf")).qualifier(Bytes.toBytes((String)"cq")).ifEquals(Bytes.toBytes((String)"v"));
        if (op instanceof Put) {
            Put put = (Put)op;
            builder.thenPut(put).join();
        } else if (op instanceof Delete) {
            Delete delete = (Delete)op;
            builder.thenDelete(delete).join();
        } else if (op instanceof RowMutations) {
            RowMutations mutations = (RowMutations)op;
            builder.thenMutate(mutations).join();
        } else {
            Assert.fail((String)("unsupported CheckAndPut operation " + op));
        }
        this.assertTrace("CHECK_AND_MUTATE");
    }

    @Test
    public void testCheckAndMutateBuilderThenPut() {
        Put put = new Put(Bytes.toBytes((int)0)).addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v"));
        this.testCheckAndMutateBuilder((Row)put);
    }

    @Test
    public void testCheckAndMutateBuilderThenDelete() {
        this.testCheckAndMutateBuilder((Row)new Delete(Bytes.toBytes((int)0)));
    }

    @Test
    public void testCheckAndMutateBuilderThenMutations() throws IOException {
        RowMutations mutations = new RowMutations(Bytes.toBytes((int)0)).add((Mutation)new Put(Bytes.toBytes((int)0)).addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v"))).add((Mutation)new Delete(Bytes.toBytes((int)0)));
        this.testCheckAndMutateBuilder((Row)mutations);
    }

    private void testCheckAndMutateWithFilterBuilder(Row op) {
        AsyncTable.CheckAndMutateWithFilterBuilder builder = this.table.checkAndMutate(Bytes.toBytes((int)0), (Filter)new PrefixFilter(Bytes.toBytes((int)0)));
        if (op instanceof Put) {
            Put put = (Put)op;
            builder.thenPut(put).join();
        } else if (op instanceof Delete) {
            Delete delete = (Delete)op;
            builder.thenDelete(delete).join();
        } else if (op instanceof RowMutations) {
            RowMutations mutations = (RowMutations)op;
            builder.thenMutate(mutations).join();
        } else {
            Assert.fail((String)("unsupported CheckAndPut operation " + op));
        }
        this.assertTrace("CHECK_AND_MUTATE");
    }

    @Test
    public void testCheckAndMutateWithFilterBuilderThenPut() {
        Put put = new Put(Bytes.toBytes((int)0)).addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v"));
        this.testCheckAndMutateWithFilterBuilder((Row)put);
    }

    @Test
    public void testCheckAndMutateWithFilterBuilderThenDelete() {
        this.testCheckAndMutateWithFilterBuilder((Row)new Delete(Bytes.toBytes((int)0)));
    }

    @Test
    public void testCheckAndMutateWithFilterBuilderThenMutations() throws IOException {
        RowMutations mutations = new RowMutations(Bytes.toBytes((int)0)).add((Mutation)new Put(Bytes.toBytes((int)0)).addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v"))).add((Mutation)new Delete(Bytes.toBytes((int)0)));
        this.testCheckAndMutateWithFilterBuilder((Row)mutations);
    }

    @Test
    public void testMutateRow() throws IOException {
        RowMutations mutations = new RowMutations(Bytes.toBytes((int)0)).add((Mutation)new Put(Bytes.toBytes((int)0)).addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v"))).add((Mutation)new Delete(Bytes.toBytes((int)0)));
        this.table.mutateRow(mutations).join();
        this.assertTrace("BATCH", SpanDataMatchers.hasAttributes(AttributesMatchers.containsEntryWithStringValuesOf("db.hbase.container_operations", "DELETE", "PUT")));
    }

    @Test
    public void testScanAll() {
        this.table.scanAll(new Scan().setCaching(1).setMaxResultSize(1L).setLimit(1)).join();
        this.assertTrace("SCAN");
    }

    @Test
    public void testScan() throws Throwable {
        final CountDownLatch doneSignal = new CountDownLatch(1);
        final AtomicInteger count = new AtomicInteger();
        final AtomicReference throwable = new AtomicReference();
        Scan scan = new Scan().setCaching(1).setMaxResultSize(1L).setLimit(1);
        this.table.scan(scan, (ScanResultConsumerBase)new ScanResultConsumer(){

            public boolean onNext(Result result) {
                if (result.getRow() != null) {
                    count.incrementAndGet();
                }
                return true;
            }

            public void onError(Throwable error) {
                throwable.set(error);
                doneSignal.countDown();
            }

            public void onComplete() {
                doneSignal.countDown();
            }
        });
        doneSignal.await();
        if (throwable.get() != null) {
            throw (Throwable)throwable.get();
        }
        MatcherAssert.assertThat((String)"user code did not run. check test setup.", (Object)count.get(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        this.assertTrace("SCAN");
    }

    @Test
    public void testGetScanner() {
        Scan scan = new Scan().setCaching(1).setMaxResultSize(1L).setLimit(1);
        try (ResultScanner scanner = this.table.getScanner(scan);){
            int count = 0;
            for (Result result : scanner) {
                if (result.getRow() == null) continue;
                ++count;
            }
            MatcherAssert.assertThat((Object)count, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0)));
        }
        this.assertTrace("SCAN");
    }

    @Test
    public void testExistsList() {
        CompletableFuture.allOf(this.table.exists(Arrays.asList(new Get(Bytes.toBytes((int)0)))).toArray(new CompletableFuture[0])).join();
        this.assertTrace("BATCH", SpanDataMatchers.hasAttributes(AttributesMatchers.containsEntryWithStringValuesOf("db.hbase.container_operations", "GET")));
    }

    @Test
    public void testExistsAll() {
        this.table.existsAll(Arrays.asList(new Get(Bytes.toBytes((int)0)))).join();
        this.assertTrace("BATCH", SpanDataMatchers.hasAttributes(AttributesMatchers.containsEntryWithStringValuesOf("db.hbase.container_operations", "GET")));
    }

    @Test
    public void testGetList() {
        CompletableFuture.allOf(this.table.get(Arrays.asList(new Get(Bytes.toBytes((int)0)))).toArray(new CompletableFuture[0])).join();
        this.assertTrace("BATCH", SpanDataMatchers.hasAttributes(AttributesMatchers.containsEntryWithStringValuesOf("db.hbase.container_operations", "GET")));
    }

    @Test
    public void testGetAll() {
        this.table.getAll(Arrays.asList(new Get(Bytes.toBytes((int)0)))).join();
        this.assertTrace("BATCH", SpanDataMatchers.hasAttributes(AttributesMatchers.containsEntryWithStringValuesOf("db.hbase.container_operations", "GET")));
    }

    @Test
    public void testPutList() {
        CompletableFuture.allOf(this.table.put(Arrays.asList(new Put(Bytes.toBytes((int)0)).addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v")))).toArray(new CompletableFuture[0])).join();
        this.assertTrace("BATCH", SpanDataMatchers.hasAttributes(AttributesMatchers.containsEntryWithStringValuesOf("db.hbase.container_operations", "PUT")));
    }

    @Test
    public void testPutAll() {
        this.table.putAll(Arrays.asList(new Put(Bytes.toBytes((int)0)).addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v")))).join();
        this.assertTrace("BATCH", SpanDataMatchers.hasAttributes(AttributesMatchers.containsEntryWithStringValuesOf("db.hbase.container_operations", "PUT")));
    }

    @Test
    public void testDeleteList() {
        CompletableFuture.allOf(this.table.delete(Arrays.asList(new Delete(Bytes.toBytes((int)0)))).toArray(new CompletableFuture[0])).join();
        this.assertTrace("BATCH", SpanDataMatchers.hasAttributes(AttributesMatchers.containsEntryWithStringValuesOf("db.hbase.container_operations", "DELETE")));
    }

    @Test
    public void testDeleteAll() {
        this.table.deleteAll(Arrays.asList(new Delete(Bytes.toBytes((int)0)))).join();
        this.assertTrace("BATCH", SpanDataMatchers.hasAttributes(AttributesMatchers.containsEntryWithStringValuesOf("db.hbase.container_operations", "DELETE")));
    }

    @Test
    public void testBatch() {
        CompletableFuture.allOf(this.table.batch(Arrays.asList(new Delete(Bytes.toBytes((int)0)))).toArray(new CompletableFuture[0])).join();
        this.assertTrace("BATCH", SpanDataMatchers.hasAttributes(AttributesMatchers.containsEntryWithStringValuesOf("db.hbase.container_operations", "DELETE")));
    }

    @Test
    public void testBatchAll() {
        this.table.batchAll(Arrays.asList(new Delete(Bytes.toBytes((int)0)))).join();
        this.assertTrace("BATCH", SpanDataMatchers.hasAttributes(AttributesMatchers.containsEntryWithStringValuesOf("db.hbase.container_operations", "DELETE")));
    }
}

