/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, SmallTests.class})
public class TestConnectionConfiguration {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestConnectionConfiguration.class);

    @Test
    public void itHandlesDeprecatedPauseForCQTBE() {
        Configuration conf = new Configuration();
        long timeoutMs = 1000L;
        conf.setLong("hbase.client.pause.cqtbe", timeoutMs);
        ConnectionConfiguration config = new ConnectionConfiguration(conf);
        Assert.assertTrue((boolean)Configuration.isDeprecated((String)"hbase.client.pause.cqtbe"));
        Assert.assertEquals((long)timeoutMs, (long)config.getPauseMillisForServerOverloaded());
        conf = new Configuration();
        conf.setLong("hbase.client.pause.server.overloaded", timeoutMs);
        config = new ConnectionConfiguration(conf);
        Assert.assertEquals((long)timeoutMs, (long)config.getPauseMillisForServerOverloaded());
    }
}

