/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.TestTracingBase;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, SmallTests.class})
public class TestConnectionFactoryTracing
extends TestTracingBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestConnectionFactoryTracing.class);
    private User currentUser;
    private Object connection;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.currentUser = UserProvider.instantiate((Configuration)this.conf).getCurrent();
        this.conf.set("hbase.client.registry.impl", TestTracingBase.RegistryForTracingTest.class.getName());
    }

    @After
    public void tearDown() throws IOException {
        Closeables.close((Closeable)((Closeable)this.connection), (boolean)true);
    }

    @Test
    public void testConnectionTracing() throws IOException {
        this.connection = ConnectionFactory.createConnection((Configuration)this.conf, (User)this.currentUser);
        this.assertTrace(ConnectionFactory.class.getSimpleName(), "createConnection", null, null);
    }

    @Test
    public void testAsyncConnectionTracing() throws IOException, ExecutionException, InterruptedException {
        this.connection = ConnectionFactory.createAsyncConnection((Configuration)this.conf, (User)this.currentUser).get();
        this.assertTrace(ConnectionFactory.class.getSimpleName(), "createAsyncConnection", null, null);
    }
}

