/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.TestTracingBase;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, SmallTests.class})
public class TestConnectionImplementationTracing
extends TestTracingBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestConnectionImplementationTracing.class);
    ConnectionImplementation conn;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.conn = new ConnectionImplementation(this.conf, null, UserProvider.instantiate((Configuration)this.conf).getCurrent());
    }

    @After
    public void tearDown() throws IOException {
        Closeables.close((Closeable)this.conn, (boolean)true);
    }

    @Test
    public void testHbck() throws IOException {
        this.conn.getHbck();
        this.assertTrace(ConnectionImplementation.class.getSimpleName(), "getHbck", MASTER_HOST, null);
    }

    @Test
    public void testHbckWithServerName() throws IOException {
        ServerName otherHost = ServerName.valueOf((String)"localhost2", (int)16010, (long)System.currentTimeMillis());
        this.conn.getHbck(otherHost);
        this.assertTrace(ConnectionImplementation.class.getSimpleName(), "getHbck", otherHost, null);
    }

    @Test
    public void testClose() throws IOException {
        this.conn.close();
        this.assertTrace(ConnectionImplementation.class.getSimpleName(), "close", null, null);
    }
}

