/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.CoprocessorDescriptor;
import org.apache.hadoop.hbase.client.CoprocessorDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MiscTests.class, SmallTests.class})
public class TestCoprocessorDescriptor {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCoprocessorDescriptor.class);
    @Rule
    public TestName name = new TestName();

    @Test
    public void testBuild() {
        String className = "className";
        String path = "path";
        int priority = 100;
        String propertyKey = "propertyKey";
        String propertyValue = "propertyValue";
        CoprocessorDescriptor cp = CoprocessorDescriptorBuilder.newBuilder((String)className).setJarPath(path).setPriority(priority).setProperty(propertyKey, propertyValue).build();
        Assert.assertEquals((Object)className, (Object)cp.getClassName());
        Assert.assertEquals((Object)path, cp.getJarPath().get());
        Assert.assertEquals((long)priority, (long)cp.getPriority());
        Assert.assertEquals((long)1L, (long)cp.getProperties().size());
        Assert.assertEquals((Object)propertyValue, cp.getProperties().get(propertyKey));
    }

    @Test
    public void testSetCoprocessor() throws IOException {
        String propertyKey = "propertyKey";
        ArrayList<CoprocessorDescriptor> cps = new ArrayList<CoprocessorDescriptor>();
        for (String className : Arrays.asList("className0", "className1", "className2")) {
            String path = "path";
            int priority = Math.abs(className.hashCode());
            String propertyValue = "propertyValue";
            cps.add(CoprocessorDescriptorBuilder.newBuilder((String)className).setJarPath(path).setPriority(priority).setProperty(propertyKey, propertyValue).build());
        }
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setCoprocessors(cps).build();
        for (CoprocessorDescriptor cp : cps) {
            boolean match = false;
            for (CoprocessorDescriptor that : tableDescriptor.getCoprocessorDescriptors()) {
                if (!cp.getClassName().equals(that.getClassName())) continue;
                Assert.assertEquals(cp.getJarPath().get(), that.getJarPath().get());
                Assert.assertEquals((long)cp.getPriority(), (long)that.getPriority());
                Assert.assertEquals((long)cp.getProperties().size(), (long)that.getProperties().size());
                Assert.assertEquals(cp.getProperties().get(propertyKey), that.getProperties().get(propertyKey));
                match = true;
                break;
            }
            if (match) continue;
            Assert.fail((String)("expect:" + cp + ", actual:" + tableDescriptor.getCoprocessorDescriptors()));
        }
    }
}

