/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MatcherPredicate;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.hadoop.hbase.client.AsyncProcessTask;
import org.apache.hadoop.hbase.client.AsyncRequestFuture;
import org.apache.hadoop.hbase.client.CheckAndMutate;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HRegionLocator;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TestTracingBase;
import org.apache.hadoop.hbase.client.trace.hamcrest.AttributesMatchers;
import org.apache.hadoop.hbase.client.trace.hamcrest.SpanDataMatchers;
import org.apache.hadoop.hbase.client.trace.hamcrest.TraceTestUtil;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsAnything;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={ClientTests.class, MediumTests.class})
public class TestHTableTracing
extends TestTracingBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHTableTracing.class);
    private ClientProtos.ClientService.BlockingInterface stub;
    private ConnectionImplementation conn;
    private Table table;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.stub = (ClientProtos.ClientService.BlockingInterface)Mockito.mock(ClientProtos.ClientService.BlockingInterface.class);
        final AtomicInteger scanNextCalled = new AtomicInteger(0);
        ((ClientProtos.ClientService.BlockingInterface)Mockito.doAnswer((Answer)new Answer<ClientProtos.ScanResponse>(){

            public ClientProtos.ScanResponse answer(InvocationOnMock invocation) throws Throwable {
                ClientProtos.ScanRequest req = (ClientProtos.ScanRequest)invocation.getArgument(1);
                if (!req.hasScannerId()) {
                    return ClientProtos.ScanResponse.newBuilder().setScannerId(1L).setTtl(800).setMoreResultsInRegion(true).setMoreResults(true).build();
                }
                if (req.hasCloseScanner() && req.getCloseScanner()) {
                    return ClientProtos.ScanResponse.getDefaultInstance();
                }
                Cell cell = CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setType(Cell.Type.Put).setRow(Bytes.toBytes((int)scanNextCalled.incrementAndGet())).setFamily(Bytes.toBytes((String)"cf")).setQualifier(Bytes.toBytes((String)"cq")).setValue(Bytes.toBytes((String)"v")).build();
                Result result = Result.create(Arrays.asList(cell));
                ClientProtos.ScanResponse.Builder builder = ClientProtos.ScanResponse.newBuilder().setScannerId(1L).setTtl(800).addResults(ProtobufUtil.toResult((Result)result));
                if (req.getLimitOfRows() == 1) {
                    builder.setMoreResultsInRegion(false).setMoreResults(false);
                } else {
                    builder.setMoreResultsInRegion(true).setMoreResults(true);
                }
                return builder.build();
            }
        }).when((Object)this.stub)).scan((RpcController)ArgumentMatchers.any(HBaseRpcController.class), (ClientProtos.ScanRequest)ArgumentMatchers.any(ClientProtos.ScanRequest.class));
        ((ClientProtos.ClientService.BlockingInterface)Mockito.doAnswer((Answer)new Answer<ClientProtos.MultiResponse>(){

            public ClientProtos.MultiResponse answer(InvocationOnMock invocation) throws Throwable {
                ClientProtos.MultiResponse resp = ClientProtos.MultiResponse.newBuilder().addRegionActionResult(ClientProtos.RegionActionResult.newBuilder().addResultOrException(ClientProtos.ResultOrException.newBuilder().setResult(ProtobufUtil.toResult((Result)new Result())))).build();
                return resp;
            }
        }).when((Object)this.stub)).multi((RpcController)ArgumentMatchers.any(HBaseRpcController.class), (ClientProtos.MultiRequest)ArgumentMatchers.any(ClientProtos.MultiRequest.class));
        ((ClientProtos.ClientService.BlockingInterface)Mockito.doAnswer((Answer)new Answer<ClientProtos.MutateResponse>(){

            public ClientProtos.MutateResponse answer(InvocationOnMock invocation) throws Throwable {
                ClientProtos.MutateResponse resp;
                ClientProtos.MutationProto req = ((ClientProtos.MutateRequest)invocation.getArgument(1)).getMutation();
                switch (req.getMutateType()) {
                    case INCREMENT: {
                        ClientProtos.MutationProto.ColumnValue value = req.getColumnValue(0);
                        ClientProtos.MutationProto.ColumnValue.QualifierValue qvalue = value.getQualifierValue(0);
                        Cell cell = CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setType(Cell.Type.Put).setRow(req.getRow().toByteArray()).setFamily(value.getFamily().toByteArray()).setQualifier(qvalue.getQualifier().toByteArray()).setValue(qvalue.getValue().toByteArray()).build();
                        resp = ClientProtos.MutateResponse.newBuilder().setResult(ProtobufUtil.toResult((Result)Result.create(Arrays.asList(cell)))).build();
                        break;
                    }
                    default: {
                        resp = ClientProtos.MutateResponse.getDefaultInstance();
                    }
                }
                return resp;
            }
        }).when((Object)this.stub)).mutate((RpcController)ArgumentMatchers.any(HBaseRpcController.class), (ClientProtos.MutateRequest)ArgumentMatchers.any(ClientProtos.MutateRequest.class));
        ((ClientProtos.ClientService.BlockingInterface)Mockito.doAnswer((Answer)new Answer<ClientProtos.GetResponse>(){

            public ClientProtos.GetResponse answer(InvocationOnMock invocation) throws Throwable {
                ClientProtos.Get req = ((ClientProtos.GetRequest)invocation.getArgument(1)).getGet();
                ClientProtos.MutationProto.ColumnValue value = ClientProtos.MutationProto.ColumnValue.getDefaultInstance();
                ClientProtos.MutationProto.ColumnValue.QualifierValue qvalue = ClientProtos.MutationProto.ColumnValue.QualifierValue.getDefaultInstance();
                Cell cell = CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setType(Cell.Type.Put).setRow(req.getRow().toByteArray()).setFamily(value.getFamily().toByteArray()).setQualifier(qvalue.getQualifier().toByteArray()).setValue(qvalue.getValue().toByteArray()).build();
                return ClientProtos.GetResponse.newBuilder().setResult(ProtobufUtil.toResult((Result)Result.create(Arrays.asList(cell), (Boolean)true))).build();
            }
        }).when((Object)this.stub)).get((RpcController)ArgumentMatchers.any(HBaseRpcController.class), (ClientProtos.GetRequest)ArgumentMatchers.any(ClientProtos.GetRequest.class));
        this.conn = (ConnectionImplementation)Mockito.spy((Object)new ConnectionImplementation(this.conf, null, UserProvider.instantiate((Configuration)this.conf).getCurrent()){

            public RegionLocator getRegionLocator(TableName tableName) throws IOException {
                RegionLocator locator = (RegionLocator)Mockito.mock(HRegionLocator.class);
                Answer<HRegionLocation> answer = new Answer<HRegionLocation>(){

                    public HRegionLocation answer(InvocationOnMock invocation) throws Throwable {
                        TableName tableName = TableName.META_TABLE_NAME;
                        RegionInfo info = RegionInfoBuilder.newBuilder((TableName)tableName).build();
                        ServerName serverName = TestTracingBase.MASTER_HOST;
                        HRegionLocation loc = new HRegionLocation(info, serverName);
                        return loc;
                    }
                };
                ((RegionLocator)Mockito.doAnswer((Answer)answer).when((Object)locator)).getRegionLocation((byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyBoolean());
                ((RegionLocator)Mockito.doAnswer((Answer)answer).when((Object)locator)).getRegionLocation((byte[])ArgumentMatchers.any(byte[].class));
                ((RegionLocator)Mockito.doAnswer((Answer)answer).when((Object)locator)).getRegionLocation((byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyInt());
                ((RegionLocator)Mockito.doAnswer((Answer)answer).when((Object)locator)).getRegionLocation((byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyBoolean());
                return locator;
            }

            public ClientProtos.ClientService.BlockingInterface getClient(ServerName serverName) throws IOException {
                return TestHTableTracing.this.stub;
            }
        });
        AsyncProcess asyncProcess = (AsyncProcess)Mockito.mock(AsyncProcess.class);
        AsyncRequestFuture asyncRequestFuture = (AsyncRequestFuture)Mockito.mock(AsyncRequestFuture.class);
        ((AsyncRequestFuture)Mockito.doNothing().when((Object)asyncRequestFuture)).waitUntilDone();
        ((AsyncProcess)Mockito.doReturn((Object)asyncRequestFuture).when((Object)asyncProcess)).submit((AsyncProcessTask)ArgumentMatchers.any());
        ((ConnectionImplementation)Mockito.doReturn((Object)asyncProcess).when((Object)this.conn)).getAsyncProcess();
        this.table = this.conn.getTable(TableName.META_TABLE_NAME, (ExecutorService)ForkJoinPool.commonPool());
    }

    @After
    public void tearDown() throws IOException {
        Closeables.close((Closeable)this.conn, (boolean)true);
    }

    private void assertTrace(String tableOperation) {
        this.assertTrace(tableOperation, (Matcher<SpanData>)new IsAnything());
    }

    private void assertTrace(String tableOperation, Matcher<SpanData> matcher) {
        TableName tableName = this.table.getName();
        Matcher spanLocator = Matchers.allOf(SpanDataMatchers.hasName((Matcher<String>)Matchers.containsString((String)tableOperation)), SpanDataMatchers.hasEnded());
        String expectedName = tableOperation + " " + tableName.getNameWithNamespaceInclAsString();
        Waiter.waitFor((Configuration)this.conf, (long)1000L, (Waiter.Predicate)new MatcherPredicate("waiting for span to emit", () -> TRACE_RULE.getSpans(), Matchers.hasItem((Matcher)spanLocator)));
        List candidateSpans = TRACE_RULE.getSpans().stream().filter(arg_0 -> ((Matcher)spanLocator).matches(arg_0)).collect(Collectors.toList());
        MatcherAssert.assertThat(candidateSpans, (Matcher)Matchers.hasSize((int)1));
        SpanData data = (SpanData)candidateSpans.iterator().next();
        MatcherAssert.assertThat((Object)data, (Matcher)Matchers.allOf(SpanDataMatchers.hasName(expectedName), SpanDataMatchers.hasKind(SpanKind.CLIENT), SpanDataMatchers.hasStatusWithCode(StatusCode.OK), TraceTestUtil.buildConnectionAttributesMatcher(this.conn), TraceTestUtil.buildTableAttributesMatcher(tableName), matcher));
    }

    @Test
    public void testPut() throws IOException {
        this.table.put(new Put(Bytes.toBytes((int)0)).addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v")));
        this.assertTrace("PUT");
    }

    @Test
    public void testExists() throws IOException {
        this.table.exists(new Get(Bytes.toBytes((int)0)));
        this.assertTrace("GET");
    }

    @Test
    public void testGet() throws IOException {
        this.table.get(new Get(Bytes.toBytes((int)0)));
        this.assertTrace("GET");
    }

    @Test
    public void testDelete() throws IOException {
        this.table.delete(new Delete(Bytes.toBytes((int)0)));
        this.assertTrace("DELETE");
    }

    @Test
    public void testAppend() throws IOException {
        this.table.append(new Append(Bytes.toBytes((int)0)).addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v")));
        this.assertTrace("APPEND");
    }

    @Test
    public void testIncrement() throws IOException {
        this.table.increment(new Increment(Bytes.toBytes((int)0)).addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), 1L));
        this.assertTrace("INCREMENT");
    }

    @Test
    public void testIncrementColumnValue1() throws IOException {
        this.table.incrementColumnValue(Bytes.toBytes((int)0), Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), 1L);
        this.assertTrace("INCREMENT");
    }

    @Test
    public void testIncrementColumnValue2() throws IOException {
        this.table.incrementColumnValue(Bytes.toBytes((int)0), Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), 1L, Durability.SYNC_WAL);
        this.assertTrace("INCREMENT");
    }

    @Test
    public void testCheckAndMutate() throws IOException {
        this.table.checkAndMutate(CheckAndMutate.newBuilder((byte[])Bytes.toBytes((int)0)).ifEquals(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v")).build(new Delete(Bytes.toBytes((int)0))));
        this.assertTrace("CHECK_AND_MUTATE", SpanDataMatchers.hasAttributes(AttributesMatchers.containsEntryWithStringValuesOf("db.hbase.container_operations", "CHECK_AND_MUTATE", "DELETE")));
    }

    @Test
    public void testCheckAndMutateList() throws IOException {
        this.table.checkAndMutate(Arrays.asList(CheckAndMutate.newBuilder((byte[])Bytes.toBytes((int)0)).ifEquals(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v")).build(new Delete(Bytes.toBytes((int)0)))));
        this.assertTrace("BATCH", SpanDataMatchers.hasAttributes(AttributesMatchers.containsEntryWithStringValuesOf("db.hbase.container_operations", "CHECK_AND_MUTATE", "DELETE")));
    }

    @Test
    public void testCheckAndMutateAll() throws IOException {
        this.table.checkAndMutate(Arrays.asList(CheckAndMutate.newBuilder((byte[])Bytes.toBytes((int)0)).ifEquals(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v")).build(new Delete(Bytes.toBytes((int)0)))));
        this.assertTrace("BATCH", SpanDataMatchers.hasAttributes(AttributesMatchers.containsEntryWithStringValuesOf("db.hbase.container_operations", "CHECK_AND_MUTATE", "DELETE")));
    }

    @Test
    public void testMutateRow() throws Exception {
        byte[] row = Bytes.toBytes((int)0);
        this.table.mutateRow(RowMutations.of(Arrays.asList(new Delete(row))));
        this.assertTrace("BATCH", SpanDataMatchers.hasAttributes(AttributesMatchers.containsEntryWithStringValuesOf("db.hbase.container_operations", "DELETE")));
    }

    @Test
    public void testExistsList() throws IOException {
        this.table.exists(Arrays.asList(new Get(Bytes.toBytes((int)0))));
        this.assertTrace("BATCH", SpanDataMatchers.hasAttributes(AttributesMatchers.containsEntryWithStringValuesOf("db.hbase.container_operations", "GET")));
    }

    @Test
    public void testExistsAll() throws IOException {
        this.table.existsAll(Arrays.asList(new Get(Bytes.toBytes((int)0))));
        this.assertTrace("BATCH", SpanDataMatchers.hasAttributes(AttributesMatchers.containsEntryWithStringValuesOf("db.hbase.container_operations", "GET")));
    }

    @Test
    public void testGetList() throws IOException {
        this.table.get(Arrays.asList(new Get(Bytes.toBytes((int)0))));
        this.assertTrace("BATCH", SpanDataMatchers.hasAttributes(AttributesMatchers.containsEntryWithStringValuesOf("db.hbase.container_operations", "GET")));
    }

    @Test
    public void testPutList() throws IOException {
        this.table.put(Arrays.asList(new Put(Bytes.toBytes((int)0)).addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"v"))));
        this.assertTrace("BATCH", SpanDataMatchers.hasAttributes(AttributesMatchers.containsEntryWithStringValuesOf("db.hbase.container_operations", "PUT")));
    }

    @Test
    public void testDeleteList() throws IOException {
        this.table.delete((List)Lists.newArrayList((Object[])new Delete[]{new Delete(Bytes.toBytes((int)0))}));
        this.assertTrace("BATCH", SpanDataMatchers.hasAttributes(AttributesMatchers.containsEntryWithStringValuesOf("db.hbase.container_operations", "DELETE")));
    }

    @Test
    public void testBatchList() throws IOException, InterruptedException {
        this.table.batch(Arrays.asList(new Delete(Bytes.toBytes((int)0))), null);
        this.assertTrace("BATCH", SpanDataMatchers.hasAttributes(AttributesMatchers.containsEntryWithStringValuesOf("db.hbase.container_operations", "DELETE")));
    }

    @Test
    public void testTableClose() throws IOException {
        this.table.close();
        this.assertTrace(HTable.class.getSimpleName(), "close", null, TableName.META_TABLE_NAME);
    }
}

