/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.codahale.metrics.Counter;
import com.codahale.metrics.RatioGauge;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.ipc.CallTimeoutException;
import org.apache.hadoop.hbase.ipc.RemoteWithExtrasException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MetricsTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={ClientTests.class, MetricsTests.class, SmallTests.class})
public class TestMetricsConnection {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetricsConnection.class);
    private static MetricsConnection METRICS;
    private static final ThreadPoolExecutor BATCH_POOL;
    private static final String MOCK_CONN_STR = "mocked-connection";

    @BeforeClass
    public static void beforeClass() {
        METRICS = MetricsConnection.getMetricsConnection((String)MOCK_CONN_STR, () -> BATCH_POOL, () -> null);
    }

    @AfterClass
    public static void afterClass() {
        MetricsConnection.deleteMetricsConnection((String)MOCK_CONN_STR);
    }

    @Test
    public void testMetricsConnectionScopeAsyncClient() throws IOException {
        Configuration conf = new Configuration();
        String clusterId = "foo";
        String scope = "testScope";
        conf.setBoolean("hbase.client.metrics.enable", true);
        AsyncConnectionImpl impl = new AsyncConnectionImpl(conf, null, "foo", User.getCurrent());
        Optional metrics = impl.getConnectionMetrics();
        Assert.assertTrue((String)"Metrics should be present", (boolean)metrics.isPresent());
        Assert.assertEquals((Object)(clusterId + "@" + Integer.toHexString(impl.hashCode())), (Object)((MetricsConnection)metrics.get()).getMetricScope());
        conf.set("hbase.client.metrics.scope", scope);
        impl = new AsyncConnectionImpl(conf, null, "foo", User.getCurrent());
        metrics = impl.getConnectionMetrics();
        Assert.assertTrue((String)"Metrics should be present", (boolean)metrics.isPresent());
        Assert.assertEquals((Object)scope, (Object)((MetricsConnection)metrics.get()).getMetricScope());
    }

    @Test
    public void testMetricsWithMutiConnections() throws IOException {
        AsyncConnectionImpl impl;
        Configuration conf = new Configuration();
        conf.setBoolean("hbase.client.metrics.enable", true);
        conf.set("hbase.client.metrics.scope", "unit-test");
        User user = User.getCurrent();
        int num = 3;
        ArrayList<AsyncConnectionImpl> connList = new ArrayList<AsyncConnectionImpl>();
        for (int i = 0; i < 3; ++i) {
            impl = new AsyncConnectionImpl(conf, null, null, user);
            connList.add(impl);
        }
        impl = (AsyncConnectionImpl)connList.get(0);
        Optional metrics = impl.getConnectionMetrics();
        Assert.assertTrue((String)"Metrics should be present", (boolean)metrics.isPresent());
        long count = ((MetricsConnection)metrics.get()).getConnectionCount();
        Assert.assertEquals((String)("Failed to verify connection count." + count), (long)count, (long)3L);
        for (int i = 0; i < 2; ++i) {
            ((AsyncConnectionImpl)connList.get(i)).close();
        }
        impl = (AsyncConnectionImpl)connList.get(2);
        metrics = impl.getConnectionMetrics();
        Assert.assertTrue((String)"Metrics should be present after some of connections are closed.", (boolean)metrics.isPresent());
        count = ((MetricsConnection)metrics.get()).getConnectionCount();
        Assert.assertEquals((String)("Connection count suppose to be 1 but got: " + count), (long)count, (long)1L);
        impl.close();
    }

    @Test
    public void testMetricsConnectionScopeBlockingClient() throws IOException {
        Configuration conf = new Configuration();
        String clusterId = "foo";
        String scope = "testScope";
        conf.setBoolean("hbase.client.metrics.enable", true);
        ConnectionRegistry mockRegistry = (ConnectionRegistry)Mockito.mock(ConnectionRegistry.class);
        Mockito.when((Object)mockRegistry.getClusterId()).thenReturn(CompletableFuture.completedFuture(clusterId));
        ConnectionImplementation impl = new ConnectionImplementation(conf, null, User.getCurrent(), mockRegistry);
        MetricsConnection metrics = impl.getConnectionMetrics();
        Assert.assertNotNull((String)"Metrics should be present", (Object)metrics);
        Assert.assertEquals((Object)(clusterId + "@" + Integer.toHexString(impl.hashCode())), (Object)metrics.getMetricScope());
        conf.set("hbase.client.metrics.scope", scope);
        impl = new ConnectionImplementation(conf, null, User.getCurrent(), mockRegistry);
        metrics = impl.getConnectionMetrics();
        Assert.assertNotNull((String)"Metrics should be present", (Object)metrics);
        Assert.assertEquals((Object)scope, (Object)metrics.getMetricScope());
    }

    @Test
    public void testStaticMetrics() throws IOException {
        Counter counter;
        long metricVal;
        String metricKey;
        byte[] foo = Bytes.toBytes((String)"foo");
        HBaseProtos.RegionSpecifier region = HBaseProtos.RegionSpecifier.newBuilder().setValue(ByteString.EMPTY).setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME).build();
        int loop = 5;
        for (int i = 0; i < 5; ++i) {
            METRICS.updateRpc(ClientProtos.ClientService.getDescriptor().findMethodByName("Get"), (Message)ClientProtos.GetRequest.getDefaultInstance(), MetricsConnection.newCallStats(), null);
            METRICS.updateRpc(ClientProtos.ClientService.getDescriptor().findMethodByName("Scan"), (Message)ClientProtos.ScanRequest.getDefaultInstance(), MetricsConnection.newCallStats(), (Throwable)new RemoteWithExtrasException("java.io.IOException", null, false, false));
            METRICS.updateRpc(ClientProtos.ClientService.getDescriptor().findMethodByName("Multi"), (Message)ClientProtos.MultiRequest.getDefaultInstance(), MetricsConnection.newCallStats(), (Throwable)new CallTimeoutException("test with CallTimeoutException"));
            METRICS.updateRpc(ClientProtos.ClientService.getDescriptor().findMethodByName("Mutate"), (Message)ClientProtos.MutateRequest.newBuilder().setMutation(ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.APPEND, (Mutation)new Append(foo))).setRegion(region).build(), MetricsConnection.newCallStats(), null);
            METRICS.updateRpc(ClientProtos.ClientService.getDescriptor().findMethodByName("Mutate"), (Message)ClientProtos.MutateRequest.newBuilder().setMutation(ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.DELETE, (Mutation)new Delete(foo))).setRegion(region).build(), MetricsConnection.newCallStats(), null);
            METRICS.updateRpc(ClientProtos.ClientService.getDescriptor().findMethodByName("Mutate"), (Message)ClientProtos.MutateRequest.newBuilder().setMutation(ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.INCREMENT, (Mutation)new Increment(foo))).setRegion(region).build(), MetricsConnection.newCallStats(), null);
            METRICS.updateRpc(ClientProtos.ClientService.getDescriptor().findMethodByName("Mutate"), (Message)ClientProtos.MutateRequest.newBuilder().setMutation(ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.PUT, (Mutation)new Put(foo))).setRegion(region).build(), MetricsConnection.newCallStats(), null);
        }
        String rpcCountPrefix = "rpcCount_" + ClientProtos.ClientService.getDescriptor().getName() + "_";
        String rpcFailureCountPrefix = "rpcFailureCount_" + ClientProtos.ClientService.getDescriptor().getName() + "_";
        for (String string : new String[]{"Get", "Scan", "Multi", "Mutate"}) {
            metricKey = rpcCountPrefix + string;
            metricVal = ((Counter)METRICS.getRpcCounters().get(metricKey)).getCount();
            Assert.assertTrue((String)("metric: " + metricKey + " val: " + metricVal), (metricVal >= 5L ? 1 : 0) != 0);
            metricKey = rpcFailureCountPrefix + string;
            counter = (Counter)METRICS.getRpcCounters().get(metricKey);
            long l = metricVal = counter != null ? counter.getCount() : 0L;
            if (string.equals("Get") || string.equals("Mutate")) {
                Assert.assertTrue((String)("metric: " + metricKey + " val: " + metricVal), (metricVal == 0L ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((String)("metric: " + metricKey + " val: " + metricVal), (metricVal == 5L ? 1 : 0) != 0);
        }
        metricKey = "rpcRemoteExceptions_IOException";
        counter = (Counter)METRICS.getRpcCounters().get(metricKey);
        metricVal = counter != null ? counter.getCount() : 0L;
        Assert.assertTrue((String)("metric: " + metricKey + " val: " + metricVal), (metricVal == 5L ? 1 : 0) != 0);
        metricKey = "rpcLocalExceptions_CallTimeoutException";
        counter = (Counter)METRICS.getRpcCounters().get(metricKey);
        metricVal = counter != null ? counter.getCount() : 0L;
        Assert.assertTrue((String)("metric: " + metricKey + " val: " + metricVal), (metricVal == 5L ? 1 : 0) != 0);
        metricKey = "rpcTotalExceptions";
        counter = (Counter)METRICS.getRpcCounters().get(metricKey);
        metricVal = counter != null ? counter.getCount() : 0L;
        Assert.assertTrue((String)("metric: " + metricKey + " val: " + metricVal), (metricVal == 10L ? 1 : 0) != 0);
        for (String string : new MetricsConnection.CallTracker[]{METRICS.getGetTracker(), METRICS.getScanTracker(), METRICS.getMultiTracker(), METRICS.getAppendTracker(), METRICS.getDeleteTracker(), METRICS.getIncrementTracker(), METRICS.getPutTracker()}) {
            Assert.assertEquals((String)("Failed to invoke callTimer on " + string), (long)5L, (long)((MetricsConnection.CallTracker)string).callTimer.getCount());
            Assert.assertEquals((String)("Failed to invoke reqHist on " + string), (long)5L, (long)((MetricsConnection.CallTracker)string).reqHist.getCount());
            Assert.assertEquals((String)("Failed to invoke respHist on " + string), (long)5L, (long)((MetricsConnection.CallTracker)string).respHist.getCount());
        }
        RatioGauge executorMetrics = (RatioGauge)METRICS.getMetricRegistry().getMetrics().get(METRICS.getExecutorPoolName());
        RatioGauge metaMetrics = (RatioGauge)METRICS.getMetricRegistry().getMetrics().get(METRICS.getMetaPoolName());
        Assert.assertEquals((double)RatioGauge.Ratio.of((double)0.0, (double)3.0).getValue(), (double)executorMetrics.getValue(), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)metaMetrics.getValue(), (double)0.0);
    }

    static {
        BATCH_POOL = (ThreadPoolExecutor)Executors.newFixedThreadPool(2);
    }
}

