/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.MD5Hash;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, SmallTests.class})
public class TestRegionInfoBuilder {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionInfoBuilder.class);
    @Rule
    public TableNameTestRule name = new TableNameTestRule();

    @Test
    public void testBuilder() {
        TableName tn = TableName.valueOf((String)"test");
        RegionInfoBuilder builder = RegionInfoBuilder.newBuilder((TableName)tn);
        byte[] startKey = Bytes.toBytes((String)"a");
        builder.setStartKey(startKey);
        byte[] endKey = Bytes.toBytes((String)"z");
        builder.setEndKey(endKey);
        int regionId = 1;
        builder.setRegionId(1L);
        int replicaId = 2;
        builder.setReplicaId(replicaId);
        boolean offline = true;
        builder.setOffline(offline);
        boolean isSplit = true;
        builder.setSplit(isSplit);
        RegionInfo ri = builder.build();
        Assert.assertEquals((Object)tn, (Object)ri.getTable());
        Assert.assertArrayEquals((byte[])startKey, (byte[])ri.getStartKey());
        Assert.assertArrayEquals((byte[])endKey, (byte[])ri.getEndKey());
        Assert.assertEquals((long)regionId, (long)ri.getRegionId());
        Assert.assertEquals((long)replicaId, (long)ri.getReplicaId());
        Assert.assertEquals((Object)offline, (Object)ri.isOffline());
        Assert.assertEquals((Object)isSplit, (Object)ri.isSplit());
    }

    @Test
    public void testPb() throws DeserializationException {
        RegionInfo ri = RegionInfoBuilder.FIRST_META_REGIONINFO;
        byte[] bytes = RegionInfo.toByteArray((RegionInfo)ri);
        RegionInfo pbri = RegionInfo.parseFrom((byte[])bytes);
        Assert.assertTrue((RegionInfo.COMPARATOR.compare(ri, pbri) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateRegionInfoName() throws Exception {
        TableName tn = this.name.getTableName();
        String startKey = "startkey";
        byte[] sk = Bytes.toBytes((String)startKey);
        String id = "id";
        byte[] name = RegionInfo.createRegionName((TableName)tn, (byte[])sk, (String)id, (boolean)false);
        String nameStr = Bytes.toString((byte[])name);
        Assert.assertEquals((Object)(tn + "," + startKey + "," + id), (Object)nameStr);
        String md5HashInHex = MD5Hash.getMD5AsHex((byte[])name);
        Assert.assertEquals((long)32L, (long)md5HashInHex.length());
        name = RegionInfo.createRegionName((TableName)tn, (byte[])sk, (String)id, (boolean)true);
        nameStr = Bytes.toString((byte[])name);
        Assert.assertEquals((Object)(tn + "," + startKey + "," + id + "." + md5HashInHex + "."), (Object)nameStr);
    }

    @Test
    public void testContainsRange() {
        TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableName)this.name.getTableName()).build();
        RegionInfo ri = RegionInfoBuilder.newBuilder((TableName)tableDesc.getTableName()).setStartKey(Bytes.toBytes((String)"a")).setEndKey(Bytes.toBytes((String)"g")).build();
        Assert.assertTrue((boolean)ri.containsRange(Bytes.toBytes((String)"a"), Bytes.toBytes((String)"a")));
        Assert.assertTrue((boolean)ri.containsRange(Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")));
        Assert.assertTrue((boolean)ri.containsRange(Bytes.toBytes((String)"a"), Bytes.toBytes((String)"c")));
        Assert.assertTrue((boolean)ri.containsRange(Bytes.toBytes((String)"c"), Bytes.toBytes((String)"c")));
        Assert.assertFalse((boolean)ri.containsRange(Bytes.toBytes((String)"a"), Bytes.toBytes((String)"g")));
        Assert.assertFalse((boolean)ri.containsRange(Bytes.toBytes((String)"g"), Bytes.toBytes((String)"g")));
        Assert.assertFalse((boolean)ri.containsRange(Bytes.toBytes((String)"z"), Bytes.toBytes((String)"z")));
        try {
            ri.containsRange(Bytes.toBytes((String)"z"), Bytes.toBytes((String)"a"));
            Assert.fail((String)"Invalid range did not throw IAE");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testContainsRangeForMetaTable() {
        TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).build();
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)tableDesc.getTableName()).build();
        byte[] startRow = HConstants.EMPTY_START_ROW;
        byte[] row1 = Bytes.toBytes((String)"a,a,0");
        byte[] row2 = Bytes.toBytes((String)"aaaaa,,1");
        byte[] row3 = Bytes.toBytes((String)"aaaaa,\u0000\u0000,2");
        byte[] row4 = Bytes.toBytes((String)"aaaaa,\u0001,3");
        byte[] row5 = Bytes.toBytes((String)"aaaaa,a,4");
        byte[] row6 = Bytes.toBytes((String)"aaaaa,\u1000,5");
        Assert.assertTrue((boolean)hri.containsRange(startRow, startRow));
        Assert.assertTrue((boolean)hri.containsRange(row1, row2));
        Assert.assertTrue((boolean)hri.containsRange(row2, row3));
        Assert.assertTrue((boolean)hri.containsRange(row3, row4));
        Assert.assertTrue((boolean)hri.containsRange(row4, row5));
        Assert.assertTrue((boolean)hri.containsRange(row5, row6));
        Assert.assertTrue((boolean)hri.containsRange(startRow, row2));
        Assert.assertTrue((boolean)hri.containsRange(row1, row1));
        try {
            hri.containsRange(row3, row2);
            Assert.fail((String)"Invalid range did not throw IAE");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testLastRegionCompare() {
        RegionInfo ric;
        TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableName)this.name.getTableName()).build();
        RegionInfo rip = RegionInfoBuilder.newBuilder((TableName)tableDesc.getTableName()).setStartKey(Bytes.toBytes((String)"a")).setEndKey(new byte[0]).build();
        Assert.assertTrue((RegionInfo.COMPARATOR.compare(rip, ric = RegionInfoBuilder.newBuilder((TableName)tableDesc.getTableName()).setStartKey(Bytes.toBytes((String)"a")).setEndKey(Bytes.toBytes((String)"b")).build()) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMetaTables() {
        Assert.assertTrue((boolean)RegionInfoBuilder.FIRST_META_REGIONINFO.isMetaRegion());
    }

    @Test
    public void testComparator() {
        RegionInfo newer;
        TableName tableName = this.name.getTableName();
        byte[] empty = new byte[]{};
        RegionInfo older = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(empty).setEndKey(empty).setSplit(false).setRegionId(0L).build();
        Assert.assertTrue((RegionInfo.COMPARATOR.compare(older, newer = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(empty).setEndKey(empty).setSplit(false).setRegionId(1L).build()) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((RegionInfo.COMPARATOR.compare(newer, older) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((RegionInfo.COMPARATOR.compare(older, older) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((RegionInfo.COMPARATOR.compare(newer, newer) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRegionNameForRegionReplicas() throws Exception {
        TableName tn = this.name.getTableName();
        String startKey = "startkey";
        byte[] sk = Bytes.toBytes((String)startKey);
        String id = "id";
        byte[] name = RegionInfo.createRegionName((TableName)tn, (byte[])sk, (byte[])Bytes.toBytes((String)id), (int)0, (boolean)false);
        String nameStr = Bytes.toString((byte[])name);
        Assert.assertEquals((Object)(tn + "," + startKey + "," + id), (Object)nameStr);
        name = RegionInfo.createRegionName((TableName)tn, (byte[])sk, (byte[])Bytes.toBytes((String)id), (int)1, (boolean)false);
        nameStr = Bytes.toString((byte[])name);
        Assert.assertEquals((Object)(tn + "," + startKey + "," + id + "_" + String.format("%04X", 1)), (Object)nameStr);
        name = RegionInfo.createRegionName((TableName)tn, (byte[])sk, (byte[])Bytes.toBytes((String)id), (int)65535, (boolean)false);
        nameStr = Bytes.toString((byte[])name);
        Assert.assertEquals((Object)(tn + "," + startKey + "," + id + "_" + String.format("%04X", 65535)), (Object)nameStr);
    }

    @Test
    public void testParseName() throws IOException {
        TableName tableName = this.name.getTableName();
        byte[] startKey = Bytes.toBytes((String)"startKey");
        long regionId = EnvironmentEdgeManager.currentTime();
        int replicaId = 42;
        byte[] regionName = RegionInfo.createRegionName((TableName)tableName, (byte[])startKey, (long)regionId, (boolean)false);
        byte[][] fields = RegionInfo.parseRegionName((byte[])regionName);
        Assert.assertArrayEquals((String)Bytes.toString((byte[])fields[0]), (byte[])tableName.getName(), (byte[])fields[0]);
        Assert.assertArrayEquals((String)Bytes.toString((byte[])fields[1]), (byte[])startKey, (byte[])fields[1]);
        Assert.assertArrayEquals((String)Bytes.toString((byte[])fields[2]), (byte[])Bytes.toBytes((String)Long.toString(regionId)), (byte[])fields[2]);
        Assert.assertEquals((long)3L, (long)fields.length);
        regionName = RegionInfo.createRegionName((TableName)tableName, (byte[])startKey, (long)regionId, (int)replicaId, (boolean)false);
        fields = RegionInfo.parseRegionName((byte[])regionName);
        Assert.assertArrayEquals((String)Bytes.toString((byte[])fields[0]), (byte[])tableName.getName(), (byte[])fields[0]);
        Assert.assertArrayEquals((String)Bytes.toString((byte[])fields[1]), (byte[])startKey, (byte[])fields[1]);
        Assert.assertArrayEquals((String)Bytes.toString((byte[])fields[2]), (byte[])Bytes.toBytes((String)Long.toString(regionId)), (byte[])fields[2]);
        Assert.assertArrayEquals((String)Bytes.toString((byte[])fields[3]), (byte[])Bytes.toBytes((String)String.format("%04X", replicaId)), (byte[])fields[3]);
    }

    @Test
    public void testConvert() {
        TableName tableName = TableName.valueOf((String)("ns1:" + this.name.getTableName().getQualifierAsString()));
        byte[] startKey = Bytes.toBytes((String)"startKey");
        byte[] endKey = Bytes.toBytes((String)"endKey");
        boolean split = false;
        long regionId = EnvironmentEdgeManager.currentTime();
        int replicaId = 42;
        RegionInfo ri = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(startKey).setEndKey(endKey).setSplit(split).setRegionId(regionId).setReplicaId(replicaId).build();
        RegionInfo convertedRi = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)ProtobufUtil.toRegionInfo((RegionInfo)ri));
        Assert.assertEquals((Object)ri, (Object)convertedRi);
        HBaseProtos.RegionInfo info = HBaseProtos.RegionInfo.newBuilder().setTableName(HBaseProtos.TableName.newBuilder().setQualifier(UnsafeByteOperations.unsafeWrap((byte[])tableName.getQualifier())).setNamespace(UnsafeByteOperations.unsafeWrap((byte[])tableName.getNamespace())).build()).setStartKey(UnsafeByteOperations.unsafeWrap((byte[])startKey)).setEndKey(UnsafeByteOperations.unsafeWrap((byte[])endKey)).setSplit(split).setRegionId(regionId).build();
        convertedRi = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)info);
        RegionInfo expectedRi = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(startKey).setEndKey(endKey).setSplit(split).setRegionId(regionId).setReplicaId(0).build();
        Assert.assertEquals((Object)expectedRi, (Object)convertedRi);
    }

    private void assertRegionNameNotEquals(RegionInfo expected, RegionInfo actual) {
        Assert.assertNotEquals((Object)expected.getRegionNameAsString(), (Object)actual.getRegionNameAsString());
        Assert.assertNotEquals((Object)expected.getEncodedName(), (Object)actual.getEncodedName());
    }

    private void assertRegionNameEquals(RegionInfo expected, RegionInfo actual) {
        Assert.assertEquals((Object)expected.getRegionNameAsString(), (Object)actual.getRegionNameAsString());
        Assert.assertEquals((Object)expected.getEncodedName(), (Object)actual.getEncodedName());
    }

    @Test
    public void testNewBuilderWithRegionInfo() {
        RegionInfo ri = RegionInfoBuilder.newBuilder((TableName)this.name.getTableName()).build();
        Assert.assertEquals((Object)ri, (Object)RegionInfoBuilder.newBuilder((RegionInfo)ri).build());
        this.assertRegionNameNotEquals(ri, RegionInfoBuilder.newBuilder((RegionInfo)ri).setStartKey(new byte[1]).build());
        this.assertRegionNameNotEquals(ri, RegionInfoBuilder.newBuilder((RegionInfo)ri).setRegionId(ri.getRegionId() + 1L).build());
        this.assertRegionNameNotEquals(ri, RegionInfoBuilder.newBuilder((RegionInfo)ri).setReplicaId(1).build());
        this.assertRegionNameEquals(ri, RegionInfoBuilder.newBuilder((RegionInfo)ri).setEndKey(new byte[1]).build());
        this.assertRegionNameEquals(ri, RegionInfoBuilder.newBuilder((RegionInfo)ri).setSplit(true).build());
        this.assertRegionNameEquals(ri, RegionInfoBuilder.newBuilder((RegionInfo)ri).setOffline(true).build());
    }
}

