/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionInfoDisplay;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, SmallTests.class})
public class TestRegionInfoDisplay {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionInfoDisplay.class);
    @Rule
    public TestName name = new TestName();

    @Test
    public void testRegionDetailsForDisplay() throws IOException {
        byte[] startKey = new byte[]{1, 1, 2, 3};
        byte[] endKey = new byte[]{1, 1, 2, 4};
        Configuration conf = new Configuration();
        conf.setBoolean("hbase.display.keys", false);
        RegionInfo ri = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey(startKey).setEndKey(endKey).build();
        this.checkEquality(ri, conf);
        ri = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey(startKey).setEndKey(endKey).setSplit(false).setRegionId(EnvironmentEdgeManager.currentTime()).setReplicaId(1).build();
        this.checkEquality(ri, conf);
        Assert.assertArrayEquals((byte[])RegionInfoDisplay.HIDDEN_END_KEY, (byte[])RegionInfoDisplay.getEndKeyForDisplay((RegionInfo)ri, (Configuration)conf));
        Assert.assertArrayEquals((byte[])RegionInfoDisplay.HIDDEN_START_KEY, (byte[])RegionInfoDisplay.getStartKeyForDisplay((RegionInfo)ri, (Configuration)conf));
        RegionState state = RegionState.createForTesting((RegionInfo)this.convert(ri), (RegionState.State)RegionState.State.OPEN);
        String descriptiveNameForDisplay = RegionInfoDisplay.getDescriptiveNameFromRegionStateForDisplay((RegionState)state, (Configuration)conf);
        String originalDescriptive = state.toDescriptiveString();
        this.checkDescriptiveNameEquality(descriptiveNameForDisplay, originalDescriptive, startKey);
        conf.setBoolean("hbase.display.keys", true);
        Assert.assertArrayEquals((byte[])endKey, (byte[])RegionInfoDisplay.getEndKeyForDisplay((RegionInfo)ri, (Configuration)conf));
        Assert.assertArrayEquals((byte[])startKey, (byte[])RegionInfoDisplay.getStartKeyForDisplay((RegionInfo)ri, (Configuration)conf));
        Assert.assertEquals((Object)originalDescriptive, (Object)RegionInfoDisplay.getDescriptiveNameFromRegionStateForDisplay((RegionState)state, (Configuration)conf));
    }

    private void checkDescriptiveNameEquality(String descriptiveNameForDisplay, String origDesc, byte[] startKey) {
        String firstPart = descriptiveNameForDisplay.substring(0, descriptiveNameForDisplay.indexOf(new String(RegionInfoDisplay.HIDDEN_START_KEY, StandardCharsets.UTF_8)));
        String secondPart = descriptiveNameForDisplay.substring(descriptiveNameForDisplay.indexOf(new String(RegionInfoDisplay.HIDDEN_START_KEY, StandardCharsets.UTF_8)) + RegionInfoDisplay.HIDDEN_START_KEY.length);
        String firstPartOrig = origDesc.substring(0, origDesc.indexOf(Bytes.toStringBinary((byte[])startKey)));
        String secondPartOrig = origDesc.substring(origDesc.indexOf(Bytes.toStringBinary((byte[])startKey)) + Bytes.toStringBinary((byte[])startKey).length());
        Assert.assertTrue((boolean)firstPart.equals(firstPartOrig));
        Assert.assertTrue((boolean)secondPart.equals(secondPartOrig));
    }

    private void checkEquality(RegionInfo ri, Configuration conf) throws IOException {
        byte[] modifiedRegionName = RegionInfoDisplay.getRegionNameForDisplay((RegionInfo)ri, (Configuration)conf);
        System.out.println(Bytes.toString((byte[])modifiedRegionName) + " " + ri.toString());
        byte[][] modifiedRegionNameParts = RegionInfo.parseRegionName((byte[])modifiedRegionName);
        byte[][] regionNameParts = RegionInfo.parseRegionName((byte[])ri.getRegionName());
        assert (modifiedRegionNameParts.length == regionNameParts.length);
        for (int i = 0; i < regionNameParts.length; ++i) {
            if (i != 1) {
                System.out.println("" + i + " " + Bytes.toString((byte[])regionNameParts[i]) + " " + Bytes.toString((byte[])modifiedRegionNameParts[i]));
                Assert.assertArrayEquals((byte[])regionNameParts[i], (byte[])modifiedRegionNameParts[i]);
                continue;
            }
            System.out.println("" + i + " " + Bytes.toString((byte[])regionNameParts[i]) + " " + Bytes.toString((byte[])modifiedRegionNameParts[i]));
            Assert.assertNotEquals((Object)regionNameParts[i], (Object)modifiedRegionNameParts[i]);
            Assert.assertArrayEquals((byte[])modifiedRegionNameParts[1], (byte[])RegionInfoDisplay.getStartKeyForDisplay((RegionInfo)ri, (Configuration)conf));
        }
    }

    private HRegionInfo convert(RegionInfo ri) {
        HRegionInfo hri = new HRegionInfo(ri.getTable(), ri.getStartKey(), ri.getEndKey(), ri.isSplit(), ri.getRegionId());
        hri.setOffline(ri.isOffline());
        return hri;
    }
}

