/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TestTracingBase;
import org.apache.hadoop.hbase.client.trace.hamcrest.AttributesMatchers;
import org.apache.hadoop.hbase.client.trace.hamcrest.SpanDataMatchers;
import org.apache.hadoop.hbase.client.trace.hamcrest.TraceTestUtil;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, MediumTests.class})
public class TestRegionLocatorTracing
extends TestTracingBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionLocatorTracing.class);
    ConnectionImplementation conn;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.conn = new ConnectionImplementation(this.conf, null, UserProvider.instantiate((Configuration)this.conf).getCurrent());
    }

    @After
    public void tearDown() throws IOException {
        Closeables.close((Closeable)this.conn, (boolean)true);
    }

    @Test
    public void testGetRegionLocation() throws IOException {
        this.conn.getRegionLocator(TableName.META_TABLE_NAME).getRegionLocation(HConstants.EMPTY_START_ROW);
        SpanData span = this.waitSpan("HRegionLocator.getRegionLocation");
        MatcherAssert.assertThat((Object)span, (Matcher)Matchers.allOf(SpanDataMatchers.hasStatusWithCode(StatusCode.OK), SpanDataMatchers.hasKind(SpanKind.INTERNAL), TraceTestUtil.buildConnectionAttributesMatcher(this.conn), TraceTestUtil.buildTableAttributesMatcher(TableName.META_TABLE_NAME), SpanDataMatchers.hasAttributes(AttributesMatchers.containsEntryWithStringValuesOf("db.hbase.regions", META_REGION_LOCATION.getDefaultRegionLocation().getRegion().getRegionNameAsString()))));
    }

    @Test
    public void testGetRegionLocations() throws IOException {
        this.conn.getRegionLocator(TableName.META_TABLE_NAME).getRegionLocations(HConstants.EMPTY_START_ROW);
        SpanData span = this.waitSpan("HRegionLocator.getRegionLocations");
        Object[] expectedRegions = (String[])Arrays.stream(META_REGION_LOCATION.getRegionLocations()).map(HRegionLocation::getRegion).map(RegionInfo::getRegionNameAsString).toArray(String[]::new);
        MatcherAssert.assertThat((Object)span, (Matcher)Matchers.allOf(SpanDataMatchers.hasStatusWithCode(StatusCode.OK), SpanDataMatchers.hasKind(SpanKind.INTERNAL), TraceTestUtil.buildConnectionAttributesMatcher(this.conn), TraceTestUtil.buildTableAttributesMatcher(TableName.META_TABLE_NAME), SpanDataMatchers.hasAttributes(AttributesMatchers.containsEntryWithStringValuesOf("db.hbase.regions", (Matcher<Iterable<? extends String>>)Matchers.containsInAnyOrder((Object[])expectedRegions)))));
    }

    @Test
    public void testGetAllRegionLocations() throws IOException {
        this.conn.getRegionLocator(TableName.META_TABLE_NAME).getAllRegionLocations();
        SpanData span = this.waitSpan("HRegionLocator.getAllRegionLocations");
        Object[] expectedRegions = (String[])Arrays.stream(META_REGION_LOCATION.getRegionLocations()).map(HRegionLocation::getRegion).map(RegionInfo::getRegionNameAsString).toArray(String[]::new);
        MatcherAssert.assertThat((Object)span, (Matcher)Matchers.allOf(SpanDataMatchers.hasStatusWithCode(StatusCode.OK), SpanDataMatchers.hasKind(SpanKind.INTERNAL), TraceTestUtil.buildConnectionAttributesMatcher(this.conn), TraceTestUtil.buildTableAttributesMatcher(TableName.META_TABLE_NAME), SpanDataMatchers.hasAttributes(AttributesMatchers.containsEntryWithStringValuesOf("db.hbase.regions", (Matcher<Iterable<? extends String>>)Matchers.containsInAnyOrder((Object[])expectedRegions)))));
    }

    @Test
    public void testClearRegionLocationCache() throws IOException {
        this.conn.getRegionLocator(TableName.META_TABLE_NAME).clearRegionLocationCache();
        SpanData span = this.waitSpan("HRegionLocator.clearRegionLocationCache");
        MatcherAssert.assertThat((Object)span, (Matcher)Matchers.allOf(SpanDataMatchers.hasStatusWithCode(StatusCode.OK), SpanDataMatchers.hasKind(SpanKind.INTERNAL), TraceTestUtil.buildConnectionAttributesMatcher(this.conn), TraceTestUtil.buildTableAttributesMatcher(TableName.META_TABLE_NAME)));
    }
}

