/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.RegistryEndpointsRefresher;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.Uninterruptibles;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, SmallTests.class})
public class TestRegistryEndpointsRefresher {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegistryEndpointsRefresher.class);
    private static final String INITIAL_DELAY_SECS_CONFIG_NAME = "hbase.test.registry.initial.delay.secs";
    private static final String INTERVAL_SECS_CONFIG_NAME = "hbase.test.registry.refresh.interval.secs";
    private static final String MIN_INTERVAL_SECS_CONFIG_NAME = "hbase.test.registry.refresh.min.interval.secs";
    private Configuration conf;
    private RegistryEndpointsRefresher refresher;
    private AtomicInteger refreshCallCounter;
    private CopyOnWriteArrayList<Long> callTimestamps;

    @Before
    public void setUp() {
        this.conf = HBaseConfiguration.create();
        this.refreshCallCounter = new AtomicInteger(0);
        this.callTimestamps = new CopyOnWriteArrayList();
    }

    @After
    public void tearDown() {
        if (this.refresher != null) {
            this.refresher.stop();
        }
    }

    private void refresh() {
        this.refreshCallCounter.incrementAndGet();
        this.callTimestamps.add(EnvironmentEdgeManager.currentTime());
    }

    private void createRefresher(long initialDelaySecs, long intervalSecs, long minIntervalSecs) {
        this.conf.setLong(INITIAL_DELAY_SECS_CONFIG_NAME, initialDelaySecs);
        this.conf.setLong(INTERVAL_SECS_CONFIG_NAME, intervalSecs);
        this.conf.setLong(MIN_INTERVAL_SECS_CONFIG_NAME, minIntervalSecs);
        this.refresher = RegistryEndpointsRefresher.create((Configuration)this.conf, (String)INITIAL_DELAY_SECS_CONFIG_NAME, (String)INTERVAL_SECS_CONFIG_NAME, (String)MIN_INTERVAL_SECS_CONFIG_NAME, this::refresh);
    }

    @Test
    public void testDisableRefresh() {
        this.conf.setLong(INTERVAL_SECS_CONFIG_NAME, -1L);
        Assert.assertNull((Object)RegistryEndpointsRefresher.create((Configuration)this.conf, (String)INTERVAL_SECS_CONFIG_NAME, (String)INTERVAL_SECS_CONFIG_NAME, (String)MIN_INTERVAL_SECS_CONFIG_NAME, this::refresh));
    }

    @Test
    public void testInitialDelay() throws InterruptedException {
        this.createRefresher(1L, 10L, 0L);
        Waiter.waitFor((Configuration)this.conf, (long)2000L, () -> this.refreshCallCounter.get() == 1);
        Thread.sleep(5000L);
        Assert.assertEquals((long)1L, (long)this.refreshCallCounter.get());
    }

    @Test
    public void testPeriodicMasterEndPointRefresh() {
        this.createRefresher(1L, 1L, 0L);
        Waiter.waitFor((Configuration)this.conf, (long)5000L, () -> this.refreshCallCounter.get() > 3);
    }

    @Test
    public void testDurationBetweenRefreshes() {
        int i;
        this.createRefresher(Integer.MAX_VALUE, Integer.MAX_VALUE, 1L);
        for (i = 0; i < 10000; ++i) {
            this.refresher.refreshNow();
            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        Assert.assertTrue((String)String.valueOf(this.refreshCallCounter.get()), (this.refreshCallCounter.get() <= 20 ? 1 : 0) != 0);
        Assert.assertTrue((this.callTimestamps.size() > 0 ? 1 : 0) != 0);
        for (i = 1; i < this.callTimestamps.size() - 1; ++i) {
            long delta = this.callTimestamps.get(i) - this.callTimestamps.get(i - 1);
            Assert.assertTrue((String)this.callTimestamps.toString(), (delta > 990L ? 1 : 0) != 0);
        }
    }
}

