/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.AbstractRpcBasedConnectionRegistry;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegistryProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hbase.thirdparty.com.google.protobuf.BlockingRpcChannel;
import org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcChannel;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClientTests.class, SmallTests.class})
public class TestRpcBasedRegistryHedgedReads {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRpcBasedRegistryHedgedReads.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRpcBasedRegistryHedgedReads.class);
    private static final String HEDGED_REQS_FANOUT_CONFIG_NAME = "hbase.test.hedged.reqs.fanout";
    private static final String INITIAL_DELAY_SECS_CONFIG_NAME = "hbase.test.refresh.initial.delay.secs";
    private static final String REFRESH_INTERVAL_SECS_CONFIG_NAME = "hbase.test.refresh.interval.secs";
    private static final String MIN_REFRESH_INTERVAL_SECS_CONFIG_NAME = "hbase.test.min.refresh.interval.secs";
    private static final HBaseCommonTestingUtility UTIL = new HBaseCommonTestingUtility();
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).build());
    private static Set<ServerName> BOOTSTRAP_NODES;
    private static AtomicInteger CALLED;
    private static volatile int BAD_RESP_INDEX;
    private static volatile Set<Integer> GOOD_RESP_INDEXS;
    private static RegistryProtos.GetClusterIdResponse RESP;

    private AbstractRpcBasedConnectionRegistry createRegistry(int hedged) throws IOException {
        Configuration conf = UTIL.getConfiguration();
        conf.setInt(HEDGED_REQS_FANOUT_CONFIG_NAME, hedged);
        return new AbstractRpcBasedConnectionRegistry(conf, HEDGED_REQS_FANOUT_CONFIG_NAME, INITIAL_DELAY_SECS_CONFIG_NAME, REFRESH_INTERVAL_SECS_CONFIG_NAME, MIN_REFRESH_INTERVAL_SECS_CONFIG_NAME){

            protected Set<ServerName> getBootstrapNodes(Configuration conf) throws IOException {
                return BOOTSTRAP_NODES;
            }

            protected CompletableFuture<Set<ServerName>> fetchEndpoints() {
                return CompletableFuture.completedFuture(BOOTSTRAP_NODES);
            }

            public String getConnectionString() {
                return "unimplemented";
            }
        };
    }

    @BeforeClass
    public static void setUpBeforeClass() {
        Configuration conf = UTIL.getConfiguration();
        conf.setClass("hbase.rpc.client.impl", RpcClientImpl.class, RpcClient.class);
        conf.setLong(INITIAL_DELAY_SECS_CONFIG_NAME, Integer.MAX_VALUE);
        conf.setLong(REFRESH_INTERVAL_SECS_CONFIG_NAME, Integer.MAX_VALUE);
        conf.setLong(MIN_REFRESH_INTERVAL_SECS_CONFIG_NAME, 0x7FFFFFFEL);
        BOOTSTRAP_NODES = IntStream.range(0, 10).mapToObj(i -> ServerName.valueOf((String)"localhost", (int)(10000 + 100 * i), (long)-1L)).collect(Collectors.toSet());
    }

    @AfterClass
    public static void tearDownAfterClass() {
        EXECUTOR.shutdownNow();
    }

    @Before
    public void setUp() {
        CALLED.set(0);
        BAD_RESP_INDEX = -1;
        GOOD_RESP_INDEXS = Collections.emptySet();
    }

    private <T> T logIfError(CompletableFuture<T> future) throws IOException {
        try {
            return (T)FutureUtils.get(future);
        }
        catch (Throwable t) {
            LOG.warn("", t);
            throw t;
        }
    }

    @Test
    public void testAllFailNoHedged() throws IOException {
        try (AbstractRpcBasedConnectionRegistry registry = this.createRegistry(1);){
            Assert.assertThrows(IOException.class, () -> {
                String cfr_ignored_0 = (String)this.logIfError(registry.getClusterId());
            });
            Assert.assertEquals((long)10L, (long)CALLED.get());
        }
    }

    @Test
    public void testAllFailHedged3() throws IOException {
        BAD_RESP_INDEX = 5;
        try (AbstractRpcBasedConnectionRegistry registry = this.createRegistry(3);){
            Assert.assertThrows(IOException.class, () -> {
                String cfr_ignored_0 = (String)this.logIfError(registry.getClusterId());
            });
            Assert.assertEquals((long)10L, (long)CALLED.get());
        }
    }

    @Test
    public void testFirstSucceededNoHedge() throws IOException {
        GOOD_RESP_INDEXS = IntStream.range(0, 10).mapToObj(Integer::valueOf).collect(Collectors.toSet());
        try (AbstractRpcBasedConnectionRegistry registry = this.createRegistry(0);){
            String clusterId = (String)this.logIfError(registry.getClusterId());
            Assert.assertEquals((Object)RESP.getClusterId(), (Object)clusterId);
            Assert.assertEquals((long)1L, (long)CALLED.get());
        }
    }

    @Test
    public void testSecondRoundSucceededHedge4() throws IOException {
        GOOD_RESP_INDEXS = Collections.singleton(6);
        try (AbstractRpcBasedConnectionRegistry registry = this.createRegistry(4);){
            String clusterId = (String)this.logIfError(registry.getClusterId());
            Assert.assertEquals((Object)RESP.getClusterId(), (Object)clusterId);
            UTIL.waitFor(5000L, () -> CALLED.get() == 8);
        }
    }

    @Test
    public void testSucceededWithLargestHedged() throws IOException, InterruptedException {
        GOOD_RESP_INDEXS = Collections.singleton(5);
        try (AbstractRpcBasedConnectionRegistry registry = this.createRegistry(Integer.MAX_VALUE);){
            String clusterId = (String)this.logIfError(registry.getClusterId());
            Assert.assertEquals((Object)RESP.getClusterId(), (Object)clusterId);
            UTIL.waitFor(5000L, () -> CALLED.get() == 10);
            Thread.sleep(1000L);
            Assert.assertEquals((long)10L, (long)CALLED.get());
        }
    }

    static {
        CALLED = new AtomicInteger(0);
        RESP = RegistryProtos.GetClusterIdResponse.newBuilder().setClusterId("id").build();
    }

    public static final class RpcChannelImpl
    implements RpcChannel {
        public void callMethod(Descriptors.MethodDescriptor method, RpcController controller, Message request, Message responsePrototype, RpcCallback<Message> done) {
            if (!method.getName().equals("GetClusterId")) {
                return;
            }
            EXECUTOR.execute(() -> {
                int index = CALLED.getAndIncrement();
                if (index == BAD_RESP_INDEX) {
                    done.run((Object)RegistryProtos.GetClusterIdResponse.getDefaultInstance());
                } else if (GOOD_RESP_INDEXS.contains(index)) {
                    done.run((Object)RESP);
                } else {
                    controller.setFailed("inject error");
                    done.run(null);
                }
            });
        }
    }

    public static final class RpcClientImpl
    implements RpcClient {
        public RpcClientImpl(Configuration configuration, String clusterId, SocketAddress localAddress, MetricsConnection metrics) {
        }

        public BlockingRpcChannel createBlockingRpcChannel(ServerName sn, User user, int rpcTimeout) {
            throw new UnsupportedOperationException();
        }

        public RpcChannel createRpcChannel(ServerName sn, User user, int rpcTimeout) {
            return new RpcChannelImpl();
        }

        public void cancelConnections(ServerName sn) {
        }

        public void close() {
        }

        public boolean hasCellBlockSupport() {
            return false;
        }
    }
}

