/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.CallDroppedException;
import org.apache.hadoop.hbase.CallQueueTooBigException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseServerException;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptorFactory;
import org.apache.hadoop.hbase.client.RpcRetryingCallerImpl;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, SmallTests.class})
public class TestRpcRetryingCallerImpl {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRpcRetryingCallerImpl.class);

    @Test
    public void itUsesSpecialPauseForCQTBE() throws Exception {
        this.itUsesSpecialPauseForServerOverloaded(CallQueueTooBigException.class);
    }

    @Test
    public void itUsesSpecialPauseForCDE() throws Exception {
        this.itUsesSpecialPauseForServerOverloaded(CallDroppedException.class);
    }

    private void itUsesSpecialPauseForServerOverloaded(Class<? extends HBaseServerException> exceptionClass) throws Exception {
        long pauseMillis = 1L;
        long specialPauseMillis = 2L;
        RpcRetryingCallerImpl caller = new RpcRetryingCallerImpl(pauseMillis, specialPauseMillis, 2, RetryingCallerInterceptorFactory.NO_OP_INTERCEPTOR, 0, 0, null);
        ThrowingCallable callable = new ThrowingCallable(CallQueueTooBigException.class, specialPauseMillis);
        try {
            caller.callWithRetries((RetryingCallable)callable, 5000);
            Assert.fail((String)("Expected " + exceptionClass.getSimpleName()));
        }
        catch (RetriesExhaustedException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof HBaseServerException));
        }
    }

    private static class ThrowingCallable
    implements RetryingCallable<Void> {
        private final Class<? extends HBaseServerException> exceptionClass;
        private final long specialPauseMillis;

        public ThrowingCallable(Class<? extends HBaseServerException> exceptionClass, long specialPauseMillis) {
            this.exceptionClass = exceptionClass;
            this.specialPauseMillis = specialPauseMillis;
        }

        public void prepare(boolean reload) throws IOException {
        }

        public void throwable(Throwable t, boolean retrying) {
        }

        public String getExceptionMessageAdditionalDetail() {
            return null;
        }

        public long sleep(long pause, int tries) {
            Assert.assertEquals((long)pause, (long)this.specialPauseMillis);
            return 0L;
        }

        public Void call(int callTimeout) throws Exception {
            throw this.exceptionClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
    }
}

