/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RequestController;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.SimpleRequestController;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, SmallTests.class})
public class TestSimpleRequestController {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSimpleRequestController.class);
    private static final TableName DUMMY_TABLE = TableName.valueOf((String)"DUMMY_TABLE");
    private static final byte[] DUMMY_BYTES_1 = Bytes.toBytes((String)"DUMMY_BYTES_1");
    private static final byte[] DUMMY_BYTES_2 = Bytes.toBytes((String)"DUMMY_BYTES_2");
    private static final byte[] DUMMY_BYTES_3 = Bytes.toBytes((String)"DUMMY_BYTES_3");
    private static final ServerName SN = ServerName.valueOf((String)"s1,1,1");
    private static final ServerName SN2 = ServerName.valueOf((String)"s2,2,2");
    private static final HRegionInfo HRI1 = new HRegionInfo(DUMMY_TABLE, DUMMY_BYTES_1, DUMMY_BYTES_2, false, 1L);
    private static final HRegionInfo HRI2 = new HRegionInfo(DUMMY_TABLE, DUMMY_BYTES_2, HConstants.EMPTY_END_ROW, false, 2L);
    private static final HRegionInfo HRI3 = new HRegionInfo(DUMMY_TABLE, DUMMY_BYTES_3, HConstants.EMPTY_END_ROW, false, 3L);
    private static final HRegionLocation LOC1 = new HRegionLocation((RegionInfo)HRI1, SN);
    private static final HRegionLocation LOC2 = new HRegionLocation((RegionInfo)HRI2, SN);
    private static final HRegionLocation LOC3 = new HRegionLocation((RegionInfo)HRI3, SN2);

    @Test
    public void testIllegalRequestHeapSize() {
        this.testIllegalArgument("hbase.client.max.perrequest.heapsize", -1L);
    }

    @Test
    public void testIllegalRsTasks() {
        this.testIllegalArgument("hbase.client.max.perserver.tasks", -1L);
    }

    @Test
    public void testIllegalRegionTasks() {
        this.testIllegalArgument("hbase.client.max.perregion.tasks", -1L);
    }

    @Test
    public void testIllegalSubmittedSize() {
        this.testIllegalArgument("hbase.client.max.submit.heapsize", -1L);
    }

    @Test
    public void testIllegalRequestRows() {
        this.testIllegalArgument("hbase.client.max.perrequest.rows", -1L);
    }

    private void testIllegalArgument(String key, long value) {
        Configuration conf = HBaseConfiguration.create();
        conf.setLong(key, value);
        try {
            new SimpleRequestController(conf);
            Assert.fail((String)("The " + key + " must be bigger than zero"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static Put createPut(final long maxHeapSizePerRequest) {
        return new Put(Bytes.toBytes((String)"row")){

            public long heapSize() {
                return maxHeapSizePerRequest;
            }
        };
    }

    @Test
    public void testTaskCheckerHost() throws IOException {
        int maxTotalConcurrentTasks = 100;
        int maxConcurrentTasksPerServer = 2;
        boolean maxConcurrentTasksPerRegion = true;
        AtomicLong tasksInProgress = new AtomicLong(0L);
        HashMap<ServerName, AtomicInteger> taskCounterPerServer = new HashMap<ServerName, AtomicInteger>();
        TreeMap<byte[], AtomicInteger> taskCounterPerRegion = new TreeMap<byte[], AtomicInteger>(Bytes.BYTES_COMPARATOR);
        SimpleRequestController.TaskCountChecker countChecker = new SimpleRequestController.TaskCountChecker(100, 2, 1, tasksInProgress, taskCounterPerServer, taskCounterPerRegion);
        long maxHeapSizePerRequest = 0x200000L;
        SimpleRequestController.RequestHeapSizeChecker sizeChecker = new SimpleRequestController.RequestHeapSizeChecker(0x200000L);
        RequestController.Checker checker = SimpleRequestController.newChecker(Arrays.asList(countChecker, sizeChecker));
        RequestController.ReturnCode loc1Code = checker.canTakeRow(LOC1, (Row)TestSimpleRequestController.createPut(0x200000L));
        Assert.assertEquals((Object)RequestController.ReturnCode.INCLUDE, (Object)loc1Code);
        RequestController.ReturnCode loc1Code_2 = checker.canTakeRow(LOC1, (Row)TestSimpleRequestController.createPut(0x200000L));
        Assert.assertNotEquals((Object)RequestController.ReturnCode.INCLUDE, (Object)loc1Code_2);
        RequestController.ReturnCode loc2Code = checker.canTakeRow(LOC2, (Row)TestSimpleRequestController.createPut(0x200000L));
        Assert.assertNotEquals((Object)RequestController.ReturnCode.INCLUDE, (Object)loc2Code);
        taskCounterPerRegion.put(LOC3.getRegionInfo().getRegionName(), new AtomicInteger(100));
        taskCounterPerServer.put(LOC3.getServerName(), new AtomicInteger(100));
        RequestController.ReturnCode loc3Code = checker.canTakeRow(LOC3, (Row)TestSimpleRequestController.createPut(1L));
        Assert.assertNotEquals((Object)RequestController.ReturnCode.INCLUDE, (Object)loc3Code);
        taskCounterPerRegion.put(LOC3.getRegionInfo().getRegionName(), new AtomicInteger(0));
        taskCounterPerServer.put(LOC3.getServerName(), new AtomicInteger(0));
        RequestController.ReturnCode loc3Code_2 = checker.canTakeRow(LOC3, (Row)TestSimpleRequestController.createPut(1L));
        Assert.assertEquals((Object)RequestController.ReturnCode.INCLUDE, (Object)loc3Code_2);
    }

    @Test
    public void testRequestHeapSizeChecker() throws IOException {
        RequestController.ReturnCode code;
        int i;
        long maxHeapSizePerRequest = 0x200000L;
        SimpleRequestController.RequestHeapSizeChecker checker = new SimpleRequestController.RequestHeapSizeChecker(0x200000L);
        for (int i2 = 0; i2 != 10; ++i2) {
            RequestController.ReturnCode code2 = checker.canTakeOperation(LOC1, 0x200000L);
            Assert.assertEquals((Object)RequestController.ReturnCode.INCLUDE, (Object)code2);
            code2 = checker.canTakeOperation(LOC2, 0x200000L);
            Assert.assertEquals((Object)RequestController.ReturnCode.INCLUDE, (Object)code2);
        }
        RequestController.ReturnCode acceptCode = checker.canTakeOperation(LOC1, 0x200000L);
        Assert.assertEquals((Object)RequestController.ReturnCode.INCLUDE, (Object)acceptCode);
        checker.notifyFinal(acceptCode, LOC1, 0x200000L);
        for (i = 0; i != 10; ++i) {
            code = checker.canTakeOperation(LOC1, 0x200000L);
            Assert.assertNotEquals((Object)RequestController.ReturnCode.INCLUDE, (Object)code);
            code = checker.canTakeOperation(LOC2, 0x200000L);
            Assert.assertNotEquals((Object)RequestController.ReturnCode.INCLUDE, (Object)code);
        }
        for (i = 0; i != 10; ++i) {
            code = checker.canTakeOperation(LOC3, 0x200000L);
            Assert.assertEquals((Object)RequestController.ReturnCode.INCLUDE, (Object)code);
        }
        checker.reset();
        for (i = 0; i != 10; ++i) {
            code = checker.canTakeOperation(LOC1, 0x200000L);
            Assert.assertEquals((Object)RequestController.ReturnCode.INCLUDE, (Object)code);
            code = checker.canTakeOperation(LOC2, 0x200000L);
            Assert.assertEquals((Object)RequestController.ReturnCode.INCLUDE, (Object)code);
        }
    }

    @Test
    public void testRequestRowsChecker() throws IOException {
        RequestController.ReturnCode code;
        int i;
        long maxRowCount = 100L;
        SimpleRequestController.RequestRowsChecker checker = new SimpleRequestController.RequestRowsChecker(100L);
        long heapSizeOfRow = 100L;
        for (i = 0; i != 10; ++i) {
            code = checker.canTakeOperation(LOC1, 100L);
            Assert.assertEquals((Object)RequestController.ReturnCode.INCLUDE, (Object)code);
            code = checker.canTakeOperation(LOC2, 100L);
            Assert.assertEquals((Object)RequestController.ReturnCode.INCLUDE, (Object)code);
        }
        i = 0;
        while ((long)i != 100L) {
            RequestController.ReturnCode acceptCode = checker.canTakeOperation(LOC1, 100L);
            Assert.assertEquals((Object)RequestController.ReturnCode.INCLUDE, (Object)acceptCode);
            checker.notifyFinal(acceptCode, LOC1, 100L);
            ++i;
        }
        for (i = 0; i != 10; ++i) {
            code = checker.canTakeOperation(LOC1, 100L);
            Assert.assertNotEquals((Object)RequestController.ReturnCode.INCLUDE, (Object)code);
            code = checker.canTakeOperation(LOC2, 100L);
            Assert.assertNotEquals((Object)RequestController.ReturnCode.INCLUDE, (Object)code);
        }
        for (i = 0; i != 10; ++i) {
            code = checker.canTakeOperation(LOC3, 100L);
            Assert.assertEquals((Object)RequestController.ReturnCode.INCLUDE, (Object)code);
        }
        checker.reset();
        for (i = 0; i != 10; ++i) {
            code = checker.canTakeOperation(LOC1, 100L);
            Assert.assertEquals((Object)RequestController.ReturnCode.INCLUDE, (Object)code);
            code = checker.canTakeOperation(LOC2, 100L);
            Assert.assertEquals((Object)RequestController.ReturnCode.INCLUDE, (Object)code);
        }
    }

    @Test
    public void testSubmittedSizeChecker() {
        RequestController.ReturnCode include;
        int i;
        long maxHeapSizeSubmit = 0x200000L;
        SimpleRequestController.SubmittedSizeChecker checker = new SimpleRequestController.SubmittedSizeChecker(0x200000L);
        for (i = 0; i != 10; ++i) {
            include = checker.canTakeOperation(LOC1, 100000L);
            Assert.assertEquals((Object)RequestController.ReturnCode.INCLUDE, (Object)include);
        }
        for (i = 0; i != 10; ++i) {
            checker.notifyFinal(RequestController.ReturnCode.INCLUDE, LOC1, 0x200000L);
        }
        for (i = 0; i != 10; ++i) {
            include = checker.canTakeOperation(LOC1, 100000L);
            Assert.assertEquals((Object)RequestController.ReturnCode.END, (Object)include);
        }
        for (i = 0; i != 10; ++i) {
            include = checker.canTakeOperation(LOC2, 100000L);
            Assert.assertEquals((Object)RequestController.ReturnCode.END, (Object)include);
        }
        checker.reset();
        for (i = 0; i != 10; ++i) {
            include = checker.canTakeOperation(LOC1, 100000L);
            Assert.assertEquals((Object)RequestController.ReturnCode.INCLUDE, (Object)include);
        }
    }

    @Test
    public void testTaskCountChecker() throws InterruptedIOException {
        RequestController.ReturnCode includeCode;
        int i;
        int i2;
        long heapSizeOfRow = 12345L;
        int maxTotalConcurrentTasks = 100;
        int maxConcurrentTasksPerServer = 2;
        int maxConcurrentTasksPerRegion = 1;
        AtomicLong tasksInProgress = new AtomicLong(0L);
        HashMap<ServerName, AtomicInteger> taskCounterPerServer = new HashMap<ServerName, AtomicInteger>();
        TreeMap<byte[], AtomicInteger> taskCounterPerRegion = new TreeMap<byte[], AtomicInteger>(Bytes.BYTES_COMPARATOR);
        SimpleRequestController.TaskCountChecker checker = new SimpleRequestController.TaskCountChecker(maxTotalConcurrentTasks, maxConcurrentTasksPerServer, maxConcurrentTasksPerRegion, tasksInProgress, taskCounterPerServer, taskCounterPerRegion);
        for (int i3 = 0; i3 != 10; ++i3) {
            RequestController.ReturnCode code = checker.canTakeOperation(LOC1, heapSizeOfRow);
            Assert.assertEquals((Object)RequestController.ReturnCode.INCLUDE, (Object)code);
        }
        RequestController.ReturnCode code = checker.canTakeOperation(LOC1, heapSizeOfRow);
        Assert.assertEquals((Object)RequestController.ReturnCode.INCLUDE, (Object)code);
        checker.notifyFinal(code, LOC1, heapSizeOfRow);
        taskCounterPerRegion.put(LOC1.getRegionInfo().getRegionName(), new AtomicInteger(100));
        taskCounterPerServer.put(LOC1.getServerName(), new AtomicInteger(100));
        for (i2 = 0; i2 != maxConcurrentTasksPerRegion * 5; ++i2) {
            RequestController.ReturnCode includeCode2 = checker.canTakeOperation(LOC1, heapSizeOfRow);
            Assert.assertEquals((Object)RequestController.ReturnCode.INCLUDE, (Object)includeCode2);
            checker.notifyFinal(includeCode2, LOC1, heapSizeOfRow);
        }
        taskCounterPerRegion.put(LOC3.getRegionInfo().getRegionName(), new AtomicInteger(100));
        taskCounterPerServer.put(LOC3.getServerName(), new AtomicInteger(100));
        for (i2 = 0; i2 != maxConcurrentTasksPerRegion * 5; ++i2) {
            RequestController.ReturnCode excludeCode = checker.canTakeOperation(LOC3, heapSizeOfRow);
            Assert.assertNotEquals((Object)RequestController.ReturnCode.INCLUDE, (Object)excludeCode);
            checker.notifyFinal(excludeCode, LOC3, heapSizeOfRow);
        }
        taskCounterPerRegion.put(LOC3.getRegionInfo().getRegionName(), new AtomicInteger(0));
        taskCounterPerServer.put(LOC3.getServerName(), new AtomicInteger(0));
        RequestController.ReturnCode code3 = checker.canTakeOperation(LOC3, heapSizeOfRow);
        Assert.assertEquals((Object)RequestController.ReturnCode.INCLUDE, (Object)code3);
        checker.notifyFinal(code3, LOC3, heapSizeOfRow);
        for (i = 0; i != maxConcurrentTasksPerRegion * 5; ++i) {
            includeCode = checker.canTakeOperation(LOC3, heapSizeOfRow);
            Assert.assertEquals((Object)RequestController.ReturnCode.INCLUDE, (Object)includeCode);
            checker.notifyFinal(includeCode, LOC3, heapSizeOfRow);
        }
        checker.reset();
        for (i = 0; i != maxConcurrentTasksPerRegion * 5; ++i) {
            includeCode = checker.canTakeOperation(LOC1, heapSizeOfRow);
            Assert.assertNotEquals((Object)RequestController.ReturnCode.INCLUDE, (Object)includeCode);
            checker.notifyFinal(includeCode, LOC1, heapSizeOfRow);
        }
    }

    @Test
    public void testWaitForMaximumCurrentTasks() throws Exception {
        AtomicInteger max = new AtomicInteger(0);
        CyclicBarrier barrier = new CyclicBarrier(2);
        SimpleRequestController controller = new SimpleRequestController(HBaseConfiguration.create());
        AtomicLong tasks = controller.tasksInProgress;
        Runnable runnable = () -> {
            try {
                barrier.await();
                controller.waitForMaximumCurrentTasks((long)max.get(), 123L, 1, null);
            }
            catch (InterruptedIOException | InterruptedException | BrokenBarrierException e) {
                Assert.fail((String)e.getMessage());
            }
        };
        Thread t = new Thread(runnable);
        t.start();
        barrier.await();
        t.join();
        barrier.reset();
        tasks.set(1000000L);
        t = new Thread(runnable);
        t.start();
        barrier.await();
        while (tasks.get() > 0L) {
            Assert.assertTrue((boolean)t.isAlive());
            tasks.set(tasks.get() - 1L);
        }
        t.join();
    }
}

