/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.DoNothingConnectionRegistry;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@Category(value={ClientTests.class, MediumTests.class})
public class TestTableRpcPriority {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTableRpcPriority.class);
    @Rule
    public TestName name = new TestName();
    private ClientProtos.ClientService.BlockingInterface stub;
    private Connection conn;

    @Before
    public void setUp() throws IOException, ServiceException {
        this.stub = (ClientProtos.ClientService.BlockingInterface)Mockito.mock(ClientProtos.ClientService.BlockingInterface.class);
        Configuration conf = HBaseConfiguration.create();
        ExecutorService executorService = Executors.newCachedThreadPool();
        this.conn = new ConnectionImplementation(conf, executorService, UserProvider.instantiate((Configuration)conf).getCurrent(), new DoNothingConnectionRegistry(conf)){

            public ClientProtos.ClientService.BlockingInterface getClient(ServerName serverName) throws IOException {
                return TestTableRpcPriority.this.stub;
            }

            public RegionLocations relocateRegion(TableName tableName, byte[] row, int replicaId) throws IOException {
                return this.locateRegion(tableName, row, true, false, replicaId);
            }

            public RegionLocations locateRegion(TableName tableName, byte[] row, boolean useCache, boolean retry, int replicaId) throws IOException {
                RegionInfo info = RegionInfoBuilder.newBuilder((TableName)tableName).build();
                ServerName serverName = ServerName.valueOf((String)"rs", (int)16010, (long)12345L);
                HRegionLocation loc = new HRegionLocation(info, serverName);
                return new RegionLocations(new HRegionLocation[]{loc});
            }
        };
    }

    @Test
    public void testScan() throws Exception {
        this.mockScan(19);
        this.testForTable(TableName.valueOf((String)this.name.getMethodName()), Optional.of(19));
    }

    @Test
    public void testScanSuperHighPriority() throws Exception {
        this.mockScan(1000);
        this.testForTable(TableName.valueOf((String)this.name.getMethodName()), Optional.of(1000));
    }

    @Test
    public void testScanNormalTable() throws Exception {
        this.mockScan(0);
        this.testForTable(TableName.valueOf((String)this.name.getMethodName()), Optional.of(0));
    }

    @Test
    public void testScanSystemTable() throws Exception {
        this.mockScan(200);
        this.testForTable(TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)this.name.getMethodName()), Optional.empty());
    }

    @Test
    public void testScanMetaTable() throws Exception {
        this.mockScan(200);
        this.testForTable(TableName.META_TABLE_NAME, Optional.empty());
    }

    private void testForTable(TableName tableName, Optional<Integer> priority) throws Exception {
        Scan scan = new Scan().setCaching(1);
        priority.ifPresent(arg_0 -> ((Scan)scan).setPriority(arg_0));
        try (ResultScanner scanner = this.conn.getTable(tableName).getScanner(scan);){
            Assert.assertNotNull((Object)scanner.next());
            Assert.assertNotNull((Object)scanner.next());
        }
        ((ClientProtos.ClientService.BlockingInterface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.atLeast((int)3))).scan((RpcController)ArgumentMatchers.any(), (ClientProtos.ScanRequest)ArgumentMatchers.any(ClientProtos.ScanRequest.class));
        ((ClientProtos.ClientService.BlockingInterface)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).scan((RpcController)this.assertControllerArgs(Math.max(priority.orElse(0), 200)), this.assertScannerCloseRequest());
    }

    private void mockScan(final int scanPriority) throws ServiceException {
        final int scannerId = 1;
        ((ClientProtos.ClientService.BlockingInterface)Mockito.doAnswer((Answer)new Answer<ClientProtos.ScanResponse>(){

            public ClientProtos.ScanResponse answer(InvocationOnMock invocation) throws Throwable {
                throw new IllegalArgumentException("Call not covered by explicit mock for arguments controller=" + invocation.getArgument(0) + ", request=" + invocation.getArgument(1));
            }
        }).when((Object)this.stub)).scan((RpcController)ArgumentMatchers.any(), (ClientProtos.ScanRequest)ArgumentMatchers.any());
        final AtomicInteger scanNextCalled = new AtomicInteger(0);
        ((ClientProtos.ClientService.BlockingInterface)Mockito.doAnswer((Answer)new Answer<ClientProtos.ScanResponse>(){

            public ClientProtos.ScanResponse answer(InvocationOnMock invocation) throws Throwable {
                ClientProtos.ScanRequest req = (ClientProtos.ScanRequest)invocation.getArgument(1);
                Assert.assertFalse((String)("close scanner should not come in with scan priority " + scanPriority), (req.hasCloseScanner() && req.getCloseScanner() ? 1 : 0) != 0);
                ClientProtos.ScanResponse.Builder builder = ClientProtos.ScanResponse.newBuilder();
                if (!req.hasScannerId()) {
                    builder.setScannerId((long)scannerId);
                } else {
                    builder.setScannerId(req.getScannerId());
                }
                Cell cell = CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setType(Cell.Type.Put).setRow(Bytes.toBytes((int)scanNextCalled.incrementAndGet())).setFamily(Bytes.toBytes((String)"cf")).setQualifier(Bytes.toBytes((String)"cq")).setValue(Bytes.toBytes((String)"v")).build();
                Result result = Result.create(Arrays.asList(cell));
                return builder.setTtl(800).setMoreResultsInRegion(true).setMoreResults(true).addResults(ProtobufUtil.toResult((Result)result)).build();
            }
        }).when((Object)this.stub)).scan((RpcController)this.assertControllerArgs(scanPriority), (ClientProtos.ScanRequest)ArgumentMatchers.any());
        ((ClientProtos.ClientService.BlockingInterface)Mockito.doAnswer((Answer)new Answer<ClientProtos.ScanResponse>(){

            public ClientProtos.ScanResponse answer(InvocationOnMock invocation) throws Throwable {
                ClientProtos.ScanRequest req = (ClientProtos.ScanRequest)invocation.getArgument(1);
                Assert.assertTrue((String)"close request should have scannerId", (boolean)req.hasScannerId());
                Assert.assertEquals((String)"close request's scannerId should match", (long)scannerId, (long)req.getScannerId());
                Assert.assertTrue((String)"close request should have closerScanner set", (req.hasCloseScanner() && req.getCloseScanner() ? 1 : 0) != 0);
                return ClientProtos.ScanResponse.getDefaultInstance();
            }
        }).when((Object)this.stub)).scan((RpcController)this.assertControllerArgs(Math.max(scanPriority, 200)), this.assertScannerCloseRequest());
    }

    private HBaseRpcController assertControllerArgs(final int priority) {
        return (HBaseRpcController)Mockito.argThat((ArgumentMatcher)new ArgumentMatcher<HBaseRpcController>(){

            public boolean matches(HBaseRpcController controller) {
                return controller.getPriority() == priority && controller.hasCallTimeout();
            }
        });
    }

    private ClientProtos.ScanRequest assertScannerCloseRequest() {
        return (ClientProtos.ScanRequest)Mockito.argThat((ArgumentMatcher)new ArgumentMatcher<ClientProtos.ScanRequest>(){

            public boolean matches(ClientProtos.ScanRequest request) {
                return request.hasCloseScanner() && request.getCloseScanner();
            }
        });
    }
}

