/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.testing.junit4.OpenTelemetryRule;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MatcherPredicate;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.trace.hamcrest.SpanDataMatchers;
import org.apache.hadoop.hbase.trace.HBaseSemanticAttributes;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTracingBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestTracingBase.class);
    protected static final ServerName MASTER_HOST = ServerName.valueOf((String)"localhost", (int)16010, (long)12345L);
    protected static final RegionLocations META_REGION_LOCATION = new RegionLocations(new HRegionLocation[]{new HRegionLocation(RegionInfoBuilder.FIRST_META_REGIONINFO, MASTER_HOST)});
    protected Configuration conf;
    @ClassRule
    public static OpenTelemetryRule TRACE_RULE = OpenTelemetryRule.create();

    @Before
    public void setUp() throws Exception {
        this.conf = HBaseConfiguration.create();
        this.conf.set("hbase.client.registry.impl", RegistryForTracingTest.class.getName());
        TRACE_RULE.clearSpans();
    }

    protected void assertTrace(String className, String methodName, ServerName serverName, TableName tableName) {
        String expectedSpanName = String.format("%s.%s", className, methodName);
        Waiter.waitFor((Configuration)this.conf, (long)1000L, () -> TRACE_RULE.getSpans().stream().anyMatch(span -> span.getName().equals(expectedSpanName) && span.getKind() == SpanKind.INTERNAL && span.hasEnded()));
        SpanData data = TRACE_RULE.getSpans().stream().filter(s -> s.getName().equals(expectedSpanName)).findFirst().get();
        Assert.assertEquals((Object)StatusCode.OK, (Object)data.getStatus().getStatusCode());
        if (serverName != null) {
            Optional<SpanData> foundServerName = TRACE_RULE.getSpans().stream().filter(s -> s.getName().equals(expectedSpanName)).filter(s -> Objects.equals(serverName.getServerName(), s.getAttributes().get(HBaseSemanticAttributes.SERVER_NAME_KEY))).findAny();
            Assert.assertTrue((boolean)foundServerName.isPresent());
        }
        if (tableName != null) {
            Assert.assertEquals((Object)tableName.getNamespaceAsString(), (Object)data.getAttributes().get(HBaseSemanticAttributes.DB_NAME));
            Assert.assertEquals((Object)tableName.getNameAsString(), (Object)data.getAttributes().get(HBaseSemanticAttributes.TABLE_KEY));
        }
    }

    protected SpanData waitSpan(String name) {
        return this.waitSpan(SpanDataMatchers.hasName(name));
    }

    protected SpanData waitSpan(Matcher<SpanData> matcher) {
        Matcher spanLocator = Matchers.allOf(matcher, SpanDataMatchers.hasEnded());
        try {
            Waiter.waitFor((Configuration)this.conf, (long)1000L, (Waiter.Predicate)new MatcherPredicate("waiting for span", () -> TRACE_RULE.getSpans(), Matchers.hasItem((Matcher)spanLocator)));
        }
        catch (AssertionError e) {
            LOG.error("AssertionError while waiting for matching span. Span reservoir contains: {}", (Object)TRACE_RULE.getSpans());
            throw e;
        }
        return TRACE_RULE.getSpans().stream().filter(arg_0 -> ((Matcher)spanLocator).matches(arg_0)).findFirst().orElseThrow(AssertionError::new);
    }

    static class RegistryForTracingTest
    implements ConnectionRegistry {
        public RegistryForTracingTest(Configuration conf) {
        }

        public CompletableFuture<RegionLocations> getMetaRegionLocations() {
            return CompletableFuture.completedFuture(META_REGION_LOCATION);
        }

        public CompletableFuture<String> getClusterId() {
            return CompletableFuture.completedFuture("default-cluster");
        }

        public CompletableFuture<ServerName> getActiveMaster() {
            return CompletableFuture.completedFuture(MASTER_HOST);
        }

        public String getConnectionString() {
            return "nothing";
        }

        public void close() {
        }
    }
}

