/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.trace;

import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class StringTraceRenderer {
    private static final Logger logger = LoggerFactory.getLogger(StringTraceRenderer.class);
    private final List<Node> graphs;

    public StringTraceRenderer(Collection<SpanData> spans) {
        Map<String, Node> spansById = StringTraceRenderer.indexSpansById(spans);
        StringTraceRenderer.populateChildren(spansById);
        this.graphs = StringTraceRenderer.findRoots(spansById);
    }

    private static Map<String, Node> indexSpansById(Collection<SpanData> spans) {
        HashMap<String, Node> spansById = new HashMap<String, Node>(spans.size());
        spans.forEach(span -> spansById.put(span.getSpanId(), new Node((SpanData)span)));
        return spansById;
    }

    private static void populateChildren(Map<String, Node> spansById) {
        spansById.forEach((spanId, node) -> {
            SpanData spanData = node.spanData;
            String parentSpanId = spanData.getParentSpanId();
            if (Objects.equals(parentSpanId, SpanId.getInvalid())) {
                return;
            }
            Node parentNode = (Node)spansById.get(parentSpanId);
            if (parentNode == null) {
                logger.warn("Span {} has parent {} that is not found in index, {}", new Object[]{spanId, parentSpanId, spanData});
                return;
            }
            parentNode.children.put((String)spanId, (Node)node);
        });
    }

    private static List<Node> findRoots(Map<String, Node> spansById) {
        return spansById.values().stream().filter(node -> Objects.equals(node.spanData.getParentSpanId(), SpanId.getInvalid())).collect(Collectors.toList());
    }

    public void render(Consumer<String> writer) {
        ListIterator<Node> iter = this.graphs.listIterator();
        while (iter.hasNext()) {
            int idx = iter.nextIndex();
            Node node = iter.next();
            StringTraceRenderer.render(writer, node, 0, idx == 0);
        }
    }

    private static void render(Consumer<String> writer, Node node, int indent, boolean isFirst) {
        writer.accept(StringTraceRenderer.render(node.spanData, indent, isFirst));
        ArrayList<Node> children = new ArrayList<Node>(node.children.values());
        ListIterator iter = children.listIterator();
        while (iter.hasNext()) {
            int idx = iter.nextIndex();
            Node child = (Node)iter.next();
            StringTraceRenderer.render(writer, child, indent + 2, idx == 0);
        }
    }

    private static String render(SpanData spanData, int indent, boolean isFirst) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
        return sb.append(isFirst ? "\u2514\u2500 " : "\u251c\u2500 ").append(StringTraceRenderer.render(spanData)).toString();
    }

    private static String render(SpanData spanData) {
        return new ToStringBuilder((Object)spanData, ToStringStyle.NO_CLASS_NAME_STYLE).append("spanId", (Object)spanData.getSpanId()).append("name", (Object)spanData.getName()).append("hasEnded", spanData.hasEnded()).toString();
    }

    private static class Node {
        final SpanData spanData;
        final LinkedHashMap<String, Node> children;

        Node(SpanData spanData) {
            this.spanData = spanData;
            this.children = new LinkedHashMap();
        }
    }
}

