/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.trace.hamcrest;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import java.util.Arrays;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public final class AttributesMatchers {
    private AttributesMatchers() {
    }

    public static <T> Matcher<Attributes> containsEntry(Matcher<AttributeKey<? super T>> keyMatcher, Matcher<? super T> valueMatcher) {
        return new IsAttributesContaining(keyMatcher, valueMatcher);
    }

    public static <T> Matcher<Attributes> containsEntry(AttributeKey<T> key, T value) {
        return AttributesMatchers.containsEntry(Matchers.equalTo(key), Matchers.equalTo(value));
    }

    public static <T> Matcher<Attributes> containsEntry(AttributeKey<T> key, Matcher<? super T> matcher) {
        return AttributesMatchers.containsEntry(Matchers.equalTo(key), matcher);
    }

    public static Matcher<Attributes> containsEntry(String key, String value) {
        return AttributesMatchers.containsEntry(AttributeKey.stringKey((String)key), value);
    }

    public static Matcher<Attributes> containsEntry(String key, long value) {
        return AttributesMatchers.containsEntry(AttributeKey.longKey((String)key), Long.valueOf(value));
    }

    public static Matcher<Attributes> containsEntryWithStringValuesOf(String key, String ... values) {
        return AttributesMatchers.containsEntry(AttributeKey.stringArrayKey((String)key), Arrays.asList(values));
    }

    public static Matcher<Attributes> containsEntryWithStringValuesOf(String key, Matcher<Iterable<? extends String>> matcher) {
        return new IsAttributesContaining(Matchers.equalTo((Object)AttributeKey.stringArrayKey((String)key)), matcher);
    }

    public static Matcher<Attributes> isEmpty() {
        return Matchers.hasProperty((String)"empty", (Matcher)Matchers.is((Object)true));
    }

    private static final class IsAttributesContaining<T>
    extends TypeSafeMatcher<Attributes> {
        private final Matcher<AttributeKey<? super T>> keyMatcher;
        private final Matcher<? super T> valueMatcher;

        private IsAttributesContaining(Matcher<AttributeKey<? super T>> keyMatcher, Matcher<? super T> valueMatcher) {
            this.keyMatcher = keyMatcher;
            this.valueMatcher = valueMatcher;
        }

        protected boolean matchesSafely(Attributes item) {
            return item.asMap().entrySet().stream().anyMatch(e -> Matchers.allOf((Matcher)Matchers.hasProperty((String)"key", this.keyMatcher), (Matcher)Matchers.hasProperty((String)"value", this.valueMatcher)).matches(e));
        }

        public void describeMismatchSafely(Attributes item, Description mismatchDescription) {
            mismatchDescription.appendText("Attributes was ").appendValueList("[", ", ", "]", item.asMap().entrySet());
        }

        public void describeTo(Description description) {
            description.appendText("Attributes containing [").appendDescriptionOf(this.keyMatcher).appendText("->").appendDescriptionOf(this.valueMatcher).appendText("]");
        }
    }
}

