/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.trace.hamcrest;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.trace.data.EventData;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class EventMatchers {
    private EventMatchers() {
    }

    public static Matcher<EventData> hasAttributes(Matcher<Attributes> matcher) {
        return new FeatureMatcher<EventData, Attributes>(matcher, "EventData having attributes that ", "attributes"){

            protected Attributes featureValueOf(EventData actual) {
                return actual.getAttributes();
            }
        };
    }

    public static Matcher<EventData> hasName(String name) {
        return EventMatchers.hasName((Matcher<String>)Matchers.equalTo((Object)name));
    }

    public static Matcher<EventData> hasName(Matcher<String> matcher) {
        return new FeatureMatcher<EventData, String>(matcher, "EventData with a name that ", "name"){

            protected String featureValueOf(EventData actual) {
                return actual.getName();
            }
        };
    }
}

