/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.trace.hamcrest;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.time.Duration;
import java.util.Objects;
import org.apache.hadoop.hbase.client.trace.hamcrest.AttributesMatchers;
import org.hamcrest.Description;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public final class SpanDataMatchers {
    private SpanDataMatchers() {
    }

    public static Matcher<SpanData> hasAttributes(Matcher<Attributes> matcher) {
        return new FeatureMatcher<SpanData, Attributes>(matcher, "SpanData having attributes that ", "attributes"){

            protected Attributes featureValueOf(SpanData item) {
                return item.getAttributes();
            }
        };
    }

    public static Matcher<SpanData> hasDuration(Matcher<Duration> matcher) {
        return new FeatureMatcher<SpanData, Duration>(matcher, "SpanData having duration that ", "duration"){

            protected Duration featureValueOf(SpanData item) {
                return Duration.ofNanos(item.getEndEpochNanos() - item.getStartEpochNanos());
            }
        };
    }

    public static Matcher<SpanData> hasEnded() {
        return new TypeSafeMatcher<SpanData>(){

            protected boolean matchesSafely(SpanData item) {
                return item.hasEnded();
            }

            public void describeTo(Description description) {
                description.appendText("SpanData that hasEnded");
            }
        };
    }

    public static Matcher<SpanData> hasEvents(Matcher<Iterable<? super EventData>> matcher) {
        return new FeatureMatcher<SpanData, Iterable<? super EventData>>(matcher, "SpanData having events that", "events"){

            protected Iterable<? super EventData> featureValueOf(SpanData item) {
                return item.getEvents();
            }
        };
    }

    public static Matcher<SpanData> hasExceptionWithType(Matcher<? super String> matcher) {
        return SpanDataMatchers.hasException(AttributesMatchers.containsEntry(Matchers.is((Object)SemanticAttributes.EXCEPTION_TYPE), matcher));
    }

    public static Matcher<SpanData> hasException(Matcher<? super Attributes> matcher) {
        return new FeatureMatcher<SpanData, Attributes>(matcher, "SpanData having Exception with Attributes that", "exception attributes"){

            protected Attributes featureValueOf(SpanData actual) {
                return actual.getEvents().stream().filter(e -> Objects.equals("exception", e.getName())).map(EventData::getAttributes).findFirst().orElse(null);
            }
        };
    }

    public static Matcher<SpanData> hasKind(SpanKind kind) {
        return new FeatureMatcher<SpanData, SpanKind>(Matchers.equalTo((Object)kind), "SpanData with kind that", "SpanKind"){

            protected SpanKind featureValueOf(SpanData item) {
                return item.getKind();
            }
        };
    }

    public static Matcher<SpanData> hasName(String name) {
        return SpanDataMatchers.hasName((Matcher<String>)Matchers.equalTo((Object)name));
    }

    public static Matcher<SpanData> hasName(Matcher<String> matcher) {
        return new FeatureMatcher<SpanData, String>(matcher, "SpanKind with a name that", "name"){

            protected String featureValueOf(SpanData item) {
                return item.getName();
            }
        };
    }

    public static Matcher<SpanData> hasParentSpanId(String parentSpanId) {
        return SpanDataMatchers.hasParentSpanId((Matcher<String>)Matchers.equalTo((Object)parentSpanId));
    }

    public static Matcher<SpanData> hasParentSpanId(SpanData parent) {
        return SpanDataMatchers.hasParentSpanId(parent.getSpanId());
    }

    public static Matcher<SpanData> hasParentSpanId(Matcher<String> matcher) {
        return new FeatureMatcher<SpanData, String>(matcher, "SpanKind with a parentSpanId that", "parentSpanId"){

            protected String featureValueOf(SpanData item) {
                return item.getParentSpanId();
            }
        };
    }

    public static Matcher<SpanData> hasStatusWithCode(Matcher<StatusCode> matcher) {
        return new FeatureMatcher<SpanData, StatusCode>(matcher, "SpanData with StatusCode that", "statusWithCode"){

            protected StatusCode featureValueOf(SpanData actual) {
                return actual.getStatus().getStatusCode();
            }
        };
    }

    public static Matcher<SpanData> hasStatusWithCode(StatusCode statusCode) {
        return SpanDataMatchers.hasStatusWithCode((Matcher<StatusCode>)Matchers.is((Matcher)Matchers.equalTo((Object)statusCode)));
    }

    public static Matcher<SpanData> hasTraceId(String traceId) {
        return SpanDataMatchers.hasTraceId((Matcher<String>)Matchers.is((Matcher)Matchers.equalTo((Object)traceId)));
    }

    public static Matcher<SpanData> hasTraceId(Matcher<String> matcher) {
        return new FeatureMatcher<SpanData, String>(matcher, "SpanData with a traceId that ", "traceId"){

            protected String featureValueOf(SpanData item) {
                return item.getTraceId();
            }
        };
    }
}

