/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.trace.hamcrest;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.trace.data.SpanData;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.trace.hamcrest.AttributesMatchers;
import org.apache.hadoop.hbase.client.trace.hamcrest.SpanDataMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class TraceTestUtil {
    private TraceTestUtil() {
    }

    public static Matcher<SpanData> buildConnectionAttributesMatcher(AsyncConnectionImpl conn) {
        return SpanDataMatchers.hasAttributes((Matcher<Attributes>)Matchers.allOf(AttributesMatchers.containsEntry("db.system", "hbase"), AttributesMatchers.containsEntry("db.connection_string", "nothing"), AttributesMatchers.containsEntry("db.user", conn.getUser().toString())));
    }

    public static Matcher<SpanData> buildConnectionAttributesMatcher(ConnectionImplementation conn) {
        return SpanDataMatchers.hasAttributes((Matcher<Attributes>)Matchers.allOf(AttributesMatchers.containsEntry("db.system", "hbase"), AttributesMatchers.containsEntry("db.connection_string", "nothing"), AttributesMatchers.containsEntry("db.user", conn.getUser().toString())));
    }

    public static Matcher<SpanData> buildTableAttributesMatcher(TableName tableName) {
        return SpanDataMatchers.hasAttributes((Matcher<Attributes>)Matchers.allOf(AttributesMatchers.containsEntry("db.name", tableName.getNamespaceAsString()), AttributesMatchers.containsEntry("db.hbase.table", tableName.getNameAsString())));
    }
}

