/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ipc.FailedServers;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@Category(value={ClientTests.class, SmallTests.class})
public class TestFailedServersLog {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFailedServersLog.class);
    static final int TEST_PORT = 9999;
    private Address addr;
    private Appender mockAppender;

    @Before
    public void setup() {
        this.mockAppender = (Appender)Mockito.mock(Appender.class);
        Mockito.when((Object)this.mockAppender.getName()).thenReturn((Object)"mockAppender");
        Mockito.when((Object)this.mockAppender.isStarted()).thenReturn((Object)true);
        ((Logger)LogManager.getLogger(FailedServers.class)).addAppender(this.mockAppender);
    }

    @After
    public void teardown() {
        ((Logger)LogManager.getLogger(FailedServers.class)).removeAppender(this.mockAppender);
    }

    @Test
    public void testAddToFailedServersLogging() {
        final AtomicReference level = new AtomicReference();
        final AtomicReference msg = new AtomicReference();
        ((Appender)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                LogEvent logEvent = (LogEvent)invocation.getArgument(0, LogEvent.class);
                level.set(logEvent.getLevel());
                msg.set(logEvent.getMessage().getFormattedMessage());
                return null;
            }
        }).when((Object)this.mockAppender)).append((LogEvent)ArgumentMatchers.any(LogEvent.class));
        NullPointerException nullException = new NullPointerException();
        FailedServers fs = new FailedServers(new Configuration());
        this.addr = Address.fromParts((String)"localhost", (int)9999);
        fs.addToFailedServers(this.addr, (Throwable)nullException);
        ((Appender)Mockito.verify((Object)this.mockAppender, (VerificationMode)Mockito.times((int)1))).append((LogEvent)ArgumentMatchers.any(LogEvent.class));
        Assert.assertEquals((Object)Level.DEBUG, level.get());
        Assert.assertEquals((Object)("Added failed server with address " + this.addr.toString() + " to list caused by " + nullException.toString()), msg.get());
    }
}

