/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseServerException;
import org.apache.hadoop.hbase.ipc.RemoteWithExtrasException;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, SmallTests.class})
public class TestRemoteWithExtrasException {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRemoteWithExtrasException.class);

    @Test
    public void itUsesExceptionDefaultValueForServerOverloaded() {
        RemoteWithExtrasException ex = new RemoteWithExtrasException(ServerOverloadedException.class.getName(), "server is overloaded", false, false);
        IOException result = ex.unwrapRemoteException();
        Assert.assertEquals(result.getClass(), ServerOverloadedException.class);
        Assert.assertTrue((boolean)((ServerOverloadedException)((Object)result)).isServerOverloaded());
    }

    @Test
    public void itUsesPassedServerOverloadedValue() {
        String exceptionClass = HBaseServerException.class.getName();
        String message = "server is overloaded";
        RemoteWithExtrasException ex = new RemoteWithExtrasException(exceptionClass, message, false, false);
        IOException result = ex.unwrapRemoteException();
        Assert.assertTrue((boolean)(result instanceof HBaseServerException));
        Assert.assertFalse((boolean)((HBaseServerException)result).isServerOverloaded());
        ex = new RemoteWithExtrasException(exceptionClass, message, false, true);
        result = ex.unwrapRemoteException();
        Assert.assertTrue((boolean)(result instanceof HBaseServerException));
        Assert.assertTrue((boolean)((HBaseServerException)result).isServerOverloaded());
    }

    private static class ServerOverloadedException
    extends HBaseServerException {
        public ServerOverloadedException(String message) {
            super(true, message);
        }
    }
}

