/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.Map;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.quotas.RpcThrottlingException;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestRpcThrottlingException {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRpcThrottlingException.class);
    private static final Map<String, Long> STR_TO_MS_NEW_FORMAT = ImmutableMap.builder().put((Object)"0ms", (Object)0L).put((Object)"50ms", (Object)50L).put((Object)"1sec, 1ms", (Object)1001L).put((Object)"1min, 5sec, 15ms", (Object)65015L).put((Object)"5mins, 2sec, 0ms", (Object)302000L).put((Object)"1hr, 3mins, 5sec, 1ms", (Object)3785001L).put((Object)"1hr, 5sec, 1ms", (Object)3605001L).put((Object)"1hr, 0ms", (Object)3600000L).put((Object)"1hr, 1min, 1ms", (Object)3660001L).build();
    private static final Map<String, Long> STR_TO_MS_LEGACY_FORMAT = ImmutableMap.builder().put((Object)"0sec", (Object)0L).put((Object)"1sec", (Object)1000L).put((Object)"2sec", (Object)2000L).put((Object)"1mins, 5sec", (Object)65000L).put((Object)"5mins, 2sec", (Object)302000L).put((Object)"1hrs, 3mins, 5sec", (Object)3785000L).build();

    @Test
    public void itConvertsMillisToNewString() {
        for (Map.Entry<String, Long> strAndMs : STR_TO_MS_NEW_FORMAT.entrySet()) {
            String output = RpcThrottlingException.stringFromMillis((long)strAndMs.getValue());
            Assert.assertEquals((Object)strAndMs.getKey(), (Object)output);
        }
    }

    @Test
    public void itConvertsNewStringToMillis() {
        for (Map.Entry<String, Long> strAndMs : STR_TO_MS_NEW_FORMAT.entrySet()) {
            Long output = RpcThrottlingException.timeFromString((String)strAndMs.getKey());
            Assert.assertEquals((Object)strAndMs.getValue(), (Object)output);
        }
    }

    @Test
    public void itConvertsLegacyStringToMillis() {
        for (Map.Entry<String, Long> strAndMs : STR_TO_MS_LEGACY_FORMAT.entrySet()) {
            Long output = RpcThrottlingException.timeFromString((String)strAndMs.getKey());
            Assert.assertEquals((Object)strAndMs.getValue(), (Object)output);
        }
    }
}

