/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.security.Key;
import java.security.KeyException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.crypto.KeyProviderForTesting;
import org.apache.hadoop.hbase.security.EncryptionUtil;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, SmallTests.class})
public class TestEncryptionUtil {
    private static final String INVALID_HASH_ALG = "this-hash-algorithm-not-exists hopefully... :)";
    private static final String DEFAULT_HASH_ALGORITHM = "use-default";
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestEncryptionUtil.class);

    @Test
    public void testKeyWrappingUsingHashAlgDefault() throws Exception {
        this.testKeyWrapping(DEFAULT_HASH_ALGORITHM);
    }

    @Test
    public void testKeyWrappingUsingHashAlgMD5() throws Exception {
        this.testKeyWrapping("MD5");
    }

    @Test
    public void testKeyWrappingUsingHashAlgSHA256() throws Exception {
        this.testKeyWrapping("SHA-256");
    }

    @Test
    public void testKeyWrappingUsingHashAlgSHA384() throws Exception {
        this.testKeyWrapping("SHA-384");
    }

    @Test(expected=RuntimeException.class)
    public void testKeyWrappingWithInvalidHashAlg() throws Exception {
        this.testKeyWrapping(INVALID_HASH_ALG);
    }

    @Test
    public void testWALKeyWrappingUsingHashAlgDefault() throws Exception {
        this.testWALKeyWrapping(DEFAULT_HASH_ALGORITHM);
    }

    @Test
    public void testWALKeyWrappingUsingHashAlgMD5() throws Exception {
        this.testWALKeyWrapping("MD5");
    }

    @Test
    public void testWALKeyWrappingUsingHashAlgSHA256() throws Exception {
        this.testWALKeyWrapping("SHA-256");
    }

    @Test
    public void testWALKeyWrappingUsingHashAlgSHA384() throws Exception {
        this.testWALKeyWrapping("SHA-384");
    }

    @Test(expected=RuntimeException.class)
    public void testWALKeyWrappingWithInvalidHashAlg() throws Exception {
        this.testWALKeyWrapping(INVALID_HASH_ALG);
    }

    @Test(expected=KeyException.class)
    public void testWALKeyWrappingWithIncorrectKey() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hbase.crypto.keyprovider", KeyProviderForTesting.class.getName());
        byte[] keyBytes = new byte[16];
        Bytes.secureRandom((byte[])keyBytes);
        String algorithm = conf.get("hbase.crypto.wal.algorithm", "AES");
        SecretKeySpec key = new SecretKeySpec(keyBytes, algorithm);
        byte[] wrappedKeyBytes = EncryptionUtil.wrapKey((Configuration)conf, (String)"hbase", (Key)key);
        Assert.assertNotNull((Object)wrappedKeyBytes);
        EncryptionUtil.unwrapWALKey((Configuration)conf, (String)"other", (byte[])wrappedKeyBytes);
    }

    @Test(expected=KeyException.class)
    public void testHashAlgorithmMismatchWhenFailExpected() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("hbase.crypto.key.hash.algorithm.failOnMismatch", true);
        this.testKeyWrappingWithMismatchingAlgorithms(conf);
    }

    @Test
    public void testHashAlgorithmMismatchWhenFailNotExpected() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("hbase.crypto.key.hash.algorithm.failOnMismatch", false);
        this.testKeyWrappingWithMismatchingAlgorithms(conf);
    }

    @Test
    public void testHashAlgorithmMismatchShouldNotFailWithDefaultConfig() throws Exception {
        Configuration conf = new Configuration();
        this.testKeyWrappingWithMismatchingAlgorithms(conf);
    }

    private void testKeyWrapping(String hashAlgorithm) throws Exception {
        Configuration conf = new Configuration();
        conf.set("hbase.crypto.keyprovider", KeyProviderForTesting.class.getName());
        if (!hashAlgorithm.equals(DEFAULT_HASH_ALGORITHM)) {
            conf.set("hbase.crypto.key.hash.algorithm", hashAlgorithm);
        }
        byte[] keyBytes = new byte[16];
        Bytes.secureRandom((byte[])keyBytes);
        String algorithm = conf.get("hbase.crypto.key.algorithm", "AES");
        SecretKeySpec key = new SecretKeySpec(keyBytes, algorithm);
        byte[] wrappedKeyBytes = EncryptionUtil.wrapKey((Configuration)conf, (String)"hbase", (Key)key);
        Assert.assertNotNull((Object)wrappedKeyBytes);
        Key unwrappedKey = EncryptionUtil.unwrapKey((Configuration)conf, (String)"hbase", (byte[])wrappedKeyBytes);
        Assert.assertNotNull((Object)unwrappedKey);
        Assert.assertTrue((boolean)(unwrappedKey instanceof SecretKeySpec));
        Assert.assertTrue((String)"Unwrapped key bytes do not match original", (boolean)Bytes.equals((byte[])keyBytes, (byte[])unwrappedKey.getEncoded()));
        try {
            EncryptionUtil.unwrapKey((Configuration)conf, (String)"other", (byte[])wrappedKeyBytes);
            Assert.fail((String)"Unwrap with incorrect key did not throw KeyException");
        }
        catch (KeyException keyException) {
            // empty catch block
        }
    }

    private void testWALKeyWrapping(String hashAlgorithm) throws Exception {
        Configuration conf = new Configuration();
        conf.set("hbase.crypto.keyprovider", KeyProviderForTesting.class.getName());
        if (!hashAlgorithm.equals(DEFAULT_HASH_ALGORITHM)) {
            conf.set("hbase.crypto.key.hash.algorithm", hashAlgorithm);
        }
        byte[] keyBytes = new byte[16];
        Bytes.secureRandom((byte[])keyBytes);
        String algorithm = conf.get("hbase.crypto.wal.algorithm", "AES");
        SecretKeySpec key = new SecretKeySpec(keyBytes, algorithm);
        byte[] wrappedKeyBytes = EncryptionUtil.wrapKey((Configuration)conf, (String)"hbase", (Key)key);
        Assert.assertNotNull((Object)wrappedKeyBytes);
        Key unwrappedKey = EncryptionUtil.unwrapWALKey((Configuration)conf, (String)"hbase", (byte[])wrappedKeyBytes);
        Assert.assertNotNull((Object)unwrappedKey);
        Assert.assertTrue((boolean)(unwrappedKey instanceof SecretKeySpec));
        Assert.assertTrue((String)"Unwrapped key bytes do not match original", (boolean)Bytes.equals((byte[])keyBytes, (byte[])unwrappedKey.getEncoded()));
    }

    private void testKeyWrappingWithMismatchingAlgorithms(Configuration conf) throws Exception {
        conf.set("hbase.crypto.keyprovider", KeyProviderForTesting.class.getName());
        conf.set("hbase.crypto.key.hash.algorithm", "MD5");
        byte[] keyBytes = new byte[16];
        Bytes.secureRandom((byte[])keyBytes);
        String algorithm = conf.get("hbase.crypto.key.algorithm", "AES");
        SecretKeySpec key = new SecretKeySpec(keyBytes, algorithm);
        byte[] wrappedKeyBytes = EncryptionUtil.wrapKey((Configuration)conf, (String)"hbase", (Key)key);
        Assert.assertNotNull((Object)wrappedKeyBytes);
        conf.set("hbase.crypto.key.hash.algorithm", "SHA-384");
        Key unwrappedKey = EncryptionUtil.unwrapKey((Configuration)conf, (String)"hbase", (byte[])wrappedKeyBytes);
        Assert.assertNotNull((Object)unwrappedKey);
        Assert.assertTrue((String)"Unwrapped key bytes do not match original", (boolean)Bytes.equals((byte[])keyBytes, (byte[])unwrappedKey.getEncoded()));
    }
}

