/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.SaslClient;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.security.AuthMethod;
import org.apache.hadoop.hbase.security.HBaseSaslRpcClient;
import org.apache.hadoop.hbase.security.SaslUtil;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.security.provider.DigestSaslClientAuthenticationProvider;
import org.apache.hadoop.hbase.security.provider.GssSaslClientAuthenticationProvider;
import org.apache.hadoop.hbase.security.provider.SaslClientAuthenticationProvider;
import org.apache.hadoop.hbase.security.provider.SimpleSaslClientAuthenticationProvider;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hbase.thirdparty.com.google.common.base.Strings;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SecurityTests.class, SmallTests.class})
public class TestHBaseSaslRpcClient {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHBaseSaslRpcClient.class);
    static final String DEFAULT_USER_NAME = "principal";
    static final String DEFAULT_USER_PASSWORD = "password";
    private static final Logger LOG;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testSaslClientUsesGivenRpcProtection() throws Exception {
        Token<? extends TokenIdentifier> token = this.createTokenMockWithCredentials(DEFAULT_USER_NAME, DEFAULT_USER_PASSWORD);
        DigestSaslClientAuthenticationProvider provider = new DigestSaslClientAuthenticationProvider();
        for (SaslUtil.QualityOfProtection qop : SaslUtil.QualityOfProtection.values()) {
            String negotiatedQop = new HBaseSaslRpcClient(HBaseConfiguration.create(), (SaslClientAuthenticationProvider)provider, token, (InetAddress)Mockito.mock(InetAddress.class), (SecurityInfo)Mockito.mock(SecurityInfo.class), false, qop.name(), false){

                public String getQop() {
                    return (String)this.saslProps.get("javax.security.sasl.qop");
                }
            }.getQop();
            Assert.assertEquals((Object)negotiatedQop, (Object)qop.getSaslQop());
        }
    }

    @Test
    public void testDigestSaslClientCallbackHandler() throws UnsupportedCallbackException {
        Token<? extends TokenIdentifier> token = this.createTokenMock();
        Mockito.when((Object)token.getIdentifier()).thenReturn((Object)Bytes.toBytes((String)DEFAULT_USER_NAME));
        Mockito.when((Object)token.getPassword()).thenReturn((Object)Bytes.toBytes((String)DEFAULT_USER_PASSWORD));
        NameCallback nameCallback = (NameCallback)Mockito.mock(NameCallback.class);
        PasswordCallback passwordCallback = (PasswordCallback)Mockito.mock(PasswordCallback.class);
        RealmCallback realmCallback = (RealmCallback)Mockito.mock(RealmCallback.class);
        Callback[] callbackArray = new Callback[]{nameCallback, passwordCallback, realmCallback};
        DigestSaslClientAuthenticationProvider.DigestSaslClientCallbackHandler saslClCallbackHandler = new DigestSaslClientAuthenticationProvider.DigestSaslClientCallbackHandler(token);
        saslClCallbackHandler.handle(callbackArray);
        ((NameCallback)Mockito.verify((Object)nameCallback)).setName(ArgumentMatchers.anyString());
        ((PasswordCallback)Mockito.verify((Object)passwordCallback)).setPassword((char[])ArgumentMatchers.any());
    }

    @Test
    public void testDigestSaslClientCallbackHandlerWithException() {
        Token<? extends TokenIdentifier> token = this.createTokenMock();
        Mockito.when((Object)token.getIdentifier()).thenReturn((Object)Bytes.toBytes((String)DEFAULT_USER_NAME));
        Mockito.when((Object)token.getPassword()).thenReturn((Object)Bytes.toBytes((String)DEFAULT_USER_PASSWORD));
        DigestSaslClientAuthenticationProvider.DigestSaslClientCallbackHandler saslClCallbackHandler = new DigestSaslClientAuthenticationProvider.DigestSaslClientCallbackHandler(token);
        try {
            saslClCallbackHandler.handle(new Callback[]{(Callback)Mockito.mock(TextOutputCallback.class)});
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
        }
        catch (Exception ex) {
            Assert.fail((String)("testDigestSaslClientCallbackHandlerWithException error : " + ex.getMessage()));
        }
    }

    @Test
    public void testHBaseSaslRpcClientCreation() throws Exception {
        Assert.assertFalse((boolean)this.assertSuccessCreationKerberos());
        Assert.assertFalse((boolean)this.assertSuccessCreationDigestPrincipal(null, null));
        Assert.assertFalse((boolean)this.assertSuccessCreationDigestPrincipal("", ""));
        Assert.assertFalse((boolean)this.assertSuccessCreationDigestPrincipal("", null));
        Assert.assertFalse((boolean)this.assertSuccessCreationDigestPrincipal(null, ""));
        Assert.assertTrue((boolean)this.assertSuccessCreationDigestPrincipal(DEFAULT_USER_NAME, DEFAULT_USER_PASSWORD));
        Assert.assertFalse((boolean)this.assertSuccessCreationSimple());
        Assert.assertTrue((boolean)this.assertIOExceptionThenSaslClientIsNull(DEFAULT_USER_NAME, DEFAULT_USER_PASSWORD));
        Assert.assertTrue((boolean)this.assertIOExceptionWhenGetStreamsBeforeConnectCall(DEFAULT_USER_NAME, DEFAULT_USER_PASSWORD));
    }

    @Test
    public void testAuthMethodReadWrite() throws IOException {
        DataInputBuffer in = new DataInputBuffer();
        DataOutputBuffer out = new DataOutputBuffer();
        this.assertAuthMethodRead(in, AuthMethod.SIMPLE);
        this.assertAuthMethodRead(in, AuthMethod.KERBEROS);
        this.assertAuthMethodRead(in, AuthMethod.DIGEST);
        this.assertAuthMethodWrite(out, AuthMethod.SIMPLE);
        this.assertAuthMethodWrite(out, AuthMethod.KERBEROS);
        this.assertAuthMethodWrite(out, AuthMethod.DIGEST);
    }

    private void assertAuthMethodRead(DataInputBuffer in, AuthMethod authMethod) throws IOException {
        in.reset(new byte[]{authMethod.code}, 1);
        Assert.assertEquals((Object)authMethod, (Object)AuthMethod.read((DataInput)in));
    }

    private void assertAuthMethodWrite(DataOutputBuffer out, AuthMethod authMethod) throws IOException {
        authMethod.write((DataOutput)out);
        Assert.assertEquals((long)authMethod.code, (long)out.getData()[0]);
        out.reset();
    }

    private boolean assertIOExceptionWhenGetStreamsBeforeConnectCall(String principal, String password) throws IOException {
        boolean inState = false;
        boolean outState = false;
        DigestSaslClientAuthenticationProvider provider = new DigestSaslClientAuthenticationProvider(){

            public SaslClient createClient(Configuration conf, InetAddress serverAddress, SecurityInfo securityInfo, Token<? extends TokenIdentifier> token, boolean fallbackAllowed, Map<String, String> saslProps) {
                return (SaslClient)Mockito.mock(SaslClient.class);
            }
        };
        HBaseSaslRpcClient rpcClient = new HBaseSaslRpcClient(HBaseConfiguration.create(), (SaslClientAuthenticationProvider)provider, this.createTokenMockWithCredentials(principal, password), (InetAddress)Mockito.mock(InetAddress.class), (SecurityInfo)Mockito.mock(SecurityInfo.class), false);
        try {
            rpcClient.getInputStream();
        }
        catch (IOException ex) {
            inState = true;
        }
        try {
            rpcClient.getOutputStream();
        }
        catch (IOException ex) {
            outState = true;
        }
        return inState && outState;
    }

    private boolean assertIOExceptionThenSaslClientIsNull(String principal, String password) {
        try {
            DigestSaslClientAuthenticationProvider provider = new DigestSaslClientAuthenticationProvider(){

                public SaslClient createClient(Configuration conf, InetAddress serverAddress, SecurityInfo securityInfo, Token<? extends TokenIdentifier> token, boolean fallbackAllowed, Map<String, String> saslProps) {
                    return null;
                }
            };
            new HBaseSaslRpcClient(HBaseConfiguration.create(), (SaslClientAuthenticationProvider)provider, this.createTokenMockWithCredentials(principal, password), (InetAddress)Mockito.mock(InetAddress.class), (SecurityInfo)Mockito.mock(SecurityInfo.class), false);
            return false;
        }
        catch (IOException ex) {
            return true;
        }
    }

    private boolean assertSuccessCreationKerberos() {
        HBaseSaslRpcClient rpcClient = null;
        try {
            rpcClient = this.createSaslRpcClientForKerberos();
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        return rpcClient != null;
    }

    private boolean assertSuccessCreationDigestPrincipal(String principal, String password) {
        HBaseSaslRpcClient rpcClient = null;
        try {
            rpcClient = new HBaseSaslRpcClient(HBaseConfiguration.create(), (SaslClientAuthenticationProvider)new DigestSaslClientAuthenticationProvider(), this.createTokenMockWithCredentials(principal, password), (InetAddress)Mockito.mock(InetAddress.class), (SecurityInfo)Mockito.mock(SecurityInfo.class), false);
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        return rpcClient != null;
    }

    private boolean assertSuccessCreationSimple() {
        HBaseSaslRpcClient rpcClient = null;
        try {
            rpcClient = this.createSaslRpcClientSimple();
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        return rpcClient != null;
    }

    private HBaseSaslRpcClient createSaslRpcClientForKerberos() throws IOException {
        return new HBaseSaslRpcClient(HBaseConfiguration.create(), (SaslClientAuthenticationProvider)new GssSaslClientAuthenticationProvider(), this.createTokenMock(), (InetAddress)Mockito.mock(InetAddress.class), (SecurityInfo)Mockito.mock(SecurityInfo.class), false);
    }

    private Token<? extends TokenIdentifier> createTokenMockWithCredentials(String principal, String password) throws IOException {
        Token<? extends TokenIdentifier> token = this.createTokenMock();
        if (!Strings.isNullOrEmpty((String)principal) && !Strings.isNullOrEmpty((String)password)) {
            Mockito.when((Object)token.getIdentifier()).thenReturn((Object)Bytes.toBytes((String)DEFAULT_USER_NAME));
            Mockito.when((Object)token.getPassword()).thenReturn((Object)Bytes.toBytes((String)DEFAULT_USER_PASSWORD));
        }
        return token;
    }

    private HBaseSaslRpcClient createSaslRpcClientSimple() throws IOException {
        return new HBaseSaslRpcClient(HBaseConfiguration.create(), (SaslClientAuthenticationProvider)new SimpleSaslClientAuthenticationProvider(), this.createTokenMock(), (InetAddress)Mockito.mock(InetAddress.class), (SecurityInfo)Mockito.mock(SecurityInfo.class), false);
    }

    private Token<? extends TokenIdentifier> createTokenMock() {
        return (Token)Mockito.mock(Token.class);
    }

    static {
        System.setProperty("java.security.krb5.realm", "DOMAIN.COM");
        System.setProperty("java.security.krb5.kdc", "DOMAIN.COM");
        LOG = LoggerFactory.getLogger(TestHBaseSaslRpcClient.class);
    }
}

