/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.provider;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import javax.security.sasl.SaslClient;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.provider.SaslAuthMethod;
import org.apache.hadoop.hbase.security.provider.SaslClientAuthenticationProvider;
import org.apache.hadoop.hbase.security.provider.SaslClientAuthenticationProviders;
import org.apache.hadoop.hbase.security.provider.SimpleSaslClientAuthenticationProvider;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class, SecurityTests.class})
public class TestSaslClientAuthenticationProviders {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSaslClientAuthenticationProviders.class);

    @Test
    public void testCannotAddTheSameProviderTwice() {
        HashMap registeredProviders = new HashMap();
        SimpleSaslClientAuthenticationProvider p1 = new SimpleSaslClientAuthenticationProvider();
        SimpleSaslClientAuthenticationProvider p2 = new SimpleSaslClientAuthenticationProvider();
        SaslClientAuthenticationProviders.addProviderIfNotExists((SaslClientAuthenticationProvider)p1, registeredProviders);
        Assert.assertEquals((long)1L, (long)registeredProviders.size());
        try {
            SaslClientAuthenticationProviders.addProviderIfNotExists((SaslClientAuthenticationProvider)p2, registeredProviders);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertSame((String)"Expected the original provider to be present", (Object)p1, registeredProviders.entrySet().iterator().next().getValue());
    }

    @Test
    public void testInstanceIsCached() {
        Configuration conf = HBaseConfiguration.create();
        SaslClientAuthenticationProviders providers1 = SaslClientAuthenticationProviders.getInstance((Configuration)conf);
        SaslClientAuthenticationProviders providers2 = SaslClientAuthenticationProviders.getInstance((Configuration)conf);
        Assert.assertSame((Object)providers1, (Object)providers2);
        SaslClientAuthenticationProviders.reset();
        SaslClientAuthenticationProviders providers3 = SaslClientAuthenticationProviders.getInstance((Configuration)conf);
        Assert.assertNotSame((Object)providers1, (Object)providers3);
        Assert.assertEquals((long)providers1.getNumRegisteredProviders(), (long)providers3.getNumRegisteredProviders());
    }

    @Test(expected=RuntimeException.class)
    public void testDifferentConflictingImplementationsFail() {
        Configuration conf = HBaseConfiguration.create();
        conf.setStrings("hbase.client.sasl.provider.extras", new String[]{ConflictingProvider1.class.getName(), ConflictingProvider2.class.getName()});
        SaslClientAuthenticationProviders.getInstance((Configuration)conf);
    }

    static class ConflictingProvider2
    implements SaslClientAuthenticationProvider {
        static final SaslAuthMethod METHOD2 = new SaslAuthMethod("BAR", 12, "DIGEST-MD5", UserGroupInformation.AuthenticationMethod.SIMPLE);

        public SaslAuthMethod getSaslAuthMethod() {
            return METHOD2;
        }

        public String getTokenKind() {
            return null;
        }

        public SaslClient createClient(Configuration conf, InetAddress serverAddr, SecurityInfo securityInfo, Token<? extends TokenIdentifier> token, boolean fallbackAllowed, Map<String, String> saslProps) throws IOException {
            return null;
        }

        public RPCProtos.UserInformation getUserInfo(User user) {
            return null;
        }
    }

    static class ConflictingProvider1
    implements SaslClientAuthenticationProvider {
        static final SaslAuthMethod METHOD1 = new SaslAuthMethod("FOO", 12, "DIGEST-MD5", UserGroupInformation.AuthenticationMethod.SIMPLE);

        public SaslAuthMethod getSaslAuthMethod() {
            return METHOD1;
        }

        public String getTokenKind() {
            return null;
        }

        public SaslClient createClient(Configuration conf, InetAddress serverAddr, SecurityInfo securityInfo, Token<? extends TokenIdentifier> token, boolean fallbackAllowed, Map<String, String> saslProps) throws IOException {
            return null;
        }

        public RPCProtos.UserInformation getUserInfo(User user) {
            return null;
        }
    }
}

