/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.PoolMap;
import org.apache.hadoop.hbase.util.PoolMapTestBase;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestRoundRobinPoolMap
extends PoolMapTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRoundRobinPoolMap.class);

    @Override
    protected PoolMap.PoolType getPoolType() {
        return PoolMap.PoolType.RoundRobin;
    }

    @Test
    public void testGetOrCreate() throws IOException {
        String key = "key";
        String value = "value";
        String result = (String)this.poolMap.getOrCreate((Object)key, () -> value);
        Assert.assertEquals((Object)value, (Object)result);
        Assert.assertEquals((long)1L, (long)this.poolMap.values().size());
    }

    @Test
    public void testMultipleKeys() throws IOException {
        for (int i = 0; i < 5; ++i) {
            String key = Integer.toString(i);
            String value = Integer.toString(2 * i);
            String result = (String)this.poolMap.getOrCreate((Object)key, () -> value);
            Assert.assertEquals((Object)value, (Object)result);
        }
        Assert.assertEquals((long)5L, (long)this.poolMap.values().size());
    }

    @Test
    public void testMultipleValues() throws IOException {
        String key = "key";
        for (int i = 0; i < 3; ++i) {
            String value = Integer.toString(i);
            String result = (String)this.poolMap.getOrCreate((Object)key, () -> value);
            Assert.assertEquals((Object)value, (Object)result);
        }
        Assert.assertEquals((long)3L, (long)this.poolMap.values().size());
    }

    @Test
    public void testRoundRobin() throws IOException {
        int i;
        String key = "key";
        for (i = 0; i < 3; ++i) {
            String value = Integer.toString(i);
            this.poolMap.getOrCreate((Object)key, () -> value);
        }
        Assert.assertEquals((long)3L, (long)this.poolMap.values().size());
        for (i = 0; i < 6; ++i) {
            String expected = Integer.toString(i % 3);
            Assert.assertEquals((Object)expected, (Object)this.poolMap.getOrCreate((Object)key, () -> {
                throw new IOException("must not call me");
            }));
        }
        Assert.assertEquals((long)3L, (long)this.poolMap.values().size());
    }

    @Test
    public void testMultiThreadedRoundRobin() throws ExecutionException, InterruptedException {
        String key = "key";
        AtomicInteger id = new AtomicInteger();
        List results = Collections.synchronizedList(new ArrayList());
        Runnable runnable = () -> {
            try {
                for (int i = 0; i < 3; ++i) {
                    String value = Integer.toString(id.getAndIncrement());
                    String result = (String)this.poolMap.getOrCreate((Object)key, () -> value);
                    results.add(result);
                    Thread.sleep(10L);
                }
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        };
        CompletableFuture<Void> future1 = CompletableFuture.runAsync(runnable);
        CompletableFuture<Void> future2 = CompletableFuture.runAsync(runnable);
        future1.get();
        future2.get();
        Assert.assertEquals((long)3L, (long)this.poolMap.values().size());
        Collections.sort(results);
        Iterator iterator = results.iterator();
        for (int i = 0; i < 3; ++i) {
            String next1 = (String)iterator.next();
            String next2 = (String)iterator.next();
            Assert.assertEquals((Object)next1, (Object)next2);
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }
}

