/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.PoolMap;
import org.apache.hadoop.hbase.util.PoolMapTestBase;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestThreadLocalPoolMap
extends PoolMapTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestThreadLocalPoolMap.class);

    @Override
    protected PoolMap.PoolType getPoolType() {
        return PoolMap.PoolType.ThreadLocal;
    }

    @Test
    public void testGetOrCreate() throws IOException {
        String key = "key";
        String value = "value";
        String result = (String)this.poolMap.getOrCreate((Object)key, () -> value);
        Assert.assertEquals((Object)value, (Object)result);
        Assert.assertEquals((long)1L, (long)this.poolMap.values().size());
    }

    @Test
    public void testMultipleKeys() throws IOException {
        for (int i = 0; i < 5; ++i) {
            String key = Integer.toString(i);
            String value = Integer.toString(2 * i);
            String result = (String)this.poolMap.getOrCreate((Object)key, () -> value);
            Assert.assertEquals((Object)value, (Object)result);
        }
        Assert.assertEquals((long)5L, (long)this.poolMap.values().size());
    }

    @Test
    public void testFull() throws IOException {
        String key = "key";
        String value = "value";
        String result = (String)this.poolMap.getOrCreate((Object)key, () -> value);
        Assert.assertEquals((Object)value, (Object)result);
        String result2 = (String)this.poolMap.getOrCreate((Object)key, () -> {
            throw new IOException("must not call me");
        });
        Assert.assertEquals((Object)value, (Object)result2);
        Assert.assertEquals((long)1L, (long)this.poolMap.values().size());
    }

    @Test
    public void testLocality() throws ExecutionException, InterruptedException {
        String key = "key";
        AtomicInteger id = new AtomicInteger();
        Runnable runnable = () -> {
            try {
                String myId = Integer.toString(id.getAndIncrement());
                for (int i = 0; i < 3; ++i) {
                    String result = (String)this.poolMap.getOrCreate((Object)key, () -> myId);
                    Assert.assertEquals((Object)myId, (Object)result);
                    Thread.sleep(10L);
                }
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        };
        CompletableFuture<Void> future1 = CompletableFuture.runAsync(runnable);
        CompletableFuture<Void> future2 = CompletableFuture.runAsync(runnable);
        future1.get();
        future2.get();
        Assert.assertEquals((long)2L, (long)this.poolMap.values().size());
    }
}

