/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.trace;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.trace.HBaseSemanticAttributes;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class IpcClientSpanBuilder
implements Supplier<Span> {
    private String name;
    private final Map<AttributeKey<?>, Object> attributes = new HashMap();

    @Override
    public Span get() {
        return this.build();
    }

    public IpcClientSpanBuilder setMethodDescriptor(Descriptors.MethodDescriptor md) {
        String packageAndService = IpcClientSpanBuilder.getRpcPackageAndService(md.getService());
        String method = IpcClientSpanBuilder.getRpcName(md);
        this.name = IpcClientSpanBuilder.buildSpanName(packageAndService, method);
        IpcClientSpanBuilder.populateMethodDescriptorAttributes(this.attributes, md);
        return this;
    }

    public IpcClientSpanBuilder setRemoteAddress(Address remoteAddress) {
        this.attributes.put(HBaseSemanticAttributes.NET_PEER_NAME, remoteAddress.getHostName());
        this.attributes.put(HBaseSemanticAttributes.NET_PEER_PORT, remoteAddress.getPort());
        return this;
    }

    public Span build() {
        SpanBuilder builder = TraceUtil.getGlobalTracer().spanBuilder(this.name).setSpanKind(SpanKind.CLIENT);
        this.attributes.forEach((k, v) -> builder.setAttribute(k, v));
        return builder.startSpan();
    }

    static void populateMethodDescriptorAttributes(Map<AttributeKey<?>, Object> attributes, Descriptors.MethodDescriptor md) {
        String packageAndService = IpcClientSpanBuilder.getRpcPackageAndService(md.getService());
        String method = IpcClientSpanBuilder.getRpcName(md);
        attributes.put(HBaseSemanticAttributes.RPC_SYSTEM, HBaseSemanticAttributes.RpcSystem.HBASE_RPC.name());
        attributes.put(HBaseSemanticAttributes.RPC_SERVICE, packageAndService);
        attributes.put(HBaseSemanticAttributes.RPC_METHOD, method);
    }

    public static String getRpcPackageAndService(Descriptors.ServiceDescriptor sd) {
        return sd.getFullName();
    }

    public static String getRpcName(Descriptors.MethodDescriptor md) {
        return md.getName();
    }

    public static String buildSpanName(String packageAndService, String method) {
        return packageAndService + "/" + method;
    }
}

