/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.google.errorprone.annotations.RestrictedApi;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.CRC32;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RotateFile {
    private static final Logger LOG = LoggerFactory.getLogger(RotateFile.class);
    private final FileSystem fs;
    private final long maxFileSize;
    private final Path[] files = new Path[2];
    private long prevTimestamp = -1L;
    private int nextFile = -1;

    public RotateFile(FileSystem fs, Path dir, String name, long maxFileSize) {
        this.fs = fs;
        this.maxFileSize = maxFileSize;
        this.files[0] = new Path(dir, name + "-0");
        this.files[1] = new Path(dir, name + "-1");
    }

    private HBaseProtos.RotateFileData read(Path path) throws IOException {
        int expectedChecksum;
        byte[] data;
        try (FSDataInputStream in = this.fs.open(path);){
            int length = in.readInt();
            if (length <= 0 || (long)length > this.maxFileSize) {
                throw new IOException("Invalid file length " + length + ", either less than 0 or greater then max allowed size " + this.maxFileSize);
            }
            data = new byte[length];
            in.readFully(data);
            expectedChecksum = in.readInt();
        }
        CRC32 crc32 = new CRC32();
        crc32.update(data);
        int calculatedChecksum = (int)crc32.getValue();
        if (expectedChecksum != calculatedChecksum) {
            throw new IOException("Checksum mismatch, expected " + expectedChecksum + ", actual " + calculatedChecksum);
        }
        return HBaseProtos.RotateFileData.parseFrom((byte[])data);
    }

    private int select(HBaseProtos.RotateFileData[] datas) {
        if (datas[0] == null) {
            return 1;
        }
        if (datas[1] == null) {
            return 0;
        }
        return datas[0].getTimestamp() >= datas[1].getTimestamp() ? 0 : 1;
    }

    public byte[] read() throws IOException {
        HBaseProtos.RotateFileData[] datas = new HBaseProtos.RotateFileData[2];
        for (int i = 0; i < 2; ++i) {
            try {
                datas[i] = this.read(this.files[i]);
                continue;
            }
            catch (FileNotFoundException e) {
                LOG.debug("file {} does not exist", (Object)this.files[i], (Object)e);
                continue;
            }
            catch (EOFException e) {
                LOG.debug("file {} is incomplete", (Object)this.files[i], (Object)e);
            }
        }
        int winnerIndex = this.select(datas);
        this.nextFile = 1 - winnerIndex;
        if (datas[winnerIndex] != null) {
            this.prevTimestamp = datas[winnerIndex].getTimestamp();
            return datas[winnerIndex].getData().toByteArray();
        }
        return null;
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/RotateFile.java|.*/src/test/.*")
    static void write(FileSystem fs, Path file, long timestamp, byte[] data) throws IOException {
        HBaseProtos.RotateFileData proto = HBaseProtos.RotateFileData.newBuilder().setTimestamp(timestamp).setData(ByteString.copyFrom((byte[])data)).build();
        byte[] protoData = proto.toByteArray();
        CRC32 crc32 = new CRC32();
        crc32.update(protoData);
        int checksum = (int)crc32.getValue();
        try (FSDataOutputStream out = fs.create(file, true);){
            out.writeInt(protoData.length);
            out.write(protoData);
            out.writeInt(checksum);
        }
    }

    public void write(byte[] data) throws IOException {
        if ((long)data.length > this.maxFileSize) {
            throw new IOException("Data size " + data.length + " is greater than max allowed size " + this.maxFileSize);
        }
        long timestamp = Math.max(this.prevTimestamp + 1L, EnvironmentEdgeManager.currentTime());
        RotateFile.write(this.fs, this.files[this.nextFile], timestamp, data);
        this.prevTimestamp = timestamp;
        this.nextFile = 1 - this.nextFile;
        try {
            this.fs.delete(this.files[this.nextFile], false);
        }
        catch (IOException e) {
            LOG.debug("Failed to delete old file {}, ignoring the exception", (Object)this.files[this.nextFile], (Object)e);
        }
    }

    public void delete() throws IOException {
        Path next = this.files[this.nextFile];
        if (this.fs.exists(next) && !this.fs.delete(next, false)) {
            throw new IOException("Can not delete " + next);
        }
        Path current = this.files[1 - this.nextFile];
        if (this.fs.exists(current) && !this.fs.delete(current, false)) {
            throw new IOException("Can not delete " + current);
        }
    }
}

