/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.AsyncTableRegionLocator;
import org.apache.hadoop.hbase.client.CheckAndMutate;
import org.apache.hadoop.hbase.client.CheckAndMutateResult;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScanResultConsumerBase;
import org.apache.hadoop.hbase.client.ServiceCaller;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcChannel;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public interface AsyncTable<C extends ScanResultConsumerBase> {
    public TableName getName();

    public Configuration getConfiguration();

    public CompletableFuture<TableDescriptor> getDescriptor();

    public AsyncTableRegionLocator getRegionLocator();

    public long getRpcTimeout(TimeUnit var1);

    public long getReadRpcTimeout(TimeUnit var1);

    public long getWriteRpcTimeout(TimeUnit var1);

    public long getOperationTimeout(TimeUnit var1);

    public long getScanTimeout(TimeUnit var1);

    default public CompletableFuture<Boolean> exists(Get get) {
        return this.get(ConnectionUtils.toCheckExistenceOnly(get)).thenApply(r -> r.getExists());
    }

    public CompletableFuture<Result> get(Get var1);

    public CompletableFuture<Void> put(Put var1);

    public CompletableFuture<Void> delete(Delete var1);

    public CompletableFuture<Result> append(Append var1);

    public CompletableFuture<Result> increment(Increment var1);

    default public CompletableFuture<Long> incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) {
        return this.incrementColumnValue(row, family, qualifier, amount, Durability.SYNC_WAL);
    }

    default public CompletableFuture<Long> incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) {
        Preconditions.checkNotNull((Object)row, (Object)"row is null");
        Preconditions.checkNotNull((Object)family, (Object)"family is null");
        return this.increment(new Increment(row).addColumn(family, qualifier, amount).setDurability(durability)).thenApply(r -> Bytes.toLong((byte[])r.getValue(family, qualifier)));
    }

    @Deprecated
    public CheckAndMutateBuilder checkAndMutate(byte[] var1, byte[] var2);

    @Deprecated
    public CheckAndMutateWithFilterBuilder checkAndMutate(byte[] var1, Filter var2);

    public CompletableFuture<CheckAndMutateResult> checkAndMutate(CheckAndMutate var1);

    public List<CompletableFuture<CheckAndMutateResult>> checkAndMutate(List<CheckAndMutate> var1);

    default public CompletableFuture<List<CheckAndMutateResult>> checkAndMutateAll(List<CheckAndMutate> checkAndMutates) {
        return ConnectionUtils.allOf(this.checkAndMutate(checkAndMutates));
    }

    public CompletableFuture<Result> mutateRow(RowMutations var1);

    public void scan(Scan var1, C var2);

    default public ResultScanner getScanner(byte[] family) {
        return this.getScanner(new Scan().addFamily(family));
    }

    default public ResultScanner getScanner(byte[] family, byte[] qualifier) {
        return this.getScanner(new Scan().addColumn(family, qualifier));
    }

    public ResultScanner getScanner(Scan var1);

    public CompletableFuture<List<Result>> scanAll(Scan var1);

    default public List<CompletableFuture<Boolean>> exists(List<Get> gets) {
        return this.get(ConnectionUtils.toCheckExistenceOnly(gets)).stream().map(f -> f.thenApply(r -> r.getExists())).collect(Collectors.toList());
    }

    default public CompletableFuture<List<Boolean>> existsAll(List<Get> gets) {
        return ConnectionUtils.allOf(this.exists(gets));
    }

    public List<CompletableFuture<Result>> get(List<Get> var1);

    default public CompletableFuture<List<Result>> getAll(List<Get> gets) {
        return ConnectionUtils.allOf(this.get(gets));
    }

    public List<CompletableFuture<Void>> put(List<Put> var1);

    default public CompletableFuture<Void> putAll(List<Put> puts) {
        return ConnectionUtils.allOf(this.put(puts)).thenApply(r -> null);
    }

    public List<CompletableFuture<Void>> delete(List<Delete> var1);

    default public CompletableFuture<Void> deleteAll(List<Delete> deletes) {
        return ConnectionUtils.allOf(this.delete(deletes)).thenApply(r -> null);
    }

    public <T> List<CompletableFuture<T>> batch(List<? extends Row> var1);

    default public <T> CompletableFuture<List<T>> batchAll(List<? extends Row> actions) {
        return ConnectionUtils.allOf(this.batch(actions));
    }

    public <S, R> CompletableFuture<R> coprocessorService(Function<RpcChannel, S> var1, ServiceCaller<S, R> var2, byte[] var3);

    public <S, R> CoprocessorServiceBuilder<S, R> coprocessorService(Function<RpcChannel, S> var1, ServiceCaller<S, R> var2, CoprocessorCallback<R> var3);

    public static interface CoprocessorServiceBuilder<S, R> {
        default public CoprocessorServiceBuilder<S, R> fromRow(byte[] startKey) {
            return this.fromRow(startKey, true);
        }

        public CoprocessorServiceBuilder<S, R> fromRow(byte[] var1, boolean var2);

        default public CoprocessorServiceBuilder<S, R> toRow(byte[] endKey) {
            return this.toRow(endKey, false);
        }

        public CoprocessorServiceBuilder<S, R> toRow(byte[] var1, boolean var2);

        public void execute();
    }

    @InterfaceAudience.Public
    public static interface CoprocessorCallback<R> {
        public void onRegionComplete(RegionInfo var1, R var2);

        public void onRegionError(RegionInfo var1, Throwable var2);

        public void onComplete();

        public void onError(Throwable var1);
    }

    @Deprecated
    public static interface CheckAndMutateWithFilterBuilder {
        public CheckAndMutateWithFilterBuilder timeRange(TimeRange var1);

        public CompletableFuture<Boolean> thenPut(Put var1);

        public CompletableFuture<Boolean> thenDelete(Delete var1);

        public CompletableFuture<Boolean> thenMutate(RowMutations var1);
    }

    @Deprecated
    public static interface CheckAndMutateBuilder {
        public CheckAndMutateBuilder qualifier(byte[] var1);

        public CheckAndMutateBuilder timeRange(TimeRange var1);

        public CheckAndMutateBuilder ifNotExists();

        default public CheckAndMutateBuilder ifEquals(byte[] value) {
            return this.ifMatches(CompareOperator.EQUAL, value);
        }

        public CheckAndMutateBuilder ifMatches(CompareOperator var1, byte[] var2);

        public CompletableFuture<Boolean> thenPut(Put var1);

        public CompletableFuture<Boolean> thenDelete(Delete var1);

        public CompletableFuture<Boolean> thenMutate(RowMutations var1);
    }
}

