/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.trace;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.CheckAndMutate;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionCoprocessorServiceExec;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.trace.HBaseSemanticAttributes;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class TableOperationSpanBuilder
implements Supplier<Span> {
    private static final String unknown = "UNKNOWN";
    private TableName tableName;
    private final Map<AttributeKey<?>, Object> attributes = new HashMap();

    @Override
    public Span get() {
        return this.build();
    }

    public TableOperationSpanBuilder setOperation(Scan scan) {
        return this.setOperation(TableOperationSpanBuilder.valueFrom(scan));
    }

    public TableOperationSpanBuilder setOperation(Row row) {
        return this.setOperation(TableOperationSpanBuilder.valueFrom(row));
    }

    public TableOperationSpanBuilder setOperation(Collection<? extends Row> operations) {
        return this.setOperation(HBaseSemanticAttributes.Operation.BATCH);
    }

    public TableOperationSpanBuilder setOperation(HBaseSemanticAttributes.Operation operation) {
        this.attributes.put(HBaseSemanticAttributes.DB_OPERATION, operation.name());
        return this;
    }

    public TableOperationSpanBuilder setTableName(TableName tableName) {
        this.tableName = tableName;
        this.attributes.put(HBaseSemanticAttributes.NAMESPACE_KEY, tableName.getNamespaceAsString());
        this.attributes.put(HBaseSemanticAttributes.DB_NAME, tableName.getNamespaceAsString());
        this.attributes.put(HBaseSemanticAttributes.TABLE_KEY, tableName.getNameAsString());
        return this;
    }

    public Span build() {
        String name = this.attributes.getOrDefault(HBaseSemanticAttributes.DB_OPERATION, unknown) + " " + (this.tableName != null ? this.tableName.getNameWithNamespaceInclAsString() : unknown);
        SpanBuilder builder = TraceUtil.getGlobalTracer().spanBuilder(name).setSpanKind(SpanKind.CLIENT);
        this.attributes.forEach((k, v) -> builder.setAttribute(k, v));
        return builder.startSpan();
    }

    private static HBaseSemanticAttributes.Operation valueFrom(Scan scan) {
        if (scan == null) {
            return null;
        }
        return HBaseSemanticAttributes.Operation.SCAN;
    }

    private static HBaseSemanticAttributes.Operation valueFrom(Row row) {
        if (row == null) {
            return null;
        }
        if (row instanceof Append) {
            return HBaseSemanticAttributes.Operation.APPEND;
        }
        if (row instanceof CheckAndMutate) {
            return HBaseSemanticAttributes.Operation.CHECK_AND_MUTATE;
        }
        if (row instanceof Delete) {
            return HBaseSemanticAttributes.Operation.DELETE;
        }
        if (row instanceof Get) {
            return HBaseSemanticAttributes.Operation.GET;
        }
        if (row instanceof Increment) {
            return HBaseSemanticAttributes.Operation.INCREMENT;
        }
        if (row instanceof Put) {
            return HBaseSemanticAttributes.Operation.PUT;
        }
        if (row instanceof RegionCoprocessorServiceExec) {
            return HBaseSemanticAttributes.Operation.COPROC_EXEC;
        }
        if (row instanceof RowMutations) {
            return HBaseSemanticAttributes.Operation.BATCH;
        }
        return null;
    }
}

