/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.Arrays;
import org.apache.hadoop.hbase.client.replication.ReplicationPeerConfigUtil;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ReplicationProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public enum SyncReplicationState {
    NONE(0),
    ACTIVE(1),
    DOWNGRADE_ACTIVE(2),
    STANDBY(3);

    private final byte value;

    private SyncReplicationState(int value) {
        this.value = (byte)value;
    }

    public static SyncReplicationState valueOf(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return ACTIVE;
            }
            case 2: {
                return DOWNGRADE_ACTIVE;
            }
            case 3: {
                return STANDBY;
            }
        }
        throw new IllegalArgumentException("Unknown synchronous replication state " + value);
    }

    public int value() {
        return this.value & 0xFF;
    }

    public static byte[] toByteArray(SyncReplicationState state) {
        return ProtobufUtil.prependPBMagic(ReplicationPeerConfigUtil.toSyncReplicationState(state).toByteArray());
    }

    public static SyncReplicationState parseFrom(byte[] bytes) throws InvalidProtocolBufferException {
        return ReplicationPeerConfigUtil.toSyncReplicationState(ReplicationProtos.SyncReplicationState.parseFrom((byte[])Arrays.copyOfRange(bytes, ProtobufUtil.lengthOfPBMagic(), bytes.length)));
    }
}

