/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.ServiceCaller;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcChannel;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public final class AsyncAdminClientUtils {
    private AsyncAdminClientUtils() {
    }

    public static <S, R> CompletableFuture<Map<ServerName, Object>> coprocessorServiceOnAllRegionServers(AsyncAdmin asyncAdmin, Function<RpcChannel, S> stubMaker, ServiceCaller<S, R> callable) {
        CompletableFuture<Map<ServerName, Object>> future = new CompletableFuture<Map<ServerName, Object>>();
        FutureUtils.addListener(asyncAdmin.getRegionServers(), (regionServers, error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
                return;
            }
            ConcurrentHashMap resultMap = new ConcurrentHashMap();
            for (ServerName regionServer : regionServers) {
                FutureUtils.addListener(asyncAdmin.coprocessorService(stubMaker, callable, regionServer), (server, err) -> {
                    if (err != null) {
                        resultMap.put(regionServer, err);
                    } else {
                        resultMap.put(regionServer, server);
                    }
                    if (resultMap.size() == regionServers.size()) {
                        future.complete(Collections.unmodifiableMap(resultMap));
                    }
                });
            }
        });
        return future;
    }
}

