/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Comparator;
import java.util.Map;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.client.OperationWithAttributes;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.security.access.AccessControlUtil;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.ArrayListMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.ListMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public abstract class Query
extends OperationWithAttributes {
    private static final String ISOLATION_LEVEL = "_isolationlevel_";
    protected Filter filter = null;
    protected int targetReplicaId = -1;
    protected Consistency consistency = Consistency.STRONG;
    protected Map<byte[], TimeRange> colFamTimeRangeMap = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
    protected Boolean loadColumnFamiliesOnDemand = null;

    public Filter getFilter() {
        return this.filter;
    }

    public Query setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    public Query setAuthorizations(Authorizations authorizations) {
        this.setAttribute("VISIBILITY", ProtobufUtil.toAuthorizations(authorizations).toByteArray());
        return this;
    }

    public Authorizations getAuthorizations() throws DeserializationException {
        byte[] authorizationsBytes = this.getAttribute("VISIBILITY");
        if (authorizationsBytes == null) {
            return null;
        }
        return ProtobufUtil.toAuthorizations(authorizationsBytes);
    }

    public byte[] getACL() {
        return this.getAttribute("acl");
    }

    public Query setACL(String user, Permission perms) {
        this.setAttribute("acl", AccessControlUtil.toUsersAndPermissions(user, perms).toByteArray());
        return this;
    }

    public Query setACL(Map<String, Permission> perms) {
        ArrayListMultimap permMap = ArrayListMultimap.create();
        for (Map.Entry<String, Permission> entry : perms.entrySet()) {
            permMap.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        this.setAttribute("acl", AccessControlUtil.toUsersAndPermissions((ListMultimap<String, Permission>)permMap).toByteArray());
        return this;
    }

    public Consistency getConsistency() {
        return this.consistency;
    }

    public Query setConsistency(Consistency consistency) {
        this.consistency = consistency;
        return this;
    }

    public Query setReplicaId(int Id) {
        this.targetReplicaId = Id;
        return this;
    }

    public int getReplicaId() {
        return this.targetReplicaId;
    }

    public Query setIsolationLevel(IsolationLevel level) {
        this.setAttribute(ISOLATION_LEVEL, level.toBytes());
        return this;
    }

    public IsolationLevel getIsolationLevel() {
        byte[] attr = this.getAttribute(ISOLATION_LEVEL);
        return attr == null ? IsolationLevel.READ_COMMITTED : IsolationLevel.fromBytes(attr);
    }

    public Query setLoadColumnFamiliesOnDemand(boolean value) {
        this.loadColumnFamiliesOnDemand = value;
        return this;
    }

    public Boolean getLoadColumnFamiliesOnDemandValue() {
        return this.loadColumnFamiliesOnDemand;
    }

    public boolean doLoadColumnFamiliesOnDemand() {
        return this.loadColumnFamiliesOnDemand != null && this.loadColumnFamiliesOnDemand != false;
    }

    public Query setColumnFamilyTimeRange(byte[] cf, long minStamp, long maxStamp) {
        this.colFamTimeRangeMap.put(cf, TimeRange.between((long)minStamp, (long)maxStamp));
        return this;
    }

    public Map<byte[], TimeRange> getColumnFamilyTimeRange() {
        return this.colFamTimeRangeMap;
    }
}

