/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.util.ByteRange;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class CellUtil {
    public static ByteRange fillRowRange(Cell cell, ByteRange range) {
        return range.set(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
    }

    public static ByteRange fillFamilyRange(Cell cell, ByteRange range) {
        return range.set(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength());
    }

    public static ByteRange fillQualifierRange(Cell cell, ByteRange range) {
        return range.set(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
    }

    public static byte[] getRowArray(Cell cell) {
        byte[] output = new byte[cell.getRowLength()];
        CellUtil.copyRowTo(cell, output, 0);
        return output;
    }

    public static byte[] getFamilyArray(Cell cell) {
        byte[] output = new byte[cell.getFamilyLength()];
        CellUtil.copyFamilyTo(cell, output, 0);
        return output;
    }

    public static byte[] getQualifierArray(Cell cell) {
        byte[] output = new byte[cell.getQualifierLength()];
        CellUtil.copyQualifierTo(cell, output, 0);
        return output;
    }

    public static byte[] getValueArray(Cell cell) {
        byte[] output = new byte[cell.getValueLength()];
        CellUtil.copyValueTo(cell, output, 0);
        return output;
    }

    public static int copyRowTo(Cell cell, byte[] destination, int destinationOffset) {
        System.arraycopy(cell.getRowArray(), cell.getRowOffset(), destination, destinationOffset, cell.getRowLength());
        return destinationOffset + cell.getRowLength();
    }

    public static int copyFamilyTo(Cell cell, byte[] destination, int destinationOffset) {
        System.arraycopy(cell.getFamilyArray(), cell.getFamilyOffset(), destination, destinationOffset, cell.getFamilyLength());
        return destinationOffset + cell.getFamilyLength();
    }

    public static int copyQualifierTo(Cell cell, byte[] destination, int destinationOffset) {
        System.arraycopy(cell.getQualifierArray(), cell.getQualifierOffset(), destination, destinationOffset, cell.getQualifierLength());
        return destinationOffset + cell.getQualifierLength();
    }

    public static int copyValueTo(Cell cell, byte[] destination, int destinationOffset) {
        System.arraycopy(cell.getValueArray(), cell.getValueOffset(), destination, destinationOffset, cell.getValueLength());
        return destinationOffset + cell.getValueLength();
    }

    public static byte getRowByte(Cell cell, int index) {
        return cell.getRowArray()[cell.getRowOffset() + index];
    }

    public static ByteBuffer getValueBufferShallowCopy(Cell cell) {
        ByteBuffer buffer = ByteBuffer.wrap(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
        return buffer;
    }

    public static Cell createCell(byte[] row, byte[] family, byte[] qualifier, long timestamp, byte type, byte[] value) {
        return new KeyValue(row, family, qualifier, timestamp, KeyValue.Type.codeToType(type), value);
    }

    public static CellScanner createCellScanner(final List<CellScannable> cellScannerables) {
        return new CellScanner(){
            private final Iterator<CellScannable> iterator;
            private CellScanner cellScanner;
            {
                this.iterator = cellScannerables.iterator();
                this.cellScanner = null;
            }

            @Override
            public Cell current() {
                return this.cellScanner != null ? this.cellScanner.current() : null;
            }

            @Override
            public boolean advance() throws IOException {
                if (this.cellScanner == null) {
                    if (!this.iterator.hasNext()) {
                        return false;
                    }
                    this.cellScanner = this.iterator.next().cellScanner();
                }
                if (this.cellScanner.advance()) {
                    return true;
                }
                this.cellScanner = null;
                return this.advance();
            }
        };
    }

    public static CellScanner createCellScanner(Iterable<Cell> cellIterable) {
        return CellUtil.createCellScanner(cellIterable.iterator());
    }

    public static CellScanner createCellScanner(final Iterator<Cell> cells) {
        return new CellScanner(){
            private final Iterator<Cell> iterator;
            private Cell current;
            {
                this.iterator = cells;
                this.current = null;
            }

            @Override
            public Cell current() {
                return this.current;
            }

            @Override
            public boolean advance() {
                boolean hasNext = this.iterator.hasNext();
                this.current = hasNext ? this.iterator.next() : null;
                return hasNext;
            }
        };
    }

    public static CellScanner createCellScanner(final Cell[] cellArray) {
        return new CellScanner(){
            private final Cell[] cells;
            private int index;
            {
                this.cells = cellArray;
                this.index = -1;
            }

            @Override
            public Cell current() {
                return this.index < 0 ? null : this.cells[this.index];
            }

            @Override
            public boolean advance() {
                return ++this.index < this.cells.length;
            }
        };
    }

    public static CellScanner createCellScanner(final NavigableMap<byte[], List<? extends Cell>> map) {
        return new CellScanner(){
            private final Iterator<Map.Entry<byte[], List<? extends Cell>>> entries;
            private Iterator<? extends Cell> currentIterator;
            private Cell currentCell;
            {
                this.entries = map.entrySet().iterator();
                this.currentIterator = null;
            }

            @Override
            public Cell current() {
                return this.currentCell;
            }

            @Override
            public boolean advance() {
                if (this.currentIterator == null) {
                    if (!this.entries.hasNext()) {
                        return false;
                    }
                    this.currentIterator = this.entries.next().getValue().iterator();
                }
                if (this.currentIterator.hasNext()) {
                    this.currentCell = this.currentIterator.next();
                    return true;
                }
                this.currentCell = null;
                this.currentIterator = null;
                return this.advance();
            }
        };
    }
}

