/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.EncoderBufferTooSmallException;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
abstract class BufferedDataBlockEncoder
implements DataBlockEncoder {
    private static int INITIAL_KEY_BUFFER_SIZE = 512;

    BufferedDataBlockEncoder() {
    }

    @Override
    public ByteBuffer decodeKeyValues(DataInputStream source, boolean includesMemstoreTS) throws IOException {
        return this.decodeKeyValues(source, 0, 0, includesMemstoreTS);
    }

    protected final void afterEncodingKeyValue(ByteBuffer in, DataOutputStream out, boolean includesMemstoreTS) {
        if (includesMemstoreTS) {
            long memstoreTS = -1L;
            try {
                memstoreTS = ByteBufferUtils.readVLong(in);
                WritableUtils.writeVLong((DataOutput)out, (long)memstoreTS);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to copy memstore timestamp " + memstoreTS + " after encoding a key/value");
            }
        }
    }

    protected final void afterDecodingKeyValue(DataInputStream source, ByteBuffer dest, boolean includesMemstoreTS) {
        if (includesMemstoreTS) {
            long memstoreTS = -1L;
            try {
                memstoreTS = WritableUtils.readVLong((DataInput)source);
                ByteBufferUtils.writeVLong(dest, memstoreTS);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to copy memstore timestamp " + memstoreTS + " after decoding a key/value");
            }
        }
    }

    @Override
    public HFileBlockEncodingContext newDataBlockEncodingContext(Compression.Algorithm compressionAlgorithm, DataBlockEncoding encoding, byte[] header) {
        return new HFileBlockDefaultEncodingContext(compressionAlgorithm, encoding, header);
    }

    @Override
    public HFileBlockDecodingContext newDataBlockDecodingContext(Compression.Algorithm compressionAlgorithm) {
        return new HFileBlockDefaultDecodingContext(compressionAlgorithm);
    }

    public abstract void internalEncodeKeyValues(DataOutputStream var1, ByteBuffer var2, boolean var3) throws IOException;

    @Override
    public void encodeKeyValues(ByteBuffer in, boolean includesMemstoreTS, HFileBlockEncodingContext blkEncodingCtx) throws IOException {
        if (blkEncodingCtx.getClass() != HFileBlockDefaultEncodingContext.class) {
            throw new IOException(this.getClass().getName() + " only accepts " + HFileBlockDefaultEncodingContext.class.getName() + " as the " + "encoding context.");
        }
        HFileBlockDefaultEncodingContext encodingCtx = (HFileBlockDefaultEncodingContext)blkEncodingCtx;
        encodingCtx.prepareEncoding();
        DataOutputStream dataOut = encodingCtx.getOutputStreamForEncoder();
        this.internalEncodeKeyValues(dataOut, in, includesMemstoreTS);
        if (encodingCtx.getDataBlockEncoding() != DataBlockEncoding.NONE) {
            encodingCtx.postEncoding(BlockType.ENCODED_DATA);
        } else {
            encodingCtx.postEncoding(BlockType.DATA);
        }
    }

    protected static void ensureSpace(ByteBuffer out, int length) throws EncoderBufferTooSmallException {
        if (out.position() + length > out.limit()) {
            throw new EncoderBufferTooSmallException("Buffer position=" + out.position() + ", buffer limit=" + out.limit() + ", length to be written=" + length);
        }
    }

    static /* synthetic */ int access$000() {
        return INITIAL_KEY_BUFFER_SIZE;
    }

    protected static abstract class BufferedEncodedSeeker<STATE extends SeekerState>
    implements DataBlockEncoder.EncodedSeeker {
        protected final RawComparator<byte[]> comparator;
        protected final KeyValue.SamePrefixComparator<byte[]> samePrefixComparator;
        protected ByteBuffer currentBuffer;
        protected STATE current = this.createSeekerState();
        protected STATE previous = this.createSeekerState();

        public BufferedEncodedSeeker(RawComparator<byte[]> comparator) {
            this.comparator = comparator;
            this.samePrefixComparator = comparator instanceof KeyValue.SamePrefixComparator ? (KeyValue.SamePrefixComparator)comparator : null;
        }

        @Override
        public void setCurrentBuffer(ByteBuffer buffer) {
            this.currentBuffer = buffer;
            this.decodeFirst();
            ((SeekerState)this.previous).invalidate();
        }

        @Override
        public ByteBuffer getKeyDeepCopy() {
            ByteBuffer keyBuffer = ByteBuffer.allocate(((SeekerState)this.current).keyLength);
            keyBuffer.put(((SeekerState)this.current).keyBuffer, 0, ((SeekerState)this.current).keyLength);
            return keyBuffer;
        }

        @Override
        public ByteBuffer getValueShallowCopy() {
            return ByteBuffer.wrap(this.currentBuffer.array(), this.currentBuffer.arrayOffset() + ((SeekerState)this.current).valueOffset, ((SeekerState)this.current).valueLength);
        }

        @Override
        public ByteBuffer getKeyValueBuffer() {
            ByteBuffer kvBuffer = ByteBuffer.allocate(8 + ((SeekerState)this.current).keyLength + ((SeekerState)this.current).valueLength);
            kvBuffer.putInt(((SeekerState)this.current).keyLength);
            kvBuffer.putInt(((SeekerState)this.current).valueLength);
            kvBuffer.put(((SeekerState)this.current).keyBuffer, 0, ((SeekerState)this.current).keyLength);
            kvBuffer.put(this.currentBuffer.array(), this.currentBuffer.arrayOffset() + ((SeekerState)this.current).valueOffset, ((SeekerState)this.current).valueLength);
            return kvBuffer;
        }

        @Override
        public KeyValue getKeyValue() {
            ByteBuffer kvBuf = this.getKeyValueBuffer();
            KeyValue kv = new KeyValue(kvBuf.array(), kvBuf.arrayOffset());
            kv.setMemstoreTS(((SeekerState)this.current).memstoreTS);
            return kv;
        }

        @Override
        public void rewind() {
            this.currentBuffer.rewind();
            this.decodeFirst();
            ((SeekerState)this.previous).invalidate();
        }

        @Override
        public boolean next() {
            if (!this.currentBuffer.hasRemaining()) {
                return false;
            }
            this.decodeNext();
            ((SeekerState)this.previous).invalidate();
            return true;
        }

        @Override
        public int seekToKeyInBlock(byte[] key, int offset, int length, boolean seekBefore) {
            int commonPrefix = 0;
            ((SeekerState)this.previous).invalidate();
            while (true) {
                int comp;
                if (this.samePrefixComparator != null) {
                    commonPrefix = Math.min(commonPrefix, ((SeekerState)this.current).lastCommonPrefix);
                    commonPrefix += ByteBufferUtils.findCommonPrefix(key, offset + commonPrefix, length - commonPrefix, ((SeekerState)this.current).keyBuffer, commonPrefix, ((SeekerState)this.current).keyLength - commonPrefix);
                    comp = this.samePrefixComparator.compareIgnoringPrefix(commonPrefix, key, offset, length, ((SeekerState)this.current).keyBuffer, 0, ((SeekerState)this.current).keyLength);
                } else {
                    comp = this.comparator.compare(key, offset, length, ((SeekerState)this.current).keyBuffer, 0, ((SeekerState)this.current).keyLength);
                }
                if (comp == 0) {
                    if (seekBefore) {
                        if (!((SeekerState)this.previous).isValid()) {
                            throw new IllegalStateException("Cannot seekBefore if positioned at the first key in the block: key=" + Bytes.toStringBinary(key, offset, length));
                        }
                        this.moveToPrevious();
                        return 1;
                    }
                    return 0;
                }
                if (comp < 0) {
                    if (!((SeekerState)this.previous).isValid()) {
                        return -2;
                    }
                    this.moveToPrevious();
                    return 1;
                }
                if (!this.currentBuffer.hasRemaining()) break;
                ((SeekerState)this.previous).copyFromNext((SeekerState)this.current);
                this.decodeNext();
            }
            return 1;
        }

        private void moveToPrevious() {
            if (!((SeekerState)this.previous).isValid()) {
                throw new IllegalStateException("Can move back only once and not in first key in the block.");
            }
            STATE tmp = this.previous;
            this.previous = this.current;
            this.current = tmp;
            this.currentBuffer.position(((SeekerState)this.current).nextKvOffset);
            ((SeekerState)this.previous).invalidate();
        }

        protected STATE createSeekerState() {
            return (STATE)new SeekerState();
        }

        protected abstract void decodeFirst();

        protected abstract void decodeNext();
    }

    protected static class SeekerState {
        protected int valueOffset = -1;
        protected int keyLength;
        protected int valueLength;
        protected int lastCommonPrefix;
        protected byte[] keyBuffer = new byte[BufferedDataBlockEncoder.access$000()];
        protected long memstoreTS;
        protected int nextKvOffset;

        protected SeekerState() {
        }

        protected boolean isValid() {
            return this.valueOffset != -1;
        }

        protected void invalidate() {
            this.valueOffset = -1;
        }

        protected void ensureSpaceForKey() {
            if (this.keyLength > this.keyBuffer.length) {
                int newKeyBufferLength;
                for (newKeyBufferLength = Math.max(this.keyBuffer.length, 1) * 2; this.keyLength > newKeyBufferLength; newKeyBufferLength *= 2) {
                }
                byte[] newKeyBuffer = new byte[newKeyBufferLength];
                System.arraycopy(this.keyBuffer, 0, newKeyBuffer, 0, this.keyBuffer.length);
                this.keyBuffer = newKeyBuffer;
            }
        }

        protected void copyFromNext(SeekerState nextState) {
            if (this.keyBuffer.length != nextState.keyBuffer.length) {
                this.keyBuffer = (byte[])nextState.keyBuffer.clone();
            } else if (!this.isValid()) {
                System.arraycopy(nextState.keyBuffer, 0, this.keyBuffer, 0, nextState.keyLength);
            } else {
                System.arraycopy(nextState.keyBuffer, nextState.lastCommonPrefix, this.keyBuffer, nextState.lastCommonPrefix, nextState.keyLength - nextState.lastCommonPrefix);
            }
            this.valueOffset = nextState.valueOffset;
            this.keyLength = nextState.keyLength;
            this.valueLength = nextState.valueLength;
            this.lastCommonPrefix = nextState.lastCommonPrefix;
            this.nextKvOffset = nextState.nextKvOffset;
            this.memstoreTS = nextState.memstoreTS;
        }
    }
}

