/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;

public class HFileBlockDefaultEncodingContext
implements HFileBlockEncodingContext {
    private byte[] onDiskBytesWithHeader;
    private byte[] uncompressedBytesWithHeader;
    private BlockType blockType;
    private final DataBlockEncoding encodingAlgo;
    private Compressor compressor;
    private CompressionOutputStream compressionStream;
    private ByteArrayOutputStream compressedByteStream;
    private final Compression.Algorithm compressionAlgorithm;
    private ByteArrayOutputStream encodedStream = new ByteArrayOutputStream();
    private DataOutputStream dataOut = new DataOutputStream(this.encodedStream);
    private byte[] dummyHeader;

    public HFileBlockDefaultEncodingContext(Compression.Algorithm compressionAlgorithm, DataBlockEncoding encoding, byte[] headerBytes) {
        this.encodingAlgo = encoding;
        Compression.Algorithm algorithm = this.compressionAlgorithm = compressionAlgorithm == null ? Compression.Algorithm.NONE : compressionAlgorithm;
        if (this.compressionAlgorithm != Compression.Algorithm.NONE) {
            this.compressor = compressionAlgorithm.getCompressor();
            this.compressedByteStream = new ByteArrayOutputStream();
            try {
                this.compressionStream = compressionAlgorithm.createPlainCompressionStream(this.compressedByteStream, this.compressor);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create compression stream for algorithm " + (Object)((Object)compressionAlgorithm), e);
            }
        }
        this.dummyHeader = (byte[])Preconditions.checkNotNull((Object)headerBytes, (Object)"Please pass HConstants.HFILEBLOCK_DUMMY_HEADER instead of null for param headerBytes");
    }

    @Override
    public void setDummyHeader(byte[] headerBytes) {
        this.dummyHeader = headerBytes;
    }

    public void prepareEncoding() throws IOException {
        this.encodedStream.reset();
        this.dataOut.write(this.dummyHeader);
        if (this.encodingAlgo != null && this.encodingAlgo != DataBlockEncoding.NONE) {
            this.encodingAlgo.writeIdInBytes(this.dataOut);
        }
    }

    @Override
    public void postEncoding(BlockType blockType) throws IOException {
        this.dataOut.flush();
        this.compressAfterEncodingWithBlockType(this.encodedStream.toByteArray(), blockType);
        this.blockType = blockType;
    }

    public void compressAfterEncodingWithBlockType(byte[] uncompressedBytesWithHeader, BlockType blockType) throws IOException {
        this.compressAfterEncoding(uncompressedBytesWithHeader, blockType, this.dummyHeader);
    }

    protected void compressAfterEncoding(byte[] uncompressedBytesWithHeader, BlockType blockType, byte[] headerBytes) throws IOException {
        this.uncompressedBytesWithHeader = uncompressedBytesWithHeader;
        if (this.compressionAlgorithm != Compression.Algorithm.NONE) {
            this.compressedByteStream.reset();
            this.compressedByteStream.write(headerBytes);
            this.compressionStream.resetState();
            this.compressionStream.write(uncompressedBytesWithHeader, headerBytes.length, uncompressedBytesWithHeader.length - headerBytes.length);
            this.compressionStream.flush();
            this.compressionStream.finish();
            this.onDiskBytesWithHeader = this.compressedByteStream.toByteArray();
        } else {
            this.onDiskBytesWithHeader = uncompressedBytesWithHeader;
        }
        this.blockType = blockType;
    }

    @Override
    public byte[] getOnDiskBytesWithHeader() {
        return this.onDiskBytesWithHeader;
    }

    @Override
    public byte[] getUncompressedBytesWithHeader() {
        return this.uncompressedBytesWithHeader;
    }

    @Override
    public BlockType getBlockType() {
        return this.blockType;
    }

    @Override
    public void close() {
        if (this.compressor != null) {
            this.compressionAlgorithm.returnCompressor(this.compressor);
            this.compressor = null;
        }
    }

    @Override
    public Compression.Algorithm getCompression() {
        return this.compressionAlgorithm;
    }

    @Override
    public DataOutputStream getOutputStreamForEncoder() {
        return this.dataOut;
    }

    @Override
    public DataBlockEncoding getDataBlockEncoding() {
        return this.encodingAlgo;
    }
}

