/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.util.ArrayUtils;
import org.apache.hadoop.hbase.util.Bytes;

public class ByteRange
implements Comparable<ByteRange> {
    private static final int UNSET_HASH_VALUE = -1;
    private byte[] bytes;
    private int offset;
    private int length;
    private int hash = -1;

    public ByteRange() {
        this.set(new byte[0]);
    }

    public ByteRange(byte[] bytes) {
        this.set(bytes);
    }

    public ByteRange(byte[] bytes, int offset, int length) {
        this.set(bytes, offset, length);
    }

    public ByteRange clear() {
        this.clearHashCache();
        this.bytes = null;
        this.offset = 0;
        this.length = 0;
        return this;
    }

    public ByteRange set(byte[] bytes) {
        this.clearHashCache();
        this.bytes = bytes;
        this.offset = 0;
        this.length = ArrayUtils.length(bytes);
        return this;
    }

    public ByteRange set(byte[] bytes, int offset, int length) {
        this.clearHashCache();
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
        return this;
    }

    public void setLength(int length) {
        this.clearHashCache();
        this.length = length;
    }

    public byte get(int index) {
        return this.bytes[this.offset + index];
    }

    public byte[] deepCopyToNewArray() {
        byte[] result = new byte[this.length];
        System.arraycopy(this.bytes, this.offset, result, 0, this.length);
        return result;
    }

    public ByteRange deepCopy() {
        ByteRange clone = new ByteRange(this.deepCopyToNewArray());
        if (this.isHashCached()) {
            clone.hash = this.hash;
        }
        return clone;
    }

    public void deepCopyTo(byte[] destination, int destinationOffset) {
        System.arraycopy(this.bytes, this.offset, destination, destinationOffset, this.length);
    }

    public void deepCopySubRangeTo(int innerOffset, int copyLength, byte[] destination, int destinationOffset) {
        System.arraycopy(this.bytes, this.offset + innerOffset, destination, destinationOffset, copyLength);
    }

    public ByteRange shallowCopySubRange(int innerOffset, int copyLength) {
        ByteRange clone = new ByteRange(this.bytes, this.offset + innerOffset, copyLength);
        if (this.isHashCached()) {
            clone.hash = this.hash;
        }
        return clone;
    }

    public int numEqualPrefixBytes(ByteRange that, int thatInnerOffset) {
        int maxCompares = Math.min(this.length, that.length - thatInnerOffset);
        for (int i = 0; i < maxCompares; ++i) {
            if (this.bytes[this.offset + i] == that.bytes[that.offset + thatInnerOffset + i]) continue;
            return i;
        }
        return maxCompares;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isEmpty() {
        return ByteRange.isEmpty(this);
    }

    public boolean notEmpty() {
        return ByteRange.notEmpty(this);
    }

    public static boolean isEmpty(ByteRange range) {
        return range == null || range.length == 0;
    }

    public static boolean notEmpty(ByteRange range) {
        return range != null && range.length > 0;
    }

    public boolean equals(Object thatObject) {
        if (thatObject == null) {
            return false;
        }
        if (this == thatObject) {
            return true;
        }
        if (this.hashCode() != thatObject.hashCode()) {
            return false;
        }
        if (!(thatObject instanceof ByteRange)) {
            return false;
        }
        ByteRange that = (ByteRange)thatObject;
        return Bytes.equals(this.bytes, this.offset, this.length, that.bytes, that.offset, that.length);
    }

    public int hashCode() {
        if (this.isHashCached()) {
            return this.hash;
        }
        if (this.isEmpty()) {
            this.hash = 0;
            return this.hash;
        }
        int off = this.offset;
        this.hash = 0;
        for (int i = 0; i < this.length; ++i) {
            this.hash = 31 * this.hash + this.bytes[off++];
        }
        return this.hash;
    }

    private boolean isHashCached() {
        return this.hash != -1;
    }

    private void clearHashCache() {
        this.hash = -1;
    }

    @Override
    public int compareTo(ByteRange other) {
        return Bytes.compareTo(this.bytes, this.offset, this.length, other.bytes, other.offset, other.length);
    }

    public String toString() {
        return Bytes.toStringBinary(this.bytes, this.offset, this.length);
    }
}

