/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.lang.reflect.InvocationTargetException;

public class ReflectionUtils {
    public static <T> T instantiateWithCustomCtor(String className, Class<?>[] ctorArgTypes, Object[] ctorArgs) {
        try {
            Class<?> resultType = Class.forName(className);
            return (T)resultType.getDeclaredConstructor(ctorArgTypes).newInstance(ctorArgs);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Unable to find " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException("Unable to access specified class " + className, e);
        }
        catch (InstantiationException e) {
            throw new UnsupportedOperationException("Unable to instantiate specified class " + className, e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException("Constructor threw an exception for " + className, e);
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("Unable to find suitable constructor for class " + className, e);
        }
    }
}

