/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.test;

import java.util.Random;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.MD5Hash;

public class LoadTestKVGenerator {
    private Random randomForValueSize = new Random();
    private final int minValueSize;
    private final int maxValueSize;

    public LoadTestKVGenerator(int minValueSize, int maxValueSize) {
        if (minValueSize <= 0 || maxValueSize <= 0) {
            throw new IllegalArgumentException("Invalid min/max value sizes: " + minValueSize + ", " + maxValueSize);
        }
        this.minValueSize = minValueSize;
        this.maxValueSize = maxValueSize;
    }

    public static boolean verify(byte[] value, byte[] ... seedStrings) {
        byte[] expectedData = LoadTestKVGenerator.getValueForRowColumn(value.length, seedStrings);
        return Bytes.equals(expectedData, value);
    }

    public static String md5PrefixedKey(long key) {
        String stringKey = Long.toString(key);
        String md5hash = MD5Hash.getMD5AsHex(Bytes.toBytes(stringKey));
        return md5hash + "-" + stringKey;
    }

    public byte[] generateRandomSizeValue(byte[] ... seedStrings) {
        int dataSize = this.minValueSize;
        if (this.minValueSize != this.maxValueSize) {
            dataSize = this.minValueSize + this.randomForValueSize.nextInt(Math.abs(this.maxValueSize - this.minValueSize));
        }
        return LoadTestKVGenerator.getValueForRowColumn(dataSize, seedStrings);
    }

    private static byte[] getValueForRowColumn(int dataSize, byte[] ... seedStrings) {
        long seed = dataSize;
        for (byte[] str : seedStrings) {
            seed += (long)Bytes.toString(str).hashCode();
        }
        Random seededRandom = new Random(seed);
        byte[] randomBytes = new byte[dataSize];
        seededRandom.nextBytes(randomBytes);
        return randomBytes;
    }
}

