/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;

@InterfaceAudience.Private
public class HFileBlockDefaultDecodingContext
implements HFileBlockDecodingContext {
    private final Compression.Algorithm compressAlgo;

    public HFileBlockDefaultDecodingContext(Compression.Algorithm compressAlgo) {
        this.compressAlgo = compressAlgo;
    }

    @Override
    public void prepareDecoding(int onDiskSizeWithoutHeader, int uncompressedSizeWithoutHeader, ByteBuffer blockBufferWithoutHeader, byte[] onDiskBlock, int offset) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(onDiskBlock, offset, onDiskSizeWithoutHeader));
        Compression.decompress(blockBufferWithoutHeader.array(), blockBufferWithoutHeader.arrayOffset(), dis, onDiskSizeWithoutHeader, uncompressedSizeWithoutHeader, this.compressAlgo);
    }

    @Override
    public Compression.Algorithm getCompression() {
        return this.compressAlgo;
    }
}

