/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Order;
import org.apache.hadoop.hbase.util.OrderedBytes;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.hadoop.hbase.util.SimplePositionedByteRange;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestOrderedBytes {
    static final Long[] I_VALS = new Long[]{0L, 1L, 10L, 99L, 100L, 1234L, 9999L, 10000L, 10001L, 12345L, 123450L, Long.MAX_VALUE, -1L, -10L, -99L, -100L, -123L, -999L, -10000L, -10001L, -12345L, -123450L, Long.MIN_VALUE};
    static final int[] I_LENGTHS = new int[]{1, 2, 2, 2, 2, 3, 3, 2, 4, 4, 4, 11, 2, 2, 2, 2, 3, 3, 2, 4, 4, 4, 11};
    static final Double[] D_VALS = new Double[]{0.0, 0.00123, 0.0123, 0.123, 1.0, 10.0, 12.345, 99.0, 99.01, 99.0001, 100.0, 100.01, 100.1, 1234.0, 1234.5, 9999.0, 9999.000001, 9999.000009, 9999.00001, 9999.00009, 9999.000099, 9999.0001, 9999.001, 9999.01, 9999.1, 10000.0, 10001.0, 12345.0, 123450.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NaN, Double.MAX_VALUE, -0.00123, -0.0123, -0.123, -1.0, -10.0, -12.345, -99.0, -99.01, -99.0001, -100.0, -100.01, -100.1, -1234.0, -1234.5, -9999.0, -9999.000001, -9999.000009, -9999.00001, -9999.00009, -9999.000099, -9999.0001, -9999.001, -9999.01, -9999.1, -10000.0, -10001.0, -12345.0, -123450.0};
    static final int[] D_LENGTHS = new int[]{1, 4, 4, 4, 2, 2, 4, 2, 3, 4, 2, 4, 4, 3, 4, 3, 6, 6, 6, 6, 6, 5, 5, 4, 4, 2, 4, 4, 4, 1, 1, 1, 11, 4, 4, 4, 2, 2, 4, 2, 3, 4, 2, 4, 4, 3, 4, 3, 6, 6, 6, 6, 6, 5, 5, 4, 4, 2, 4, 4, 4};
    static final BigDecimal[] BD_VALS = new BigDecimal[]{null, BigDecimal.valueOf(Long.MAX_VALUE), BigDecimal.valueOf(Long.MIN_VALUE), BigDecimal.valueOf(Double.MAX_VALUE), BigDecimal.valueOf(Double.MIN_VALUE), BigDecimal.valueOf(Long.MAX_VALUE).multiply(BigDecimal.valueOf(100L))};
    static final int[] BD_LENGTHS = new int[]{1, 11, 11, 11, 4, 12};
    static final double MIN_EPSILON = 1.0E-6;

    @Test
    public void testVerifyTestIntegrity() {
        for (int i = 0; i < I_VALS.length; ++i) {
            for (int d = 0; d < D_VALS.length; ++d) {
                if (!(Math.abs((double)I_VALS[i].longValue() - D_VALS[d]) < 1.0E-6)) continue;
                Assert.assertEquals((String)("Test inconsistency detected: expected lengths for " + I_VALS[i] + " do not match."), (long)I_LENGTHS[i], (long)D_LENGTHS[d]);
            }
        }
    }

    @Test
    public void testVaruint64Boundaries() {
        long[] vals = new long[]{239L, 240L, 2286L, 2287L, 67822L, 67823L, 0xFFFFFEL, 0xFFFFFFL, 0xFFFFFFFEL, 0xFFFFFFFFL, 0xFFFFFFFFFEL, 0xFFFFFFFFFFL, 0xFFFFFFFFFFFEL, 0xFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFEL, 0xFFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFFEL, Long.MAX_VALUE, -9223372036854775807L, Long.MIN_VALUE, -2L, -1L};
        int[] lens = new int[]{1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 9, 9, 9, 9};
        Assert.assertEquals((String)"Broken test!", (long)vals.length, (long)lens.length);
        for (boolean comp : new boolean[]{true, false}) {
            for (int i = 0; i < vals.length; ++i) {
                byte[] a = new byte[lens[i] + 2];
                SimplePositionedByteRange buf = new SimplePositionedByteRange(a, 1, lens[i]);
                Assert.assertEquals((String)"Surprising return value.", (long)lens[i], (long)OrderedBytes.putVaruint64((PositionedByteRange)buf, (long)vals[i], (boolean)comp));
                Assert.assertEquals((String)"Surprising serialized length.", (long)lens[i], (long)buf.getPosition());
                Assert.assertEquals((String)"Buffer underflow.", (long)0L, (long)a[0]);
                Assert.assertEquals((String)"Buffer overflow.", (long)0L, (long)a[a.length - 1]);
                buf.setPosition(0);
                Assert.assertEquals((String)"Surprising return value.", (long)lens[i], (long)OrderedBytes.skipVaruint64((PositionedByteRange)buf, (boolean)comp));
                Assert.assertEquals((String)"Did not skip enough bytes.", (long)lens[i], (long)buf.getPosition());
                buf.setPosition(0);
                Assert.assertEquals((String)"Deserialization failed.", (long)vals[i], (long)OrderedBytes.getVaruint64((PositionedByteRange)buf, (boolean)comp));
                Assert.assertEquals((String)"Did not consume enough bytes.", (long)lens[i], (long)buf.getPosition());
            }
        }
    }

    @Test
    public void testNumericInt() {
        for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
            for (int i = 0; i < I_VALS.length; ++i) {
                byte[] a = new byte[I_LENGTHS[i] + 3];
                SimplePositionedByteRange buf1 = new SimplePositionedByteRange(a, 1, I_LENGTHS[i] + 1);
                buf1.setPosition(1);
                Assert.assertEquals((String)"Surprising return value.", (long)I_LENGTHS[i], (long)OrderedBytes.encodeNumeric((PositionedByteRange)buf1, (long)I_VALS[i], (Order)ord));
                Assert.assertEquals((String)"Broken test: serialization did not consume entire buffer.", (long)buf1.getLength(), (long)buf1.getPosition());
                Assert.assertEquals((String)"Surprising serialized length.", (long)I_LENGTHS[i], (long)(buf1.getPosition() - 1));
                Assert.assertEquals((String)"Buffer underflow.", (long)0L, (long)a[0]);
                Assert.assertEquals((String)"Buffer underflow.", (long)0L, (long)a[1]);
                Assert.assertEquals((String)"Buffer overflow.", (long)0L, (long)a[a.length - 1]);
                buf1.setPosition(1);
                Assert.assertEquals((String)"Surprising return value.", (long)I_LENGTHS[i], (long)OrderedBytes.skip((PositionedByteRange)buf1));
                Assert.assertEquals((String)"Did not skip enough bytes.", (long)I_LENGTHS[i], (long)(buf1.getPosition() - 1));
                buf1.setPosition(1);
                Assert.assertEquals((String)"Deserialization failed.", (long)I_VALS[i], (long)OrderedBytes.decodeNumericAsLong((PositionedByteRange)buf1));
                Assert.assertEquals((String)"Did not consume enough bytes.", (long)I_LENGTHS[i], (long)(buf1.getPosition() - 1));
            }
        }
        for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
            byte[][] encoded = new byte[I_VALS.length][];
            SimplePositionedByteRange pbr = new SimplePositionedByteRange();
            for (int i = 0; i < I_VALS.length; ++i) {
                encoded[i] = new byte[I_LENGTHS[i]];
                OrderedBytes.encodeNumeric((PositionedByteRange)pbr.set(encoded[i]), (long)I_VALS[i], (Order)ord);
            }
            Arrays.sort(encoded, Bytes.BYTES_COMPARATOR);
            Object[] sortedVals = Arrays.copyOf(I_VALS, I_VALS.length);
            if (ord == Order.ASCENDING) {
                Arrays.sort(sortedVals);
            } else {
                Arrays.sort(sortedVals, Collections.reverseOrder());
            }
            for (int i = 0; i < sortedVals.length; ++i) {
                pbr.set(encoded[i]);
                long decoded = OrderedBytes.decodeNumericAsLong((PositionedByteRange)pbr);
                Assert.assertEquals((String)String.format("Encoded representations do not preserve natural order: <%s>, <%s>, %s", sortedVals[i], decoded, ord), (long)((Long)sortedVals[i]), (long)decoded);
            }
        }
    }

    @Test
    public void testNumericReal() {
        for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
            for (int i = 0; i < D_VALS.length; ++i) {
                byte[] a = new byte[D_LENGTHS[i] + 3];
                SimplePositionedByteRange buf1 = new SimplePositionedByteRange(a, 1, D_LENGTHS[i] + 1);
                buf1.setPosition(1);
                Assert.assertEquals((String)"Surprising return value.", (long)D_LENGTHS[i], (long)OrderedBytes.encodeNumeric((PositionedByteRange)buf1, (double)D_VALS[i], (Order)ord));
                Assert.assertEquals((String)"Broken test: serialization did not consume entire buffer.", (long)buf1.getLength(), (long)buf1.getPosition());
                Assert.assertEquals((String)"Surprising serialized length.", (long)D_LENGTHS[i], (long)(buf1.getPosition() - 1));
                Assert.assertEquals((String)"Buffer underflow.", (long)0L, (long)a[0]);
                Assert.assertEquals((String)"Buffer underflow.", (long)0L, (long)a[1]);
                Assert.assertEquals((String)"Buffer overflow.", (long)0L, (long)a[a.length - 1]);
                buf1.setPosition(1);
                Assert.assertEquals((String)"Surprising return value.", (long)D_LENGTHS[i], (long)OrderedBytes.skip((PositionedByteRange)buf1));
                Assert.assertEquals((String)"Did not skip enough bytes.", (long)D_LENGTHS[i], (long)(buf1.getPosition() - 1));
                buf1.setPosition(1);
                Assert.assertEquals((String)"Deserialization failed.", (double)D_VALS[i], (double)OrderedBytes.decodeNumericAsDouble((PositionedByteRange)buf1), (double)1.0E-6);
                Assert.assertEquals((String)"Did not consume enough bytes.", (long)D_LENGTHS[i], (long)(buf1.getPosition() - 1));
            }
        }
        for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
            byte[][] encoded = new byte[D_VALS.length][];
            SimplePositionedByteRange pbr = new SimplePositionedByteRange();
            for (int i = 0; i < D_VALS.length; ++i) {
                encoded[i] = new byte[D_LENGTHS[i]];
                OrderedBytes.encodeNumeric((PositionedByteRange)pbr.set(encoded[i]), (double)D_VALS[i], (Order)ord);
            }
            Arrays.sort(encoded, Bytes.BYTES_COMPARATOR);
            Object[] sortedVals = Arrays.copyOf(D_VALS, D_VALS.length);
            if (ord == Order.ASCENDING) {
                Arrays.sort(sortedVals);
            } else {
                Arrays.sort(sortedVals, Collections.reverseOrder());
            }
            for (int i = 0; i < sortedVals.length; ++i) {
                pbr.set(encoded[i]);
                double decoded = OrderedBytes.decodeNumericAsDouble((PositionedByteRange)pbr);
                Assert.assertEquals((String)String.format("Encoded representations do not preserve natural order: <%s>, <%s>, %s", sortedVals[i], decoded, ord), (double)((Double)sortedVals[i]), (double)decoded, (double)1.0E-6);
            }
        }
    }

    @Test
    public void testNumericOther() {
        for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
            for (int i = 0; i < BD_VALS.length; ++i) {
                byte[] a = new byte[BD_LENGTHS[i] + 3];
                SimplePositionedByteRange buf1 = new SimplePositionedByteRange(a, 1, BD_LENGTHS[i] + 1);
                buf1.setPosition(1);
                Assert.assertEquals((String)"Surprising return value.", (long)BD_LENGTHS[i], (long)OrderedBytes.encodeNumeric((PositionedByteRange)buf1, (BigDecimal)BD_VALS[i], (Order)ord));
                Assert.assertEquals((String)"Broken test: serialization did not consume entire buffer.", (long)buf1.getLength(), (long)buf1.getPosition());
                Assert.assertEquals((String)"Surprising serialized length.", (long)BD_LENGTHS[i], (long)(buf1.getPosition() - 1));
                Assert.assertEquals((String)"Buffer underflow.", (long)0L, (long)a[0]);
                Assert.assertEquals((String)"Buffer underflow.", (long)0L, (long)a[1]);
                Assert.assertEquals((String)"Buffer overflow.", (long)0L, (long)a[a.length - 1]);
                buf1.setPosition(1);
                Assert.assertEquals((String)"Surprising return value.", (long)BD_LENGTHS[i], (long)OrderedBytes.skip((PositionedByteRange)buf1));
                Assert.assertEquals((String)"Did not skip enough bytes.", (long)BD_LENGTHS[i], (long)(buf1.getPosition() - 1));
                buf1.setPosition(1);
                BigDecimal decoded = OrderedBytes.decodeNumericAsBigDecimal((PositionedByteRange)buf1);
                if (null == BD_VALS[i]) {
                    Assert.assertEquals((Object)BD_VALS[i], (Object)decoded);
                } else {
                    Assert.assertEquals((String)"Deserialization failed.", (long)0L, (long)BD_VALS[i].compareTo(decoded));
                }
                Assert.assertEquals((String)"Did not consume enough bytes.", (long)BD_LENGTHS[i], (long)(buf1.getPosition() - 1));
            }
        }
    }

    @Test
    public void testNumericIntRealCompatibility() {
        for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
            for (int i = 0; i < I_VALS.length; ++i) {
                SimplePositionedByteRange pbri = new SimplePositionedByteRange(I_LENGTHS[i]);
                SimplePositionedByteRange pbrr = new SimplePositionedByteRange(I_LENGTHS[i]);
                OrderedBytes.encodeNumeric((PositionedByteRange)pbri, (long)I_VALS[i], (Order)ord);
                OrderedBytes.encodeNumeric((PositionedByteRange)pbrr, (long)I_VALS[i], (Order)ord);
                Assert.assertArrayEquals((String)"Integer and real encodings differ.", (byte[])pbri.getBytes(), (byte[])pbrr.getBytes());
                pbri.setPosition(0);
                pbrr.setPosition(0);
                Assert.assertEquals((long)I_VALS[i], (long)OrderedBytes.decodeNumericAsLong((PositionedByteRange)pbri));
                Assert.assertEquals((long)I_VALS[i], (long)((long)OrderedBytes.decodeNumericAsDouble((PositionedByteRange)pbrr)));
                BigDecimal bd = BigDecimal.valueOf(I_VALS[i]);
                SimplePositionedByteRange pbrbd = new SimplePositionedByteRange(I_LENGTHS[i]);
                OrderedBytes.encodeNumeric((PositionedByteRange)pbrbd, (BigDecimal)bd, (Order)ord);
                Assert.assertArrayEquals((String)"Integer and BigDecimal encodings differ.", (byte[])pbri.getBytes(), (byte[])pbrbd.getBytes());
                pbri.setPosition(0);
                Assert.assertEquals((String)"Value not preserved when decoding as Long", (long)0L, (long)bd.compareTo(BigDecimal.valueOf(OrderedBytes.decodeNumericAsLong((PositionedByteRange)pbri))));
            }
        }
    }

    @Test
    public void testInt8() {
        Byte[] vals = new Byte[]{(byte)-128, (byte)-64, (byte)0, (byte)63, (byte)127};
        for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
            for (int i = 0; i < vals.length; ++i) {
                byte[] a = new byte[5];
                SimplePositionedByteRange buf1 = new SimplePositionedByteRange(a, 1, 3);
                buf1.setPosition(1);
                Assert.assertEquals((String)"Surprising return value.", (long)2L, (long)OrderedBytes.encodeInt8((PositionedByteRange)buf1, (byte)vals[i], (Order)ord));
                Assert.assertEquals((String)"Broken test: serialization did not consume entire buffer.", (long)buf1.getLength(), (long)buf1.getPosition());
                Assert.assertEquals((String)"Surprising serialized length.", (long)2L, (long)(buf1.getPosition() - 1));
                Assert.assertEquals((String)"Buffer underflow.", (long)0L, (long)a[0]);
                Assert.assertEquals((String)"Buffer underflow.", (long)0L, (long)a[1]);
                Assert.assertEquals((String)"Buffer overflow.", (long)0L, (long)a[a.length - 1]);
                buf1.setPosition(1);
                Assert.assertEquals((String)"Surprising return value.", (long)2L, (long)OrderedBytes.skip((PositionedByteRange)buf1));
                Assert.assertEquals((String)"Did not skip enough bytes.", (long)2L, (long)(buf1.getPosition() - 1));
                buf1.setPosition(1);
                Assert.assertEquals((String)"Deserialization failed.", (long)vals[i].byteValue(), (long)OrderedBytes.decodeInt8((PositionedByteRange)buf1));
                Assert.assertEquals((String)"Did not consume enough bytes.", (long)2L, (long)(buf1.getPosition() - 1));
            }
        }
        for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
            byte[][] encoded = new byte[vals.length][2];
            SimplePositionedByteRange pbr = new SimplePositionedByteRange();
            for (int i = 0; i < vals.length; ++i) {
                OrderedBytes.encodeInt8((PositionedByteRange)pbr.set(encoded[i]), (byte)vals[i], (Order)ord);
            }
            Arrays.sort(encoded, Bytes.BYTES_COMPARATOR);
            Object[] sortedVals = Arrays.copyOf(vals, vals.length);
            if (ord == Order.ASCENDING) {
                Arrays.sort(sortedVals);
            } else {
                Arrays.sort(sortedVals, Collections.reverseOrder());
            }
            for (int i = 0; i < sortedVals.length; ++i) {
                byte decoded = OrderedBytes.decodeInt8((PositionedByteRange)pbr.set(encoded[i]));
                Assert.assertEquals((String)String.format("Encoded representations do not preserve natural order: <%s>, <%s>, %s", sortedVals[i], (int)decoded, ord), (long)((Byte)sortedVals[i]).byteValue(), (long)decoded);
            }
        }
    }

    @Test
    public void testInt16() {
        Short[] vals = new Short[]{(short)Short.MIN_VALUE, (short)-16384, (short)0, (short)16383, (short)Short.MAX_VALUE};
        for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
            for (int i = 0; i < vals.length; ++i) {
                byte[] a = new byte[6];
                SimplePositionedByteRange buf1 = new SimplePositionedByteRange(a, 1, 4);
                buf1.setPosition(1);
                Assert.assertEquals((String)"Surprising return value.", (long)3L, (long)OrderedBytes.encodeInt16((PositionedByteRange)buf1, (short)vals[i], (Order)ord));
                Assert.assertEquals((String)"Broken test: serialization did not consume entire buffer.", (long)buf1.getLength(), (long)buf1.getPosition());
                Assert.assertEquals((String)"Surprising serialized length.", (long)3L, (long)(buf1.getPosition() - 1));
                Assert.assertEquals((String)"Buffer underflow.", (long)0L, (long)a[0]);
                Assert.assertEquals((String)"Buffer underflow.", (long)0L, (long)a[1]);
                Assert.assertEquals((String)"Buffer overflow.", (long)0L, (long)a[a.length - 1]);
                buf1.setPosition(1);
                Assert.assertEquals((String)"Surprising return value.", (long)3L, (long)OrderedBytes.skip((PositionedByteRange)buf1));
                Assert.assertEquals((String)"Did not skip enough bytes.", (long)3L, (long)(buf1.getPosition() - 1));
                buf1.setPosition(1);
                Assert.assertEquals((String)"Deserialization failed.", (long)vals[i].shortValue(), (long)OrderedBytes.decodeInt16((PositionedByteRange)buf1));
                Assert.assertEquals((String)"Did not consume enough bytes.", (long)3L, (long)(buf1.getPosition() - 1));
            }
        }
        for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
            byte[][] encoded = new byte[vals.length][3];
            SimplePositionedByteRange pbr = new SimplePositionedByteRange();
            for (int i = 0; i < vals.length; ++i) {
                OrderedBytes.encodeInt16((PositionedByteRange)pbr.set(encoded[i]), (short)vals[i], (Order)ord);
            }
            Arrays.sort(encoded, Bytes.BYTES_COMPARATOR);
            Object[] sortedVals = Arrays.copyOf(vals, vals.length);
            if (ord == Order.ASCENDING) {
                Arrays.sort(sortedVals);
            } else {
                Arrays.sort(sortedVals, Collections.reverseOrder());
            }
            for (int i = 0; i < sortedVals.length; ++i) {
                short decoded = OrderedBytes.decodeInt16((PositionedByteRange)pbr.set(encoded[i]));
                Assert.assertEquals((String)String.format("Encoded representations do not preserve natural order: <%s>, <%s>, %s", sortedVals[i], (int)decoded, ord), (long)((Short)sortedVals[i]).shortValue(), (long)decoded);
            }
        }
    }

    @Test
    public void testInt32() {
        Integer[] vals = new Integer[]{Integer.MIN_VALUE, -1073741824, 0, 0x3FFFFFFF, Integer.MAX_VALUE};
        for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
            for (int i = 0; i < vals.length; ++i) {
                byte[] a = new byte[8];
                SimplePositionedByteRange buf1 = new SimplePositionedByteRange(a, 1, 6);
                buf1.setPosition(1);
                Assert.assertEquals((String)"Surprising return value.", (long)5L, (long)OrderedBytes.encodeInt32((PositionedByteRange)buf1, (int)vals[i], (Order)ord));
                Assert.assertEquals((String)"Broken test: serialization did not consume entire buffer.", (long)buf1.getLength(), (long)buf1.getPosition());
                Assert.assertEquals((String)"Surprising serialized length.", (long)5L, (long)(buf1.getPosition() - 1));
                Assert.assertEquals((String)"Buffer underflow.", (long)0L, (long)a[0]);
                Assert.assertEquals((String)"Buffer underflow.", (long)0L, (long)a[1]);
                Assert.assertEquals((String)"Buffer overflow.", (long)0L, (long)a[a.length - 1]);
                buf1.setPosition(1);
                Assert.assertEquals((String)"Surprising return value.", (long)5L, (long)OrderedBytes.skip((PositionedByteRange)buf1));
                Assert.assertEquals((String)"Did not skip enough bytes.", (long)5L, (long)(buf1.getPosition() - 1));
                buf1.setPosition(1);
                Assert.assertEquals((String)"Deserialization failed.", (long)vals[i].intValue(), (long)OrderedBytes.decodeInt32((PositionedByteRange)buf1));
                Assert.assertEquals((String)"Did not consume enough bytes.", (long)5L, (long)(buf1.getPosition() - 1));
            }
        }
        for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
            byte[][] encoded = new byte[vals.length][5];
            SimplePositionedByteRange pbr = new SimplePositionedByteRange();
            for (int i = 0; i < vals.length; ++i) {
                OrderedBytes.encodeInt32((PositionedByteRange)pbr.set(encoded[i]), (int)vals[i], (Order)ord);
            }
            Arrays.sort(encoded, Bytes.BYTES_COMPARATOR);
            Object[] sortedVals = Arrays.copyOf(vals, vals.length);
            if (ord == Order.ASCENDING) {
                Arrays.sort(sortedVals);
            } else {
                Arrays.sort(sortedVals, Collections.reverseOrder());
            }
            for (int i = 0; i < sortedVals.length; ++i) {
                int decoded = OrderedBytes.decodeInt32((PositionedByteRange)pbr.set(encoded[i]));
                Assert.assertEquals((String)String.format("Encoded representations do not preserve natural order: <%s>, <%s>, %s", sortedVals[i], decoded, ord), (long)((Integer)sortedVals[i]).intValue(), (long)decoded);
            }
        }
    }

    @Test
    public void testInt64() {
        Long[] vals = new Long[]{Long.MIN_VALUE, -4611686018427387904L, 0L, 0x3FFFFFFFFFFFFFFFL, Long.MAX_VALUE};
        for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
            for (int i = 0; i < vals.length; ++i) {
                byte[] a = new byte[12];
                SimplePositionedByteRange buf1 = new SimplePositionedByteRange(a, 1, 10);
                buf1.setPosition(1);
                Assert.assertEquals((String)"Surprising return value.", (long)9L, (long)OrderedBytes.encodeInt64((PositionedByteRange)buf1, (long)vals[i], (Order)ord));
                Assert.assertEquals((String)"Broken test: serialization did not consume entire buffer.", (long)buf1.getLength(), (long)buf1.getPosition());
                Assert.assertEquals((String)"Surprising serialized length.", (long)9L, (long)(buf1.getPosition() - 1));
                Assert.assertEquals((String)"Buffer underflow.", (long)0L, (long)a[0]);
                Assert.assertEquals((String)"Buffer underflow.", (long)0L, (long)a[1]);
                Assert.assertEquals((String)"Buffer overflow.", (long)0L, (long)a[a.length - 1]);
                buf1.setPosition(1);
                Assert.assertEquals((String)"Surprising return value.", (long)9L, (long)OrderedBytes.skip((PositionedByteRange)buf1));
                Assert.assertEquals((String)"Did not skip enough bytes.", (long)9L, (long)(buf1.getPosition() - 1));
                buf1.setPosition(1);
                Assert.assertEquals((String)"Deserialization failed.", (long)vals[i], (long)OrderedBytes.decodeInt64((PositionedByteRange)buf1));
                Assert.assertEquals((String)"Did not consume enough bytes.", (long)9L, (long)(buf1.getPosition() - 1));
            }
        }
        for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
            byte[][] encoded = new byte[vals.length][9];
            SimplePositionedByteRange pbr = new SimplePositionedByteRange();
            for (int i = 0; i < vals.length; ++i) {
                OrderedBytes.encodeInt64((PositionedByteRange)pbr.set(encoded[i]), (long)vals[i], (Order)ord);
            }
            Arrays.sort(encoded, Bytes.BYTES_COMPARATOR);
            Object[] sortedVals = Arrays.copyOf(vals, vals.length);
            if (ord == Order.ASCENDING) {
                Arrays.sort(sortedVals);
            } else {
                Arrays.sort(sortedVals, Collections.reverseOrder());
            }
            for (int i = 0; i < sortedVals.length; ++i) {
                long decoded = OrderedBytes.decodeInt64((PositionedByteRange)pbr.set(encoded[i]));
                Assert.assertEquals((String)String.format("Encoded representations do not preserve natural order: <%s>, <%s>, %s", sortedVals[i], decoded, ord), (long)((Long)sortedVals[i]), (long)decoded);
            }
        }
    }

    @Test
    public void testFloat32() {
        Float[] vals = new Float[]{Float.valueOf(Float.MIN_VALUE), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(1.7014117E38f), Float.valueOf(Float.MAX_VALUE)};
        for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
            for (int i = 0; i < vals.length; ++i) {
                byte[] a = new byte[8];
                SimplePositionedByteRange buf1 = new SimplePositionedByteRange(a, 1, 6);
                buf1.setPosition(1);
                Assert.assertEquals((String)"Surprising return value.", (long)5L, (long)OrderedBytes.encodeFloat32((PositionedByteRange)buf1, (float)vals[i].floatValue(), (Order)ord));
                Assert.assertEquals((String)"Broken test: serialization did not consume entire buffer.", (long)buf1.getLength(), (long)buf1.getPosition());
                Assert.assertEquals((String)"Surprising serialized length.", (long)5L, (long)(buf1.getPosition() - 1));
                Assert.assertEquals((String)"Buffer underflow.", (long)0L, (long)a[0]);
                Assert.assertEquals((String)"Buffer underflow.", (long)0L, (long)a[1]);
                Assert.assertEquals((String)"Buffer overflow.", (long)0L, (long)a[a.length - 1]);
                buf1.setPosition(1);
                Assert.assertEquals((String)"Surprising return value.", (long)5L, (long)OrderedBytes.skip((PositionedByteRange)buf1));
                Assert.assertEquals((String)"Did not skip enough bytes.", (long)5L, (long)(buf1.getPosition() - 1));
                buf1.setPosition(1);
                Assert.assertEquals((String)"Deserialization failed.", (long)Float.floatToIntBits(vals[i].floatValue()), (long)Float.floatToIntBits(OrderedBytes.decodeFloat32((PositionedByteRange)buf1)));
                Assert.assertEquals((String)"Did not consume enough bytes.", (long)5L, (long)(buf1.getPosition() - 1));
            }
        }
        for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
            byte[][] encoded = new byte[vals.length][5];
            SimplePositionedByteRange pbr = new SimplePositionedByteRange();
            for (int i = 0; i < vals.length; ++i) {
                OrderedBytes.encodeFloat32((PositionedByteRange)pbr.set(encoded[i]), (float)vals[i].floatValue(), (Order)ord);
            }
            Arrays.sort(encoded, Bytes.BYTES_COMPARATOR);
            Object[] sortedVals = Arrays.copyOf(vals, vals.length);
            if (ord == Order.ASCENDING) {
                Arrays.sort(sortedVals);
            } else {
                Arrays.sort(sortedVals, Collections.reverseOrder());
            }
            for (int i = 0; i < sortedVals.length; ++i) {
                float decoded = OrderedBytes.decodeFloat32((PositionedByteRange)pbr.set(encoded[i]));
                Assert.assertEquals((String)String.format("Encoded representations do not preserve natural order: <%s>, <%s>, %s", sortedVals[i], Float.valueOf(decoded), ord), (long)Float.floatToIntBits(((Float)sortedVals[i]).floatValue()), (long)Float.floatToIntBits(decoded));
            }
        }
    }

    @Test
    public void testFloat64() {
        Double[] vals = new Double[]{Double.MIN_VALUE, 1.0, 0.0, 8.988465674311579E307, Double.MAX_VALUE};
        for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
            for (int i = 0; i < vals.length; ++i) {
                byte[] a = new byte[12];
                SimplePositionedByteRange buf1 = new SimplePositionedByteRange(a, 1, 10);
                buf1.setPosition(1);
                Assert.assertEquals((String)"Surprising return value.", (long)9L, (long)OrderedBytes.encodeFloat64((PositionedByteRange)buf1, (double)vals[i], (Order)ord));
                Assert.assertEquals((String)"Broken test: serialization did not consume entire buffer.", (long)buf1.getLength(), (long)buf1.getPosition());
                Assert.assertEquals((String)"Surprising serialized length.", (long)9L, (long)(buf1.getPosition() - 1));
                Assert.assertEquals((String)"Buffer underflow.", (long)0L, (long)a[0]);
                Assert.assertEquals((String)"Buffer underflow.", (long)0L, (long)a[1]);
                Assert.assertEquals((String)"Buffer overflow.", (long)0L, (long)a[a.length - 1]);
                buf1.setPosition(1);
                Assert.assertEquals((String)"Surprising return value.", (long)9L, (long)OrderedBytes.skip((PositionedByteRange)buf1));
                Assert.assertEquals((String)"Did not skip enough bytes.", (long)9L, (long)(buf1.getPosition() - 1));
                buf1.setPosition(1);
                Assert.assertEquals((String)"Deserialization failed.", (long)Double.doubleToLongBits(vals[i]), (long)Double.doubleToLongBits(OrderedBytes.decodeFloat64((PositionedByteRange)buf1)));
                Assert.assertEquals((String)"Did not consume enough bytes.", (long)9L, (long)(buf1.getPosition() - 1));
            }
        }
        for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
            byte[][] encoded = new byte[vals.length][9];
            SimplePositionedByteRange pbr = new SimplePositionedByteRange();
            for (int i = 0; i < vals.length; ++i) {
                OrderedBytes.encodeFloat64((PositionedByteRange)pbr.set(encoded[i]), (double)vals[i], (Order)ord);
            }
            Arrays.sort(encoded, Bytes.BYTES_COMPARATOR);
            Object[] sortedVals = Arrays.copyOf(vals, vals.length);
            if (ord == Order.ASCENDING) {
                Arrays.sort(sortedVals);
            } else {
                Arrays.sort(sortedVals, Collections.reverseOrder());
            }
            for (int i = 0; i < sortedVals.length; ++i) {
                double decoded = OrderedBytes.decodeFloat64((PositionedByteRange)pbr.set(encoded[i]));
                Assert.assertEquals((String)String.format("Encoded representations do not preserve natural order: <%s>, <%s>, %s", sortedVals[i], decoded, ord), (long)Double.doubleToLongBits((Double)sortedVals[i]), (long)Double.doubleToLongBits(decoded));
            }
        }
    }

    @Test
    public void testString() {
        String[] vals = new String[]{"foo", "baaaar", "bazz"};
        int[] expectedLengths = new int[]{5, 8, 6};
        for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
            for (int i = 0; i < vals.length; ++i) {
                byte[] a = new byte[expectedLengths[i] + 3];
                SimplePositionedByteRange buf1 = new SimplePositionedByteRange(a, 1, expectedLengths[i] + 1);
                buf1.setPosition(1);
                Assert.assertEquals((String)"Surprising return value.", (long)expectedLengths[i], (long)OrderedBytes.encodeString((PositionedByteRange)buf1, (String)vals[i], (Order)ord));
                Assert.assertEquals((String)"Broken test: serialization did not consume entire buffer.", (long)buf1.getLength(), (long)buf1.getPosition());
                Assert.assertEquals((String)"Surprising serialized length.", (long)expectedLengths[i], (long)(buf1.getPosition() - 1));
                Assert.assertEquals((String)"Buffer underflow.", (long)0L, (long)a[0]);
                Assert.assertEquals((String)"Buffer underflow.", (long)0L, (long)a[1]);
                Assert.assertEquals((String)"Buffer overflow.", (long)0L, (long)a[a.length - 1]);
                buf1.setPosition(1);
                Assert.assertEquals((String)"Surprising return value.", (long)expectedLengths[i], (long)OrderedBytes.skip((PositionedByteRange)buf1));
                Assert.assertEquals((String)"Did not skip enough bytes.", (long)expectedLengths[i], (long)(buf1.getPosition() - 1));
                buf1.setPosition(1);
                Assert.assertEquals((String)"Deserialization failed.", (Object)vals[i], (Object)OrderedBytes.decodeString((PositionedByteRange)buf1));
                Assert.assertEquals((String)"Did not consume enough bytes.", (long)expectedLengths[i], (long)(buf1.getPosition() - 1));
            }
        }
        for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
            byte[][] encoded = new byte[vals.length][];
            SimplePositionedByteRange pbr = new SimplePositionedByteRange();
            for (int i = 0; i < vals.length; ++i) {
                encoded[i] = new byte[expectedLengths[i]];
                OrderedBytes.encodeString((PositionedByteRange)pbr.set(encoded[i]), (String)vals[i], (Order)ord);
            }
            Arrays.sort(encoded, Bytes.BYTES_COMPARATOR);
            Object[] sortedVals = Arrays.copyOf(vals, vals.length);
            if (ord == Order.ASCENDING) {
                Arrays.sort(sortedVals);
            } else {
                Arrays.sort(sortedVals, Collections.reverseOrder());
            }
            for (int i = 0; i < sortedVals.length; ++i) {
                pbr.set(encoded[i]);
                String decoded = OrderedBytes.decodeString((PositionedByteRange)pbr);
                Assert.assertEquals((String)String.format("Encoded representations do not preserve natural order: <%s>, <%s>, %s", sortedVals[i], decoded, ord), (Object)sortedVals[i], (Object)decoded);
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testStringNoNullChars() {
        SimplePositionedByteRange buff = new SimplePositionedByteRange(3);
        OrderedBytes.encodeString((PositionedByteRange)buff, (String)"\u0000", (Order)Order.ASCENDING);
    }

    @Test
    public void testBlobVarLencodedLength() {
        int[][] values;
        for (int[] pair : values = new int[][]{{1, 3}, {2, 4}, {3, 5}, {4, 6}, {5, 7}, {6, 8}, {7, 9}, {8, 11}}) {
            Assert.assertEquals((long)pair[1], (long)OrderedBytes.blobVarEncodedLength((int)pair[0]));
            Assert.assertEquals((long)pair[0], (long)OrderedBytes.blobVarDecodedLength((int)pair[1]));
        }
    }

    @Test
    public void testBlobVar() {
        byte[][] vals = new byte[][]{"".getBytes(), "foo".getBytes(), "foobarbazbub".getBytes(), {-86, -86, -86, -86, -86, -86, -86}, {-86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86}, {-86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86}, {85, 85, 85, 85, 85, 85, 85}, {85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85}, {85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85}, "1".getBytes(), "22".getBytes(), "333".getBytes(), "4444".getBytes(), "55555".getBytes(), "666666".getBytes(), "7777777".getBytes(), "88888888".getBytes()};
        for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
            for (byte[] val : vals) {
                int expectedLen = OrderedBytes.blobVarEncodedLength((int)val.length);
                byte[] a = new byte[expectedLen + 3];
                SimplePositionedByteRange buf1 = new SimplePositionedByteRange(a, 1, expectedLen + 1);
                buf1.setPosition(1);
                Assert.assertEquals((String)"Surprising return value.", (long)expectedLen, (long)OrderedBytes.encodeBlobVar((PositionedByteRange)buf1, (byte[])val, (Order)ord));
                Assert.assertEquals((String)"Broken test: serialization did not consume entire buffer.", (long)buf1.getLength(), (long)buf1.getPosition());
                Assert.assertEquals((String)"Surprising serialized length.", (long)expectedLen, (long)(buf1.getPosition() - 1));
                Assert.assertEquals((String)"Buffer underflow.", (long)0L, (long)a[0]);
                Assert.assertEquals((String)"Buffer underflow.", (long)0L, (long)a[1]);
                Assert.assertEquals((String)"Buffer overflow.", (long)0L, (long)a[a.length - 1]);
                buf1.setPosition(1);
                Assert.assertEquals((String)"Surprising return value.", (long)expectedLen, (long)OrderedBytes.skip((PositionedByteRange)buf1));
                Assert.assertEquals((String)"Did not skip enough bytes.", (long)expectedLen, (long)(buf1.getPosition() - 1));
                buf1.setPosition(1);
                Assert.assertArrayEquals((String)"Deserialization failed.", (byte[])val, (byte[])OrderedBytes.decodeBlobVar((PositionedByteRange)buf1));
                Assert.assertEquals((String)"Did not consume enough bytes.", (long)expectedLen, (long)(buf1.getPosition() - 1));
            }
        }
        for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
            byte[][] encoded = new byte[vals.length][];
            SimplePositionedByteRange pbr = new SimplePositionedByteRange();
            for (int i = 0; i < vals.length; ++i) {
                encoded[i] = new byte[OrderedBytes.blobVarEncodedLength((int)vals[i].length)];
                OrderedBytes.encodeBlobVar((PositionedByteRange)pbr.set(encoded[i]), (byte[])vals[i], (Order)ord);
            }
            Arrays.sort(encoded, Bytes.BYTES_COMPARATOR);
            byte[][] sortedVals = (byte[][])Arrays.copyOf(vals, vals.length);
            if (ord == Order.ASCENDING) {
                Arrays.sort(sortedVals, Bytes.BYTES_COMPARATOR);
            } else {
                Arrays.sort(sortedVals, Collections.reverseOrder(Bytes.BYTES_COMPARATOR));
            }
            for (int i = 0; i < sortedVals.length; ++i) {
                pbr.set(encoded[i]);
                byte[] decoded = OrderedBytes.decodeBlobVar((PositionedByteRange)pbr);
                Assert.assertArrayEquals((String)String.format("Encoded representations do not preserve natural order: <%s>, <%s>, %s", Arrays.toString(sortedVals[i]), Arrays.toString(decoded), ord), (byte[])sortedVals[i], (byte[])decoded);
            }
        }
    }

    @Test
    public void testBlobCopy() {
        byte[][] vals = new byte[][]{"".getBytes(), "foo".getBytes(), "foobarbazbub".getBytes(), {-86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86}, {85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85}};
        for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
            for (byte[] val : vals) {
                int expectedLen = val.length + (Order.ASCENDING == ord ? 1 : 2);
                byte[] a = new byte[expectedLen + 3];
                SimplePositionedByteRange buf1 = new SimplePositionedByteRange(a, 1, expectedLen + 1);
                buf1.setPosition(1);
                Assert.assertEquals((String)"Surprising return value.", (long)expectedLen, (long)OrderedBytes.encodeBlobCopy((PositionedByteRange)buf1, (byte[])val, (Order)ord));
                Assert.assertEquals((String)"Broken test: serialization did not consume entire buffer.", (long)buf1.getLength(), (long)buf1.getPosition());
                Assert.assertEquals((String)"Surprising serialized length.", (long)expectedLen, (long)(buf1.getPosition() - 1));
                Assert.assertEquals((String)"Buffer underflow.", (long)0L, (long)a[0]);
                Assert.assertEquals((String)"Buffer underflow.", (long)0L, (long)a[1]);
                Assert.assertEquals((String)"Buffer overflow.", (long)0L, (long)a[a.length - 1]);
                buf1.setPosition(1);
                Assert.assertEquals((String)"Surprising return value.", (long)expectedLen, (long)OrderedBytes.skip((PositionedByteRange)buf1));
                Assert.assertEquals((String)"Did not skip enough bytes.", (long)expectedLen, (long)(buf1.getPosition() - 1));
                buf1.setPosition(1);
                Assert.assertArrayEquals((String)"Deserialization failed.", (byte[])val, (byte[])OrderedBytes.decodeBlobCopy((PositionedByteRange)buf1));
                Assert.assertEquals((String)"Did not consume enough bytes.", (long)expectedLen, (long)(buf1.getPosition() - 1));
            }
        }
        for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
            byte[][] encoded = new byte[vals.length][];
            SimplePositionedByteRange pbr = new SimplePositionedByteRange();
            for (int i = 0; i < vals.length; ++i) {
                encoded[i] = new byte[vals[i].length + (Order.ASCENDING == ord ? 1 : 2)];
                OrderedBytes.encodeBlobCopy((PositionedByteRange)pbr.set(encoded[i]), (byte[])vals[i], (Order)ord);
            }
            Arrays.sort(encoded, Bytes.BYTES_COMPARATOR);
            byte[][] sortedVals = (byte[][])Arrays.copyOf(vals, vals.length);
            if (ord == Order.ASCENDING) {
                Arrays.sort(sortedVals, Bytes.BYTES_COMPARATOR);
            } else {
                Arrays.sort(sortedVals, Collections.reverseOrder(Bytes.BYTES_COMPARATOR));
            }
            for (int i = 0; i < sortedVals.length; ++i) {
                pbr.set(encoded[i]);
                byte[] decoded = OrderedBytes.decodeBlobCopy((PositionedByteRange)pbr);
                Assert.assertArrayEquals((String)String.format("Encoded representations do not preserve natural order: <%s>, <%s>, %s", Arrays.toString(sortedVals[i]), Arrays.toString(decoded), ord), (byte[])sortedVals[i], (byte[])decoded);
            }
        }
        for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
            byte[] a = new byte[3 + (Order.ASCENDING == ord ? 1 : 2) + 2];
            SimplePositionedByteRange buf = new SimplePositionedByteRange(a, 1, 3 + (Order.ASCENDING == ord ? 1 : 2));
            OrderedBytes.encodeBlobCopy((PositionedByteRange)buf, (byte[])"foobarbaz".getBytes(), (int)3, (int)3, (Order)ord);
            buf.setPosition(0);
            Assert.assertArrayEquals((byte[])"bar".getBytes(), (byte[])OrderedBytes.decodeBlobCopy((PositionedByteRange)buf));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBlobCopyNoZeroBytes() {
        byte[] val = new byte[]{1, 2, 0, 3};
        byte[] ascExpected = new byte[]{56, 1, 2, 0, 3};
        SimplePositionedByteRange buf = new SimplePositionedByteRange(val.length + 1);
        OrderedBytes.encodeBlobCopy((PositionedByteRange)buf, (byte[])val, (Order)Order.ASCENDING);
        Assert.assertArrayEquals((byte[])ascExpected, (byte[])buf.getBytes());
        buf.set(val.length + 2);
        OrderedBytes.encodeBlobCopy((PositionedByteRange)buf, (byte[])val, (Order)Order.DESCENDING);
        Assert.fail((String)"test should never get here.");
    }

    @Test
    public void testSkip() {
        BigDecimal longMax = BigDecimal.valueOf(Long.MAX_VALUE);
        double negInf = Double.NEGATIVE_INFINITY;
        BigDecimal negLarge = longMax.multiply(longMax).negate();
        BigDecimal negMed = new BigDecimal("-10.0");
        BigDecimal negSmall = new BigDecimal("-0.0010");
        long zero = 0L;
        BigDecimal posSmall = negSmall.negate();
        BigDecimal posMed = negMed.negate();
        BigDecimal posLarge = negLarge.negate();
        double posInf = Double.POSITIVE_INFINITY;
        double nan = Double.NaN;
        byte int8 = 100;
        short int16 = 100;
        int int32 = 100;
        long int64 = 100L;
        float float32 = 100.0f;
        double float64 = 100.0;
        String text = "hello world.";
        byte[] blobVar = Bytes.toBytes((String)"foo");
        byte[] blobCopy = Bytes.toBytes((String)"bar");
        for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
            SimplePositionedByteRange buff = new SimplePositionedByteRange(30);
            int o = OrderedBytes.encodeNull((PositionedByteRange)buff, (Order)ord);
            buff.setPosition(0);
            Assert.assertEquals((long)o, (long)OrderedBytes.skip((PositionedByteRange)buff));
            buff.setPosition(0);
            o = OrderedBytes.encodeNumeric((PositionedByteRange)buff, (double)negInf, (Order)ord);
            buff.setPosition(0);
            Assert.assertEquals((long)o, (long)OrderedBytes.skip((PositionedByteRange)buff));
            buff.setPosition(0);
            o = OrderedBytes.encodeNumeric((PositionedByteRange)buff, (BigDecimal)negLarge, (Order)ord);
            buff.setPosition(0);
            Assert.assertEquals((long)o, (long)OrderedBytes.skip((PositionedByteRange)buff));
            buff.setPosition(0);
            o = OrderedBytes.encodeNumeric((PositionedByteRange)buff, (BigDecimal)negMed, (Order)ord);
            buff.setPosition(0);
            Assert.assertEquals((long)o, (long)OrderedBytes.skip((PositionedByteRange)buff));
            buff.setPosition(0);
            o = OrderedBytes.encodeNumeric((PositionedByteRange)buff, (BigDecimal)negSmall, (Order)ord);
            buff.setPosition(0);
            Assert.assertEquals((long)o, (long)OrderedBytes.skip((PositionedByteRange)buff));
            buff.setPosition(0);
            o = OrderedBytes.encodeNumeric((PositionedByteRange)buff, (long)zero, (Order)ord);
            buff.setPosition(0);
            Assert.assertEquals((long)o, (long)OrderedBytes.skip((PositionedByteRange)buff));
            buff.setPosition(0);
            o = OrderedBytes.encodeNumeric((PositionedByteRange)buff, (BigDecimal)posSmall, (Order)ord);
            buff.setPosition(0);
            Assert.assertEquals((long)o, (long)OrderedBytes.skip((PositionedByteRange)buff));
            buff.setPosition(0);
            o = OrderedBytes.encodeNumeric((PositionedByteRange)buff, (BigDecimal)posMed, (Order)ord);
            buff.setPosition(0);
            Assert.assertEquals((long)o, (long)OrderedBytes.skip((PositionedByteRange)buff));
            buff.setPosition(0);
            o = OrderedBytes.encodeNumeric((PositionedByteRange)buff, (BigDecimal)posLarge, (Order)ord);
            buff.setPosition(0);
            Assert.assertEquals((long)o, (long)OrderedBytes.skip((PositionedByteRange)buff));
            buff.setPosition(0);
            o = OrderedBytes.encodeNumeric((PositionedByteRange)buff, (double)posInf, (Order)ord);
            buff.setPosition(0);
            Assert.assertEquals((long)o, (long)OrderedBytes.skip((PositionedByteRange)buff));
            buff.setPosition(0);
            o = OrderedBytes.encodeNumeric((PositionedByteRange)buff, (double)nan, (Order)ord);
            buff.setPosition(0);
            Assert.assertEquals((long)o, (long)OrderedBytes.skip((PositionedByteRange)buff));
            buff.setPosition(0);
            o = OrderedBytes.encodeInt8((PositionedByteRange)buff, (byte)int8, (Order)ord);
            buff.setPosition(0);
            Assert.assertEquals((long)o, (long)OrderedBytes.skip((PositionedByteRange)buff));
            buff.setPosition(0);
            o = OrderedBytes.encodeInt16((PositionedByteRange)buff, (short)int16, (Order)ord);
            buff.setPosition(0);
            Assert.assertEquals((long)o, (long)OrderedBytes.skip((PositionedByteRange)buff));
            buff.setPosition(0);
            o = OrderedBytes.encodeInt32((PositionedByteRange)buff, (int)int32, (Order)ord);
            buff.setPosition(0);
            Assert.assertEquals((long)o, (long)OrderedBytes.skip((PositionedByteRange)buff));
            buff.setPosition(0);
            o = OrderedBytes.encodeInt64((PositionedByteRange)buff, (long)int64, (Order)ord);
            buff.setPosition(0);
            Assert.assertEquals((long)o, (long)OrderedBytes.skip((PositionedByteRange)buff));
            buff.setPosition(0);
            o = OrderedBytes.encodeFloat32((PositionedByteRange)buff, (float)float32, (Order)ord);
            buff.setPosition(0);
            Assert.assertEquals((long)o, (long)OrderedBytes.skip((PositionedByteRange)buff));
            buff.setPosition(0);
            o = OrderedBytes.encodeFloat64((PositionedByteRange)buff, (double)float64, (Order)ord);
            buff.setPosition(0);
            Assert.assertEquals((long)o, (long)OrderedBytes.skip((PositionedByteRange)buff));
            buff.setPosition(0);
            o = OrderedBytes.encodeString((PositionedByteRange)buff, (String)text, (Order)ord);
            buff.setPosition(0);
            Assert.assertEquals((long)o, (long)OrderedBytes.skip((PositionedByteRange)buff));
            buff.setPosition(0);
            o = OrderedBytes.encodeBlobVar((PositionedByteRange)buff, (byte[])blobVar, (Order)ord);
            buff.setPosition(0);
            Assert.assertEquals((long)o, (long)OrderedBytes.skip((PositionedByteRange)buff));
            buff.set(blobCopy.length + (Order.ASCENDING == ord ? 1 : 2));
            o = OrderedBytes.encodeBlobCopy((PositionedByteRange)buff, (byte[])blobCopy, (Order)ord);
            buff.setPosition(0);
            Assert.assertEquals((long)o, (long)OrderedBytes.skip((PositionedByteRange)buff));
        }
    }
}

