/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.LongAdder;
import org.apache.hbase.thirdparty.com.google.gson.GsonBuilder;
import org.apache.hbase.thirdparty.com.google.gson.LongSerializationPolicy;
import org.apache.hbase.thirdparty.com.google.gson.TypeAdapter;
import org.apache.hbase.thirdparty.com.google.gson.stream.JsonReader;
import org.apache.hbase.thirdparty.com.google.gson.stream.JsonWriter;

@InterfaceAudience.Private
public final class GsonUtil {
    private GsonUtil() {
    }

    public static GsonBuilder createGson() {
        return new GsonBuilder().setLongSerializationPolicy(LongSerializationPolicy.STRING).registerTypeAdapter(LongAdder.class, (Object)new TypeAdapter<LongAdder>(){

            public void write(JsonWriter out, LongAdder value) throws IOException {
                out.value(value.longValue());
            }

            public LongAdder read(JsonReader in) throws IOException {
                LongAdder value = new LongAdder();
                value.add(in.nextLong());
                return value;
            }
        });
    }
}

