/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.IterableUtils;
import org.apache.hadoop.hbase.util.Strings;

@InterfaceAudience.Private
public class KeyValueTestUtil {
    public static KeyValue create(String row, String family, String qualifier, long timestamp, String value) {
        return KeyValueTestUtil.create(row, family, qualifier, timestamp, KeyValue.Type.Put, value);
    }

    public static KeyValue create(String row, String family, String qualifier, long timestamp, KeyValue.Type type, String value) {
        return new KeyValue(Bytes.toBytes(row), Bytes.toBytes(family), Bytes.toBytes(qualifier), timestamp, type, Bytes.toBytes(value));
    }

    public static ByteBuffer toByteBufferAndRewind(Iterable<? extends KeyValue> kvs, boolean includeMemstoreTS) {
        int totalBytes = KeyValueUtil.totalLengthWithMvccVersion(kvs, includeMemstoreTS);
        ByteBuffer bb = ByteBuffer.allocate(totalBytes);
        for (KeyValue keyValue : IterableUtils.nullSafe(kvs)) {
            KeyValueUtil.appendToByteBuffer(bb, keyValue, includeMemstoreTS);
        }
        bb.rewind();
        return bb;
    }

    public static boolean containsIgnoreMvccVersion(Collection<? extends Cell> kvCollection1, Collection<? extends Cell> kvCollection2) {
        for (Cell cell : kvCollection1) {
            boolean found = false;
            for (Cell cell2 : kvCollection2) {
                if (!CellUtil.equalsIgnoreMvccVersion(cell, cell2)) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static List<KeyValue> rewindThenToList(ByteBuffer bb, boolean includesMemstoreTS, boolean useTags) {
        bb.rewind();
        ArrayList kvs = Lists.newArrayList();
        KeyValue kv = null;
        while ((kv = KeyValueUtil.nextShallowCopy(bb, includesMemstoreTS, useTags)) != null) {
            kvs.add(kv);
        }
        return kvs;
    }

    public static String toStringWithPadding(Collection<? extends KeyValue> kvs, boolean includeMeta) {
        int maxRowStringLength = 0;
        int maxFamilyStringLength = 0;
        int maxQualifierStringLength = 0;
        int maxTimestampLength = 0;
        for (KeyValue keyValue : kvs) {
            maxRowStringLength = Math.max(maxRowStringLength, KeyValueTestUtil.getRowString(keyValue).length());
            maxFamilyStringLength = Math.max(maxFamilyStringLength, KeyValueTestUtil.getFamilyString(keyValue).length());
            maxQualifierStringLength = Math.max(maxQualifierStringLength, KeyValueTestUtil.getQualifierString(keyValue).length());
            maxTimestampLength = Math.max(maxTimestampLength, Long.valueOf(keyValue.getTimestamp()).toString().length());
        }
        StringBuilder sb = new StringBuilder();
        for (KeyValue keyValue : kvs) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            String row = KeyValueTestUtil.toStringWithPadding(keyValue, maxRowStringLength, maxFamilyStringLength, maxQualifierStringLength, maxTimestampLength, includeMeta);
            sb.append(row);
        }
        return sb.toString();
    }

    protected static String toStringWithPadding(KeyValue kv, int maxRowLength, int maxFamilyLength, int maxQualifierLength, int maxTimestampLength, boolean includeMeta) {
        String leadingLengths = "";
        String familyLength = kv.getFamilyLength() + " ";
        if (includeMeta) {
            leadingLengths = leadingLengths + Strings.padFront(kv.getKeyLength() + "", '0', 4);
            leadingLengths = leadingLengths + " ";
            leadingLengths = leadingLengths + Strings.padFront(kv.getValueLength() + "", '0', 4);
            leadingLengths = leadingLengths + " ";
            leadingLengths = leadingLengths + Strings.padFront(kv.getRowLength() + "", '0', 2);
            leadingLengths = leadingLengths + " ";
        }
        int spacesAfterRow = maxRowLength - KeyValueTestUtil.getRowString(kv).length() + 2;
        int spacesAfterFamily = maxFamilyLength - KeyValueTestUtil.getFamilyString(kv).length() + 2;
        int spacesAfterQualifier = maxQualifierLength - KeyValueTestUtil.getQualifierString(kv).length() + 1;
        int spacesAfterTimestamp = maxTimestampLength - Long.valueOf(kv.getTimestamp()).toString().length() + 1;
        return leadingLengths + KeyValueTestUtil.getRowString(kv) + Strings.repeat(' ', spacesAfterRow) + familyLength + KeyValueTestUtil.getFamilyString(kv) + Strings.repeat(' ', spacesAfterFamily) + KeyValueTestUtil.getQualifierString(kv) + Strings.repeat(' ', spacesAfterQualifier) + KeyValueTestUtil.getTimestampString(kv) + Strings.repeat(' ', spacesAfterTimestamp) + KeyValueTestUtil.getTypeString(kv) + " " + KeyValueTestUtil.getValueString(kv);
    }

    protected static String getRowString(KeyValue kv) {
        return Bytes.toStringBinary(kv.getRowArray(), kv.getRowOffset(), kv.getRowLength());
    }

    protected static String getFamilyString(KeyValue kv) {
        return Bytes.toStringBinary(kv.getFamilyArray(), kv.getFamilyOffset(), kv.getFamilyLength());
    }

    protected static String getQualifierString(KeyValue kv) {
        return Bytes.toStringBinary(kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength());
    }

    protected static String getTimestampString(KeyValue kv) {
        return kv.getTimestamp() + "";
    }

    protected static String getTypeString(KeyValue kv) {
        return KeyValue.Type.codeToType(kv.getTypeByte()).toString();
    }

    protected static String getValueString(KeyValue kv) {
        return Bytes.toStringBinary(kv.getValueArray(), kv.getValueOffset(), kv.getValueLength());
    }
}

