/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import org.apache.hadoop.hbase.ProcedureState;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.NonceKey;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Public
public class ProcedureInfo
implements Cloneable {
    private final long procId;
    private final String procName;
    private final String procOwner;
    private final ProcedureState procState;
    private final long parentId;
    private final NonceKey nonceKey;
    private final IOException exception;
    private final long lastUpdate;
    private final long submittedTime;
    private final byte[] result;
    private long clientAckTime = -1L;

    @InterfaceAudience.Private
    public ProcedureInfo(long procId, String procName, String procOwner, ProcedureState procState, long parentId, NonceKey nonceKey, IOException exception, long lastUpdate, long submittedTime, byte[] result) {
        this.procId = procId;
        this.procName = procName;
        this.procOwner = procOwner;
        this.procState = procState;
        this.parentId = parentId;
        this.nonceKey = nonceKey;
        this.lastUpdate = lastUpdate;
        this.submittedTime = submittedTime;
        this.exception = exception;
        this.result = result;
    }

    @SuppressWarnings(value={"CN_IDIOM_NO_SUPER_CALL"}, justification="Intentional; calling super class clone doesn't make sense here.")
    public ProcedureInfo clone() {
        return new ProcedureInfo(this.procId, this.procName, this.procOwner, this.procState, this.parentId, this.nonceKey, this.exception, this.lastUpdate, this.submittedTime, this.result);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.procName);
        sb.append(" pid=");
        sb.append(this.procId);
        if (this.hasParentId()) {
            sb.append(", ppid=");
            sb.append(this.parentId);
        }
        if (this.hasOwner()) {
            sb.append(", owner=");
            sb.append(this.procOwner);
        }
        sb.append(", state=");
        sb.append((Object)this.procState);
        long now = EnvironmentEdgeManager.currentTime();
        sb.append(", submittedTime=");
        sb.append(StringUtils.formatTime((long)(now - this.submittedTime)));
        sb.append(" ago, lastUpdate=");
        sb.append(StringUtils.formatTime((long)(now - this.submittedTime)));
        sb.append(" ago");
        if (this.isFailed()) {
            sb.append(", exception=\"");
            sb.append(this.exception.getMessage());
            sb.append("\"");
        }
        return sb.toString();
    }

    public long getProcId() {
        return this.procId;
    }

    public String getProcName() {
        return this.procName;
    }

    public boolean hasOwner() {
        return this.procOwner != null;
    }

    public String getProcOwner() {
        return this.procOwner;
    }

    public ProcedureState getProcState() {
        return this.procState;
    }

    public boolean hasParentId() {
        return this.parentId != -1L;
    }

    public long getParentId() {
        return this.parentId;
    }

    public NonceKey getNonceKey() {
        return this.nonceKey;
    }

    public boolean isFailed() {
        return this.exception != null;
    }

    public IOException getException() {
        if (this.isFailed()) {
            return this.exception;
        }
        return null;
    }

    public String getExceptionFullMessage() {
        assert (this.isFailed());
        IOException e = this.getException();
        return e.getCause() + " - " + e.getMessage();
    }

    public boolean hasResultData() {
        return this.result != null;
    }

    public byte[] getResult() {
        return this.result;
    }

    public long getSubmittedTime() {
        return this.submittedTime;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public long executionTime() {
        return this.lastUpdate - this.submittedTime;
    }

    @InterfaceAudience.Private
    public boolean hasClientAckTime() {
        return this.clientAckTime != -1L;
    }

    @InterfaceAudience.Private
    public long getClientAckTime() {
        return this.clientAckTime;
    }

    @InterfaceAudience.Private
    public void setClientAckTime(long timestamp) {
        this.clientAckTime = timestamp;
    }

    @InterfaceAudience.Private
    public static boolean isProcedureOwner(ProcedureInfo procInfo, User user) {
        if (user == null) {
            return false;
        }
        String procOwner = procInfo.getProcOwner();
        if (procOwner == null) {
            return false;
        }
        return procOwner.equals(user.getShortName());
    }
}

